/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material.properties;

import gregtech.api.unification.material.properties.BlastProperty;
import gregtech.api.unification.material.properties.DustProperty;
import gregtech.api.unification.material.properties.FluidPipeProperties;
import gregtech.api.unification.material.properties.FluidProperty;
import gregtech.api.unification.material.properties.GemProperty;
import gregtech.api.unification.material.properties.IMaterialProperty;
import gregtech.api.unification.material.properties.IngotProperty;
import gregtech.api.unification.material.properties.ItemPipeProperties;
import gregtech.api.unification.material.properties.MaterialProperties;
import gregtech.api.unification.material.properties.OreProperty;
import gregtech.api.unification.material.properties.PolymerProperty;
import gregtech.api.unification.material.properties.RotorProperty;
import gregtech.api.unification.material.properties.ToolProperty;
import gregtech.api.unification.material.properties.WireProperties;
import gregtech.api.unification.material.properties.WoodProperty;

public class PropertyKey<T extends IMaterialProperty> {
    public static final PropertyKey<BlastProperty> BLAST = new PropertyKey<BlastProperty>("blast", BlastProperty.class);
    public static final PropertyKey<DustProperty> DUST = new PropertyKey<DustProperty>("dust", DustProperty.class);
    public static final PropertyKey<FluidPipeProperties> FLUID_PIPE = new PropertyKey<FluidPipeProperties>("fluid_pipe", FluidPipeProperties.class);
    public static final PropertyKey<FluidProperty> FLUID = new PropertyKey<FluidProperty>("fluid", FluidProperty.class);
    public static final PropertyKey<GemProperty> GEM = new PropertyKey<GemProperty>("gem", GemProperty.class);
    public static final PropertyKey<IngotProperty> INGOT = new PropertyKey<IngotProperty>("ingot", IngotProperty.class);
    public static final PropertyKey<PolymerProperty> POLYMER = new PropertyKey<PolymerProperty>("polymer", PolymerProperty.class);
    public static final PropertyKey<ItemPipeProperties> ITEM_PIPE = new PropertyKey<ItemPipeProperties>("item_pipe", ItemPipeProperties.class);
    public static final PropertyKey<OreProperty> ORE = new PropertyKey<OreProperty>("ore", OreProperty.class);
    public static final PropertyKey<ToolProperty> TOOL = new PropertyKey<ToolProperty>("tool", ToolProperty.class);
    public static final PropertyKey<RotorProperty> ROTOR = new PropertyKey<RotorProperty>("rotor", RotorProperty.class);
    public static final PropertyKey<WireProperties> WIRE = new PropertyKey<WireProperties>("wire", WireProperties.class);
    public static final PropertyKey<WoodProperty> WOOD = new PropertyKey<WoodProperty>("wood", WoodProperty.class);
    public static final PropertyKey<EmptyProperty> EMPTY = new PropertyKey<EmptyProperty>("empty", EmptyProperty.class);
    private final String key;
    private final Class<T> type;

    public PropertyKey(String key, Class<T> type) {
        this.key = key;
        this.type = type;
    }

    protected String getKey() {
        return this.key;
    }

    protected T constructDefault() {
        try {
            return (T)((IMaterialProperty)this.type.newInstance());
        }
        catch (Exception e) {
            return null;
        }
    }

    public T cast(IMaterialProperty property) {
        return (T)((IMaterialProperty)this.type.cast(property));
    }

    public boolean equals(Object o) {
        if (o instanceof PropertyKey) {
            return ((PropertyKey)o).getKey().equals(this.key);
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return this.key;
    }

    private static class EmptyProperty
    implements IMaterialProperty {
        private EmptyProperty() {
        }

        @Override
        public void verifyProperty(MaterialProperties properties) {
        }
    }
}

