/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.terminal.hardware;

import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.terminal.hardware.HardwareProvider;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Hardware {
    protected HardwareProvider provider;

    public abstract String getRegistryName();

    @SideOnly(value=Side.CLIENT)
    public String getLocalizedName() {
        return I18n.func_135052_a((String)("terminal.hw." + this.getRegistryName()), (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public IGuiTexture getIcon() {
        return GuiTextures.ICON_REMOVE;
    }

    public boolean isHardwareAdequate(Hardware demand) {
        return this.getClass() == demand.getClass() || this.getRegistryName().equals(demand.getRegistryName());
    }

    public final boolean hasHW() {
        return this.provider != null && this.provider.hasHardware(this.getRegistryName());
    }

    public final ItemStack getItem() {
        return this.provider.getHardwareItem(this.getRegistryName());
    }

    public final NBTTagCompound getNBT() {
        return this.provider.getHardwareNBT(this.getRegistryName());
    }

    public final boolean isCreative() {
        return this.provider != null && this.provider.isCreative();
    }

    @SideOnly(value=Side.CLIENT)
    public String addInformation() {
        return null;
    }

    protected abstract Hardware createHardware(ItemStack var1);

    public abstract NBTTagCompound acceptItemStack(ItemStack var1);

    public ItemStack onHardwareRemoved(ItemStack itemStack) {
        return itemStack;
    }
}

