/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.terminal.gui.widgets;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.resources.ColorRectTexture;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.terminal.gui.widgets.DraggableScrollableWidgetGroup;
import gregtech.api.terminal.gui.widgets.RectButtonWidget;
import gregtech.api.terminal.os.TerminalTheme;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TextEditorWidget
extends WidgetGroup {
    private static final TextureArea PALETTE = TextureArea.fullImage("textures/gui/widget/palette.png");
    private static final TextureArea STYLE = TextureArea.fullImage("textures/gui/widget/formatting.png");
    private final TextPanelWidget textPanelWidget;
    private static final Pattern COMMENT = Pattern.compile("(//.*|/\\*[\\s\\S]*?\\*/)|(#.*)");
    private static final Pattern STRING = Pattern.compile("(\"(?:[^\"\\\\]|\\\\[\\s\\S])*\"|'(?:[^'\\\\]|\\\\[\\s\\S])*')");
    private static final Pattern BOOL = Pattern.compile("\\b(true|false|null|undefined|NaN)\\b");
    private static final Pattern KEYWORD = Pattern.compile("\\b(import|var|for|if|else|return|this|while|new|function|switch|case|typeof|do|in|throw|try|catch|finally|with|instance|delete|void|break|continue)\\b");
    private static final Pattern KEYWORD_2 = Pattern.compile("\\b(String|int|long|boolean|float|double|byte|short|document|Date|Math|window|Object|location|navigator|Array|Number|Boolean|Function|RegExp)\\b");
    private static final Pattern VARIABLE = Pattern.compile("(?:[^\\W\\d]|\\$)[\\$\\w]*");
    private static final Pattern NUMBER = Pattern.compile("(0[xX][0-9a-fA-F]+|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?|\\.\\d+(?:[eE][+-]?\\d+)?)");
    private static final Pattern ANY = Pattern.compile("[\\s\\S]");

    public TextEditorWidget(int x, int y, int width, int height, Consumer<String> stringUpdate, boolean allowToolBox) {
        super(new Position(x, y), new Size(Math.max(width, allowToolBox ? 80 : width), Math.max(height, allowToolBox ? 32 : height)));
        this.textPanelWidget = new TextPanelWidget(0, 32, Math.max(width, allowToolBox ? 80 : width), Math.max(height, allowToolBox ? 32 : height) - 32, stringUpdate);
        this.addWidget(this.textPanelWidget);
        if (allowToolBox) {
            this.initToolBox();
        }
    }

    public TextEditorWidget setBackground(IGuiTexture background) {
        this.textPanelWidget.setBackground(background);
        return this;
    }

    public TextEditorWidget setContent(String content) {
        this.textPanelWidget.pageSetCurrent(content);
        return this;
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        this.textPanelWidget.setActive(active);
    }

    private void initToolBox() {
        int x;
        int y;
        TextFormatting[] formatting = TextFormatting.values();
        for (y = 0; y < 4; ++y) {
            for (x = 0; x < 4; ++x) {
                TextFormatting colorFormatting = formatting[y * 4 + x];
                this.addWidget(new RectButtonWidget(x * 8, y * 8, 8, 8, 1).setToggleButton((IGuiTexture)PALETTE.getSubArea(0.5 + (double)x * 0.125, (double)y * 0.25, 0.125, 0.25), (cd, pressed) -> {
                    if (pressed.booleanValue()) {
                        this.textPanelWidget.addFormatting(colorFormatting);
                    } else {
                        this.textPanelWidget.removeFormatting(colorFormatting);
                    }
                }).setValueSupplier(true, () -> colorFormatting == this.textPanelWidget.getFrontColorFormatting()).setIcon(PALETTE.getSubArea((double)x * 0.125, (double)y * 0.25, 0.125, 0.25)).setColors(0, -1, 0).setHoverText(colorFormatting.func_96297_d()));
            }
        }
        for (y = 0; y < 2; ++y) {
            TextFormatting styleFormatting;
            for (x = 0; x < 3 && (styleFormatting = formatting[16 + y * 3 + x]) != TextFormatting.RESET; ++x) {
                this.addWidget(new RectButtonWidget(x * 16 + 32, y * 16, 16, 16, 1).setToggleButton((IGuiTexture)STYLE.getSubArea(0.5 + (double)x * 1.0 / 6.0, (double)y * 0.5, 0.16666666666666666, 0.5), (cd, pressed) -> {
                    if (pressed.booleanValue()) {
                        this.textPanelWidget.addFormatting(styleFormatting);
                    } else {
                        this.textPanelWidget.removeFormatting(styleFormatting);
                    }
                }).setValueSupplier(true, () -> this.textPanelWidget.getFrontStyleFormatting().contains(styleFormatting)).setIcon(STYLE.getSubArea((double)x * 1.0 / 6.0, (double)y * 0.5, 0.16666666666666666, 0.5)).setColors(0, -1, 0).setHoverText(styleFormatting.func_96297_d()));
            }
        }
        this.addWidget(new RectButtonWidget(80, 0, 16, 16, 3).setToggleButton((IGuiTexture)new ColorRectTexture(TerminalTheme.COLOR_B_2.getColor()), (c, p) -> {
            this.textPanelWidget.allowMarkdown = p == false;
        }).setValueSupplier(true, () -> !this.textPanelWidget.allowMarkdown).setColors(TerminalTheme.COLOR_B_3.getColor(), TerminalTheme.COLOR_1.getColor(), TerminalTheme.COLOR_B_3.getColor()).setIcon(new ColorRectTexture(TerminalTheme.COLOR_7.getColor())).setHoverText("Check Markdown when Ctrl+V"));
        this.addWidget(new RectButtonWidget(80, 16, 16, 16, 3).setClickListener(clickData -> this.textPanelWidget.pageSetCurrent("")).setColors(TerminalTheme.COLOR_B_3.getColor(), TerminalTheme.COLOR_1.getColor(), TerminalTheme.COLOR_B_3.getColor()).setIcon(new ColorRectTexture(TerminalTheme.COLOR_7.getColor())).setHoverText("Clean Up"));
    }

    private static class TextPanelWidget
    extends DraggableScrollableWidgetGroup {
        public static final int SPACE = 0;
        public int updateCount;
        public String content;
        public int textHeight;
        public final Consumer<String> stringUpdate;
        public TextFormatting frontColor;
        public List<TextFormatting> frontStyle;
        public boolean allowMarkdown;
        private static final char SECTION_SIGN = '\u00a7';
        @SideOnly(value=Side.CLIENT)
        public FontRenderer fontRenderer;
        @SideOnly(value=Side.CLIENT)
        private static final Pattern R_CODE_PATTERN = Pattern.compile("(?i)\u00a7[R]");
        @SideOnly(value=Side.CLIENT)
        private static final Pattern COLOR_CODE_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-F]");

        public TextPanelWidget(int x, int y, int width, int height, Consumer<String> stringUpdate) {
            super(x, y, width, height);
            this.stringUpdate = stringUpdate;
            this.content = "";
            this.allowMarkdown = true;
            if (TextPanelWidget.isClientSide()) {
                this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
                this.textHeight = this.fontRenderer.func_78267_b(this.content, width - this.yBarWidth);
                this.frontColor = null;
                this.frontStyle = new ArrayList<TextFormatting>();
            }
        }

        @Override
        public int getMaxHeight() {
            return this.textHeight + 0 + this.xBarHeight;
        }

        @Override
        public void updateScreen() {
            super.updateScreen();
            ++this.updateCount;
        }

        @Override
        public boolean keyTyped(char typedChar, int keyCode) {
            if (!this.focus || !this.isActive()) {
                return false;
            }
            if (GuiScreen.func_175279_e((int)keyCode)) {
                this.pageInsertIntoCurrent(this.allowMarkdown ? TextPanelWidget.formatFromMarkdown(GuiScreen.func_146277_j()) : GuiScreen.func_146277_j());
                this.findFrontFormatting();
            } else {
                switch (keyCode) {
                    case 14: {
                        if (this.content.isEmpty()) break;
                        this.pageSetCurrent(this.content.substring(0, this.content.length() - 1));
                        break;
                    }
                    case 28: 
                    case 156: {
                        this.pageInsertIntoCurrent("\n");
                        break;
                    }
                    default: {
                        if (!ChatAllowedCharacters.func_71566_a((char)typedChar)) break;
                        this.pageInsertIntoCurrent(Character.toString(typedChar));
                    }
                }
            }
            if (this.getMaxHeight() > this.getSize().height) {
                this.setScrollYOffset(this.getMaxHeight() - this.getSize().height);
            } else {
                this.setScrollYOffset(0);
            }
            return true;
        }

        private static String formatFromMarkdown(String markdown) {
            StringBuilder builder = new StringBuilder();
            ArrayDeque<TextFormatting> stack = new ArrayDeque<TextFormatting>();
            int[] chars = markdown.chars().toArray();
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] == 92 && i + 1 < chars.length) {
                    if (chars[i + 1] == 42 || chars[i + 1] == 95 || chars[i + 1] == 126 || chars[i + 1] == 96) {
                        builder.append(chars[i + 1]);
                        ++i;
                        continue;
                    }
                    builder.append('\\');
                    continue;
                }
                if (chars[i] == 42 && i + 1 < chars.length && chars[i + 1] == 32) {
                    builder.append(' ').append(TextFormatting.BOLD).append('*').append(TextFormatting.RESET).append(' ');
                    ++i;
                    continue;
                }
                if (chars[i] == 42 && i + 1 < chars.length && chars[i + 1] == 42) {
                    TextPanelWidget.checkTextFormatting(builder, TextFormatting.BOLD, stack);
                    ++i;
                    continue;
                }
                if (chars[i] == 95) {
                    if (i - 1 == -1 || !Character.isLetterOrDigit(chars[i - 1])) {
                        TextPanelWidget.checkTextFormatting(builder, TextFormatting.ITALIC, stack);
                        continue;
                    }
                    if (i + 1 == chars.length || !Character.isLetterOrDigit(chars[i + 1])) {
                        TextPanelWidget.checkTextFormatting(builder, TextFormatting.ITALIC, stack);
                        continue;
                    }
                    builder.append('_');
                    continue;
                }
                if (chars[i] == 126) {
                    TextPanelWidget.checkTextFormatting(builder, TextFormatting.STRIKETHROUGH, stack);
                    continue;
                }
                if (chars[i] == 96 && i + 1 < chars.length && chars[i + 1] == 96 && i + 2 < chars.length && chars[i + 2] == 96) {
                    boolean find = false;
                    for (int j = i + 3; j < chars.length - 2; ++j) {
                        if (chars[j] != 96 || chars[j + 1] != 96 || chars[j + 2] != 96) continue;
                        find = true;
                        builder.append(TextPanelWidget.checkCode(markdown.substring(i + 3, j)));
                        i += j - i;
                    }
                    if (!find) {
                        builder.append("```");
                    }
                    i += 2;
                    continue;
                }
                if (chars[i] == 96) {
                    TextPanelWidget.checkTextFormatting(builder, TextFormatting.UNDERLINE, stack);
                    continue;
                }
                builder.append((char)chars[i]);
            }
            return builder.toString();
        }

        private static String checkCode(String code) {
            Pattern[] patterns = new Pattern[]{COMMENT, STRING, BOOL, KEYWORD, KEYWORD_2, VARIABLE, NUMBER, ANY};
            TextFormatting[] colors = new TextFormatting[]{TextFormatting.DARK_GRAY, TextFormatting.DARK_GREEN, TextFormatting.RED, TextFormatting.BLUE, TextFormatting.LIGHT_PURPLE, TextFormatting.BLACK, TextFormatting.RED, TextFormatting.DARK_PURPLE};
            StringBuilder builder = new StringBuilder();
            while (code.length() > 0) {
                boolean find = false;
                for (int i = 0; i < patterns.length; ++i) {
                    Matcher matcher = patterns[i].matcher(code);
                    if (!matcher.find() || matcher.start() != 0) continue;
                    builder.append(colors[i]).append(code, 0, matcher.end()).append(TextFormatting.RESET);
                    find = true;
                    code = code.substring(matcher.end());
                    break;
                }
                if (find) continue;
                builder.append(code.charAt(0));
                code = code.substring(1);
            }
            return builder.toString();
        }

        private static void checkTextFormatting(StringBuilder builder, TextFormatting formatting, Deque<TextFormatting> stack) {
            if (!stack.isEmpty() && stack.peek() == formatting) {
                builder.append(TextFormatting.RESET);
                stack.pop();
                for (TextFormatting pre : stack) {
                    builder.append(pre.toString());
                }
            } else {
                stack.push(formatting);
                builder.append(formatting.toString());
            }
        }

        private static TextFormatting lookAheadChars(String content, int index) {
            if (index > 1 && content.charAt(index - 2) == '\u00a7') {
                char t = content.charAt(index - 1);
                if ('0' <= t && t <= '9') {
                    return TextFormatting.values()[t - 48];
                }
                if ('a' <= t && t <= 'f') {
                    return TextFormatting.values()[t - 97 + 10];
                }
                if ('k' <= t && t <= 'o') {
                    return TextFormatting.values()[t - 107 + 16];
                }
                if (t == 'r') {
                    return TextFormatting.values()[21];
                }
            }
            return null;
        }

        public static String cleanUpFormatting(String content) {
            TextFormatting ahead;
            int index;
            HashSet<Integer> removed = new HashSet<Integer>();
            Matcher marcher = R_CODE_PATTERN.matcher(content);
            while (marcher.find()) {
                for (index = marcher.start(); index > 1 && (ahead = TextPanelWidget.lookAheadChars(content, index)) != null; index -= 2) {
                    removed.add(index - 2);
                }
            }
            marcher = COLOR_CODE_PATTERN.matcher(content);
            while (marcher.find()) {
                for (index = marcher.start(); index > 1 && (ahead = TextPanelWidget.lookAheadChars(content, index)) != null && TextFormatting.RESET != ahead && removed.add(index - 2); index -= 2) {
                }
            }
            StringBuilder builder = new StringBuilder();
            AtomicInteger start = new AtomicInteger();
            removed.stream().sorted().forEach(remove -> {
                builder.append(content, start.get(), (int)remove);
                start.set(remove + 2);
            });
            builder.append(content, start.get(), content.length());
            return builder.toString();
        }

        private void findFrontFormatting() {
            int lastReset = this.content.lastIndexOf("\u00a7r");
            int lastColor = -1;
            this.frontColor = null;
            this.frontStyle.clear();
            for (TextFormatting value : TextFormatting.values()) {
                int index = this.content.lastIndexOf(value.toString());
                if (index <= lastReset) continue;
                if (value.func_96302_c()) {
                    if (index <= lastColor) continue;
                    lastColor = index;
                    this.frontColor = value;
                    continue;
                }
                if (!value.func_96301_b() || index <= lastColor) continue;
                this.frontStyle.add(value);
            }
        }

        public void addFormatting(TextFormatting formatting) {
            if (formatting.func_96302_c()) {
                this.frontColor = formatting;
                this.pageInsertIntoCurrent(formatting.toString());
                for (TextFormatting style : this.frontStyle) {
                    this.pageInsertIntoCurrent(style.toString());
                }
            } else if (formatting.func_96301_b()) {
                if (this.frontStyle.contains(formatting)) {
                    return;
                }
                this.frontStyle.add(formatting);
                this.pageInsertIntoCurrent(formatting.toString());
            }
        }

        public void removeFormatting(TextFormatting formatting) {
            if (formatting.func_96302_c()) {
                this.frontColor = null;
                this.pageInsertIntoCurrent(TextFormatting.RESET.toString());
                this.frontStyle.forEach(style -> this.pageInsertIntoCurrent(style.toString()));
            } else if (formatting.func_96301_b()) {
                this.pageInsertIntoCurrent(TextFormatting.RESET.toString());
                if (this.frontColor != null) {
                    this.pageInsertIntoCurrent(this.frontColor.toString());
                }
                this.frontStyle.remove(formatting);
                this.frontStyle.forEach(style -> this.pageInsertIntoCurrent(style.toString()));
            }
        }

        public TextFormatting getFrontColorFormatting() {
            return this.frontColor;
        }

        public List<TextFormatting> getFrontStyleFormatting() {
            return this.frontStyle;
        }

        public void pageSetCurrent(String string) {
            if (!this.content.equals(string)) {
                this.content = TextPanelWidget.cleanUpFormatting(string);
                this.findFrontFormatting();
                if (this.stringUpdate != null) {
                    this.stringUpdate.accept(this.content);
                }
                this.textHeight = this.fontRenderer.func_78267_b(this.content + TextFormatting.BLACK + "_", this.getSize().width - this.yBarWidth);
            }
        }

        public void pageInsertIntoCurrent(String string) {
            this.content = TextPanelWidget.cleanUpFormatting(this.content + string);
            if (this.stringUpdate != null) {
                this.stringUpdate.accept(this.content);
            }
            this.textHeight = this.fontRenderer.func_78267_b(this.content + TextFormatting.BLACK + "_", this.getSize().width - this.yBarWidth);
        }

        @Override
        public boolean hookDrawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
            String contentString = this.content;
            if (this.focus && this.isActive()) {
                contentString = this.fontRenderer.func_78260_a() ? contentString + "_" : (this.updateCount / 6 % 2 == 0 ? contentString + TextFormatting.BLACK + "_" : contentString + TextFormatting.GRAY + "_");
            }
            int x = this.getPosition().x - this.scrollXOffset;
            int y = this.getPosition().y + 0 - this.scrollYOffset;
            for (String textLine : this.fontRenderer.func_78271_c(contentString, this.getSize().width - this.yBarWidth)) {
                this.fontRenderer.func_175065_a(textLine, (float)x, (float)y, -16777216, false);
                y += this.fontRenderer.field_78288_b;
            }
            return true;
        }
    }
}

