/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.terminal.gui.widgets;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.terminal.gui.IDraggable;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import java.util.function.BiConsumer;

public class CustomPositionSizeWidget
extends Widget
implements IDraggable {
    private Widget controlled;
    private final int borderColor;
    private final int hoverColor;
    private final int border;
    private boolean dragUp;
    private boolean dragDown;
    private boolean dragLeft;
    private boolean dragRight;
    private boolean dragPos;
    private BiConsumer<Position, Size> onUpdated;

    public CustomPositionSizeWidget(Widget controlled, int borderColor, int hoverColor, int border) {
        super(controlled.getSelfPosition(), controlled.getSize());
        this.controlled = controlled;
        this.borderColor = borderColor;
        this.hoverColor = hoverColor;
        this.border = border;
    }

    public CustomPositionSizeWidget(int borderColor, int hoverColor, int border) {
        super(Position.ORIGIN, Size.ZERO);
        this.borderColor = borderColor;
        this.hoverColor = hoverColor;
        this.border = border;
    }

    public CustomPositionSizeWidget setControlled(Widget controlled) {
        this.controlled = controlled;
        if (controlled != null) {
            this.setSelfPosition(controlled.getSelfPosition());
            this.setSize(controlled.getSize());
        }
        return this;
    }

    public Widget getControlled() {
        return this.controlled;
    }

    public CustomPositionSizeWidget setOnUpdated(BiConsumer<Position, Size> onUpdated) {
        this.onUpdated = onUpdated;
        return this;
    }

    @Override
    public void updateScreen() {
        if (this.controlled != null) {
            Position pos = this.controlled.getSelfPosition();
            Size size = this.controlled.getSize();
            if (!this.getSelfPosition().equals(pos)) {
                this.setSelfPosition(pos);
            }
            if (this.getSize().equals(size)) {
                this.setSize(size);
            }
        }
    }

    private boolean hoverUp(int x, int y, int width, int height, int mouseX, int mouseY) {
        return CustomPositionSizeWidget.isMouseOver(x, y, width / 5, this.border, mouseX, mouseY) || CustomPositionSizeWidget.isMouseOver(x + width * 2 / 5, y, width / 5, this.border, mouseX, mouseY) || CustomPositionSizeWidget.isMouseOver(x + width * 4 / 5, y, width / 5, this.border, mouseX, mouseY) || CustomPositionSizeWidget.isMouseOver(x, y, this.border, height / 5, mouseX, mouseY) || CustomPositionSizeWidget.isMouseOver(x + width - this.border, y, this.border, height / 5, mouseX, mouseY);
    }

    private boolean hoverDown(int x, int y, int width, int height, int mouseX, int mouseY) {
        return CustomPositionSizeWidget.isMouseOver(x, y + height - this.border, width / 5, this.border, mouseX, mouseY) || CustomPositionSizeWidget.isMouseOver(x + width * 2 / 5, y + height - this.border, width / 5, this.border, mouseX, mouseY) || CustomPositionSizeWidget.isMouseOver(x + width * 4 / 5, y + height - this.border, width / 5, this.border, mouseX, mouseY) || CustomPositionSizeWidget.isMouseOver(x, y + height * 4 / 5, this.border, height / 5, mouseX, mouseY) || CustomPositionSizeWidget.isMouseOver(x + width - this.border, y + height * 4 / 5, this.border, height / 5, mouseX, mouseY);
    }

    private boolean hoverLeft(int x, int y, int width, int height, int mouseX, int mouseY) {
        return CustomPositionSizeWidget.isMouseOver(x, y, this.border, height / 5, mouseX, mouseY) || CustomPositionSizeWidget.isMouseOver(x, y + height * 2 / 5, this.border, height / 5, mouseX, mouseY) || CustomPositionSizeWidget.isMouseOver(x, y + height * 4 / 5, this.border, height / 5, mouseX, mouseY) || CustomPositionSizeWidget.isMouseOver(x, y, width / 5, this.border, mouseX, mouseY) || CustomPositionSizeWidget.isMouseOver(x, y + height - this.border, width / 5, this.border, mouseX, mouseY);
    }

    private boolean hoverRight(int x, int y, int width, int height, int mouseX, int mouseY) {
        return CustomPositionSizeWidget.isMouseOver(x + width - this.border, y, this.border, height / 5, mouseX, mouseY) || CustomPositionSizeWidget.isMouseOver(x + width - this.border, y + height * 2 / 5, this.border, height / 5, mouseX, mouseY) || CustomPositionSizeWidget.isMouseOver(x + width - this.border, y + height * 4 / 5, this.border, height / 5, mouseX, mouseY) || CustomPositionSizeWidget.isMouseOver(x + width * 4 / 5, y, width / 5, this.border, mouseX, mouseY) || CustomPositionSizeWidget.isMouseOver(x + width * 4 / 5, y + height - this.border, width / 5, this.border, mouseX, mouseY);
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        if (this.controlled == null) {
            return;
        }
        int x = this.controlled.getPosition().x;
        int y = this.controlled.getPosition().y;
        int width = this.controlled.getSize().width;
        int height = this.controlled.getSize().height;
        boolean hoverUp = false;
        boolean hoverDown = false;
        boolean hoverLeft = false;
        boolean hoverRight = false;
        if (this.dragUp || this.hoverUp(x, y, width, height, mouseX, mouseY)) {
            hoverUp = true;
        }
        if (this.dragDown || this.hoverDown(x, y, width, height, mouseX, mouseY)) {
            hoverDown = true;
        }
        if (this.dragLeft || this.hoverLeft(x, y, width, height, mouseX, mouseY)) {
            hoverLeft = true;
        }
        if (this.dragRight || this.hoverRight(x, y, width, height, mouseX, mouseY)) {
            hoverRight = true;
        }
        CustomPositionSizeWidget.drawSolidRect(x, y, width / 5, this.border, hoverUp && !hoverRight ? this.hoverColor : this.borderColor);
        CustomPositionSizeWidget.drawSolidRect(x + width * 2 / 5, y, width / 5, this.border, hoverUp && !hoverLeft && !hoverRight ? this.hoverColor : this.borderColor);
        CustomPositionSizeWidget.drawSolidRect(x + width * 4 / 5, y, width / 5, this.border, hoverUp && !hoverLeft ? this.hoverColor : this.borderColor);
        CustomPositionSizeWidget.drawSolidRect(x, y + height - this.border, width / 5, this.border, hoverDown && !hoverRight ? this.hoverColor : this.borderColor);
        CustomPositionSizeWidget.drawSolidRect(x + width * 2 / 5, y + height - this.border, width / 5, this.border, hoverDown && !hoverLeft && !hoverRight ? this.hoverColor : this.borderColor);
        CustomPositionSizeWidget.drawSolidRect(x + width * 4 / 5, y + height - this.border, width / 5, this.border, hoverDown && !hoverLeft ? this.hoverColor : this.borderColor);
        CustomPositionSizeWidget.drawSolidRect(x, y, this.border, height / 5, hoverLeft && !hoverDown ? this.hoverColor : this.borderColor);
        CustomPositionSizeWidget.drawSolidRect(x, y + height * 2 / 5, this.border, height / 5, hoverLeft && !hoverDown && !hoverUp ? this.hoverColor : this.borderColor);
        CustomPositionSizeWidget.drawSolidRect(x, y + height * 4 / 5, this.border, height / 5, hoverLeft && !hoverUp ? this.hoverColor : this.borderColor);
        CustomPositionSizeWidget.drawSolidRect(x + width - this.border, y, this.border, height / 5, hoverRight && !hoverDown ? this.hoverColor : this.borderColor);
        CustomPositionSizeWidget.drawSolidRect(x + width - this.border, y + height * 2 / 5, this.border, height / 5, hoverRight && !hoverDown && !hoverUp ? this.hoverColor : this.borderColor);
        CustomPositionSizeWidget.drawSolidRect(x + width - this.border, y + height * 4 / 5, this.border, height / 5, hoverRight && !hoverUp ? this.hoverColor : this.borderColor);
    }

    @Override
    public boolean allowDrag(int mouseX, int mouseY, int button) {
        if (this.controlled == null || !this.isActive()) {
            return false;
        }
        int x = this.controlled.getPosition().x;
        int y = this.controlled.getPosition().y;
        int width = this.controlled.getSize().width;
        int height = this.controlled.getSize().height;
        if (CustomPositionSizeWidget.isMouseOver(x, y, width, height, mouseX, mouseY)) {
            this.dragUp = this.hoverUp(x, y, width, height, mouseX, mouseY);
            this.dragDown = this.hoverDown(x, y, width, height, mouseX, mouseY);
            this.dragLeft = this.hoverLeft(x, y, width, height, mouseX, mouseY);
            this.dragRight = this.hoverRight(x, y, width, height, mouseX, mouseY);
            this.dragPos = !this.dragUp && !this.dragDown && !this.dragLeft && !this.dragRight;
            return true;
        }
        return false;
    }

    @Override
    public boolean dragging(int mouseX, int mouseY, int deltaX, int deltaY) {
        if (this.controlled == null || !this.isActive()) {
            return false;
        }
        int width = this.controlled.getSize().width;
        int height = this.controlled.getSize().height;
        int addX = 0;
        int addY = 0;
        if (!this.dragPos) {
            if (this.dragUp) {
                addY = deltaY;
                height = Math.max(1, height - deltaY);
            }
            if (this.dragDown) {
                height = Math.max(1, height + deltaY);
            }
            if (this.dragLeft) {
                addX = deltaX;
                width = Math.max(1, width - deltaX);
            }
            if (this.dragRight) {
                width = Math.max(1, width + deltaX);
            }
            this.controlled.addSelfPosition(addX, addY);
            this.controlled.setSize(new Size(width, height));
        } else {
            this.controlled.addSelfPosition(deltaX, deltaY);
        }
        if (this.onUpdated != null) {
            this.onUpdated.accept(this.controlled.getSelfPosition(), this.controlled.getSize());
        }
        this.setSelfPosition(this.controlled.getSelfPosition());
        this.setSize(this.controlled.getSize());
        return false;
    }

    @Override
    public void endDrag(int mouseX, int mouseY) {
        this.dragDown = false;
        this.dragUp = false;
        this.dragLeft = false;
        this.dragRight = false;
        this.dragPos = false;
    }
}

