/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.terminal.gui.widgets;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.ColorRectTexture;
import gregtech.api.gui.widgets.TextFieldWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.terminal.gui.widgets.CircleButtonWidget;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.MathHelper;

public class ColorWidget
extends WidgetGroup {
    private int red = 255;
    private int green = 255;
    private int blue = 255;
    private int alpha = 255;
    private Consumer<Integer> onColorChanged;
    private final int barWidth;
    private final int barHeight;
    private final CircleButtonWidget redButton;
    private final CircleButtonWidget greenButton;
    private final CircleButtonWidget blueButton;
    private final CircleButtonWidget alphaButton;
    private int lastMouseX;
    private CircleButtonWidget dragged;
    private Supplier<Integer> colorSupplier;
    private boolean isClient;

    public ColorWidget(int x, int y, int barWidth, int barHeight) {
        super(new Position(x, y), new Size(barWidth + 35, 3 * (barHeight + 5) + 10));
        this.barWidth = barWidth;
        this.barHeight = barHeight;
        ColorRectTexture textFieldBackground = new ColorRectTexture(-1627389952);
        TextFieldWidget redField = new TextFieldWidget(barWidth + 5, 0, 30, barHeight, textFieldBackground, null, null).setTextResponder(t -> {
            this.setRed(t.isEmpty() ? 0 : Integer.parseInt(t));
            if (this.onColorChanged != null) {
                this.onColorChanged.accept(this.getColor());
            }
            this.writeClientAction(2, buffer -> buffer.writeInt(this.getColor()));
        }, true).setTextSupplier(() -> Integer.toString(this.red), true).setValidator(ColorWidget::checkValid);
        TextFieldWidget greenField = new TextFieldWidget(barWidth + 5, barHeight + 5, 30, barHeight, textFieldBackground, null, null).setTextResponder(t -> {
            this.setGreen(t.isEmpty() ? 0 : Integer.parseInt(t));
            if (this.onColorChanged != null) {
                this.onColorChanged.accept(this.getColor());
            }
            this.writeClientAction(2, buffer -> buffer.writeInt(this.getColor()));
        }, true).setTextSupplier(() -> Integer.toString(this.green), true).setValidator(ColorWidget::checkValid);
        TextFieldWidget blueField = new TextFieldWidget(barWidth + 5, (barHeight + 5) * 2, 30, barHeight, textFieldBackground, null, null).setTextResponder(t -> {
            this.setBlue(t.isEmpty() ? 0 : Integer.parseInt(t));
            if (this.onColorChanged != null) {
                this.onColorChanged.accept(this.getColor());
            }
            this.writeClientAction(2, buffer -> buffer.writeInt(this.getColor()));
        }, true).setTextSupplier(() -> Integer.toString(this.blue), true).setValidator(ColorWidget::checkValid);
        TextFieldWidget alphaField = new TextFieldWidget(barWidth + 5, (barHeight + 5) * 3, 30, barHeight, textFieldBackground, null, null).setTextResponder(t -> {
            this.setAlpha(t.isEmpty() ? 0 : Integer.parseInt(t));
            if (this.onColorChanged != null) {
                this.onColorChanged.accept(this.getColor());
            }
            this.writeClientAction(2, buffer -> buffer.writeInt(this.getColor()));
        }, true).setTextSupplier(() -> Integer.toString(this.alpha), true).setValidator(ColorWidget::checkValid);
        this.addWidget(redField);
        this.addWidget(greenField);
        this.addWidget(blueField);
        this.addWidget(alphaField);
        this.redButton = new CircleButtonWidget(barWidth, barHeight / 2, 4, 1, 0).setFill(-65536).setStrokeAnima(-1);
        this.greenButton = new CircleButtonWidget(barWidth, barHeight / 2 + barHeight + 5, 4, 1, 0).setFill(-16711936).setStrokeAnima(-1);
        this.blueButton = new CircleButtonWidget(barWidth, barHeight / 2 + 2 * (barHeight + 5), 4, 1, 0).setFill(-16776961).setStrokeAnima(-1);
        this.alphaButton = new CircleButtonWidget(barWidth, barHeight / 2 + 3 * (barHeight + 5), 4, 1, 0).setFill(-1).setStrokeAnima(-1);
        this.addWidget(this.redButton);
        this.addWidget(this.greenButton);
        this.addWidget(this.blueButton);
        this.addWidget(this.alphaButton);
    }

    public ColorWidget setOnColorChanged(Consumer<Integer> onColorChanged) {
        this.onColorChanged = onColorChanged;
        return this;
    }

    public ColorWidget setColorSupplier(Supplier<Integer> colorSupplier, boolean isClient) {
        this.colorSupplier = colorSupplier;
        this.isClient = isClient;
        return this;
    }

    public ColorWidget setStartColor(int color) {
        this.setRed(color >> 16 & 0xFF);
        this.setGreen(color >> 8 & 0xFF);
        this.setBlue(color & 0xFF);
        this.setAlpha(color >> 24 & 0xFF);
        return this;
    }

    public int getColor() {
        return this.alpha << 24 | this.red << 16 | this.green << 8 | this.blue;
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (!this.isClient && this.colorSupplier != null) {
            int c = this.colorSupplier.get();
            int r = (c & 0xFF0000) >>> 16;
            int g = (c & 0xFF00) >>> 8;
            int b = c & 0xFF;
            int a = (c & 0xFF000000) >>> 24;
            if (r != this.red || g != this.green || b != this.blue || a != this.alpha) {
                this.setRed(r);
                this.setGreen(g);
                this.setBlue(b);
                this.setAlpha(a);
                this.writeUpdateInfo(2, buffer -> buffer.writeInt(c));
            }
        }
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        if (this.isClient && this.colorSupplier != null) {
            int c = this.colorSupplier.get();
            int r = (c & 0xFF0000) >>> 16;
            int g = (c & 0xFF00) >>> 8;
            int b = c & 0xFF;
            int a = (c & 0xFF000000) >>> 24;
            if (r != this.red || g != this.green || b != this.blue || a != this.alpha) {
                this.setRed(r);
                this.setGreen(g);
                this.setBlue(b);
                this.setAlpha(a);
                this.writeClientAction(2, buffer -> buffer.writeInt(c));
            }
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        this.handleColor(id, buffer);
    }

    private void handleColor(int id, PacketBuffer buffer) {
        if (id == 2) {
            int c = buffer.readInt();
            int r = (c & 0xFF0000) >>> 16;
            int g = (c & 0xFF00) >>> 8;
            int b = c & 0xFF;
            int a = (c & 0xFF000000) >>> 24;
            if (r != this.red || g != this.green || b != this.blue || a != this.alpha) {
                this.setRed(r);
                this.setGreen(g);
                this.setBlue(b);
                this.setAlpha(a);
                if (this.onColorChanged != null) {
                    this.onColorChanged.accept(this.getColor());
                }
            }
        }
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        this.handleColor(id, buffer);
    }

    private void setRed(int red) {
        if (this.red != red) {
            this.red = red;
            this.redButton.setSelfPosition(new Position(red * this.barWidth / 255 - 4, this.redButton.getSelfPosition().y));
        }
    }

    private void setGreen(int green) {
        if (this.green != green) {
            this.green = green;
            this.greenButton.setSelfPosition(new Position(green * this.barWidth / 255 - 4, this.greenButton.getSelfPosition().y));
        }
    }

    private void setBlue(int blue) {
        if (this.blue != blue) {
            this.blue = blue;
            this.blueButton.setSelfPosition(new Position(blue * this.barWidth / 255 - 4, this.blueButton.getSelfPosition().y));
        }
    }

    private void setAlpha(int alpha) {
        if (this.alpha != alpha) {
            this.alpha = alpha;
            this.alphaButton.setSelfPosition(new Position(alpha * this.barWidth / 255 - 4, this.alphaButton.getSelfPosition().y));
        }
    }

    private static boolean checkValid(String input) {
        if (input.length() > 3) {
            return false;
        }
        if (input.isEmpty()) {
            return true;
        }
        try {
            int value = Integer.parseInt(input);
            if (value >= 0 && value <= 255) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        ColorWidget.drawGradientRect(x, y + 2, this.barWidth, 5.0f, 0xFF000000 | this.green << 8 | this.blue, 0xFFFF0000 | this.green << 8 | this.blue, true);
        ColorWidget.drawGradientRect(x, y + this.barHeight + 5 + 2, this.barWidth, 5.0f, 0xFF000000 | this.red << 16 | 0 | this.blue, 0xFF000000 | this.red << 16 | 0xFF00 | this.blue, true);
        ColorWidget.drawGradientRect(x, y + 2 * (this.barHeight + 5) + 2, this.barWidth, 5.0f, 0xFF000000 | this.red << 16 | this.green << 8 | 0, 0xFF000000 | this.red << 16 | this.green << 8 | 0xFF, true);
        ColorWidget.drawGradientRect(x, y + 3 * (this.barHeight + 5) + 2, this.barWidth, 5.0f, 0 | this.red << 16 | this.green << 8 | this.blue, 0xFF000000 | this.red << 16 | this.green << 8 | this.blue, true);
        super.drawInBackground(mouseX, mouseY, partialTicks, context);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        this.lastMouseX = mouseX;
        this.dragged = null;
        if (this.redButton.isMouseOverElement(mouseX, mouseY)) {
            this.dragged = this.redButton;
            return true;
        }
        if (this.greenButton.isMouseOverElement(mouseX, mouseY)) {
            this.dragged = this.greenButton;
            return true;
        }
        if (this.blueButton.isMouseOverElement(mouseX, mouseY)) {
            this.dragged = this.blueButton;
            return true;
        }
        if (this.alphaButton.isMouseOverElement(mouseX, mouseY)) {
            this.dragged = this.alphaButton;
            return true;
        }
        boolean flag = false;
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = (Widget)this.widgets.get(i);
            if (!widget.isVisible() || !widget.mouseClicked(mouseX, mouseY, button)) continue;
            flag = true;
        }
        return flag;
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button, long timeDragged) {
        int xDelta = mouseX - this.lastMouseX;
        this.lastMouseX = mouseX;
        if (this.dragged != null) {
            int newX = MathHelper.func_76125_a((int)(this.dragged.getSelfPosition().x + 4 + xDelta), (int)0, (int)this.barWidth);
            if (this.dragged == this.redButton) {
                this.setRed(newX * 255 / this.barWidth);
            } else if (this.dragged == this.greenButton) {
                this.setGreen(newX * 255 / this.barWidth);
            } else if (this.dragged == this.blueButton) {
                this.setBlue(newX * 255 / this.barWidth);
            } else if (this.dragged == this.alphaButton) {
                this.setAlpha(newX * 255 / this.barWidth);
            }
            if (this.onColorChanged != null) {
                this.onColorChanged.accept(this.getColor());
            }
            this.writeClientAction(2, buffer -> buffer.writeInt(this.getColor()));
            this.dragged.setSelfPosition(new Position(newX - 4, this.dragged.getSelfPosition().y));
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, timeDragged);
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        this.dragged = null;
        return super.mouseReleased(mouseX, mouseY, button);
    }
}

