/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.map;

import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.map.AbstractMapIngredient;
import java.util.Objects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class MapFluidIngredient
extends AbstractMapIngredient {
    public final Fluid fluid;
    public final NBTTagCompound tag;

    public MapFluidIngredient(GTRecipeInput fluidInput) {
        FluidStack fluidStack = fluidInput.getInputFluidStack();
        this.fluid = fluidStack.getFluid();
        this.tag = fluidStack.tag;
    }

    public MapFluidIngredient(FluidStack fluidStack) {
        this.fluid = fluidStack.getFluid();
        this.tag = fluidStack.tag;
    }

    @Override
    protected int hash() {
        int hash = 31 + this.fluid.getName().hashCode();
        if (this.tag != null) {
            return 31 * hash + this.tag.hashCode();
        }
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            MapFluidIngredient other = (MapFluidIngredient)o;
            if (this.fluid.getName().equals(other.fluid.getName())) {
                return Objects.equals(this.tag, other.tag);
            }
        }
        return false;
    }

    public String toString() {
        return "MapFluidIngredient{{fluid=" + this.fluid.getName() + "} {tag=" + this.tag + "}";
    }
}

