/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.ingredients.nbtmatch;

import gregtech.api.recipes.ingredients.nbtmatch.NBTTagType;
import gregtech.api.util.GTLog;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class NBTCondition {
    public static final NBTCondition ANY = new NBTCondition();
    @Nullable
    public final NBTTagType tagType;
    public final String nbtKey;
    public final Object value;

    public static NBTCondition create(NBTTagType tagType, String nbtKey, Object value) {
        if (tagType == NBTTagType.LIST) {
            throw new IllegalArgumentException("Use ListNBTCondition::create instead of NBTCondition::create");
        }
        return new NBTCondition(tagType, nbtKey, value);
    }

    private NBTCondition() {
        this.tagType = null;
        this.nbtKey = null;
        this.value = null;
    }

    protected NBTCondition(NBTTagType tagType, String nbtKey, Object value) {
        this.tagType = tagType;
        this.nbtKey = nbtKey;
        this.value = value;
        if (tagType == null || nbtKey == null || value == null) {
            GTLog.logger.error("NBTCondition must not have null parameters.");
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
        }
    }

    public String toString() {
        return this.nbtKey + ": " + this.value;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tagType, this.nbtKey, this.value});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NBTCondition) {
            NBTCondition o = (NBTCondition)obj;
            return this.tagType == o.tagType && this.nbtKey.equals(o.nbtKey) && this.value.equals(o.value);
        }
        return false;
    }
}

