/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.builders;

import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.builders.ResearchRecipeBuilder;
import gregtech.api.recipes.recipeproperties.ResearchProperty;
import gregtech.api.recipes.recipeproperties.ResearchPropertyData;
import gregtech.api.util.AssemblyLineManager;
import gregtech.api.util.EnumValidationResult;
import gregtech.api.util.GTLog;
import gregtech.common.ConfigHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.UnaryOperator;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssemblyLineRecipeBuilder
extends RecipeBuilder<AssemblyLineRecipeBuilder> {
    private final Collection<ResearchRecipeEntry> recipeEntries = new ArrayList<ResearchRecipeEntry>();
    private boolean generatingRecipes = true;

    public AssemblyLineRecipeBuilder() {
    }

    public AssemblyLineRecipeBuilder(Recipe recipe, RecipeMap<AssemblyLineRecipeBuilder> recipeMap) {
        super(recipe, recipeMap);
    }

    public AssemblyLineRecipeBuilder(@NotNull AssemblyLineRecipeBuilder builder) {
        super(builder);
        this.recipeEntries.addAll(builder.getRecipeEntries());
        this.generatingRecipes = builder.generatingRecipes;
    }

    @Override
    public AssemblyLineRecipeBuilder copy() {
        return new AssemblyLineRecipeBuilder(this);
    }

    @Override
    public boolean applyProperty(@NotNull String key, @Nullable Object value) {
        if (key.equals("research") && value instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)value;
            this.scannerResearch(itemStack);
            return true;
        }
        return super.applyProperty(key, value);
    }

    private boolean applyResearchProperty(ResearchPropertyData.ResearchEntry researchEntry) {
        if (!ConfigHolder.machines.enableResearch) {
            return false;
        }
        if (researchEntry == null) {
            GTLog.logger.error("Assembly Line Research Entry cannot be empty.", (Throwable)new IllegalArgumentException());
            this.recipeStatus = EnumValidationResult.INVALID;
            return false;
        }
        if (!this.generatingRecipes) {
            GTLog.logger.error("Cannot generate recipes when using researchWithoutRecipe()", (Throwable)new IllegalArgumentException());
            this.recipeStatus = EnumValidationResult.INVALID;
            return false;
        }
        if (this.recipePropertyStorage != null && this.recipePropertyStorage.hasRecipeProperty(ResearchProperty.getInstance())) {
            ResearchPropertyData property = this.recipePropertyStorage.getRecipePropertyValue(ResearchProperty.getInstance(), null);
            if (property == null) {
                throw new IllegalStateException("Property storage has a null property");
            }
            property.add(researchEntry);
            return true;
        }
        ResearchPropertyData property = new ResearchPropertyData();
        if (this.applyProperty(ResearchProperty.getInstance(), (Object)property)) {
            property.add(researchEntry);
            return true;
        }
        return false;
    }

    public AssemblyLineRecipeBuilder researchWithoutRecipe(@NotNull String researchId) {
        return this.researchWithoutRecipe(researchId, AssemblyLineManager.getDefaultScannerItem());
    }

    public AssemblyLineRecipeBuilder researchWithoutRecipe(@NotNull String researchId, @NotNull ItemStack dataStack) {
        this.applyResearchProperty(new ResearchPropertyData.ResearchEntry(researchId, dataStack));
        this.generatingRecipes = false;
        return this;
    }

    public AssemblyLineRecipeBuilder scannerResearch(UnaryOperator<ResearchRecipeBuilder.ScannerRecipeBuilder> research) {
        ResearchRecipeEntry entry = ((ResearchRecipeBuilder.ScannerRecipeBuilder)research.apply(new ResearchRecipeBuilder.ScannerRecipeBuilder())).build();
        if (this.applyResearchProperty(new ResearchPropertyData.ResearchEntry(entry.researchId, entry.dataStack))) {
            this.recipeEntries.add(entry);
        }
        return this;
    }

    public AssemblyLineRecipeBuilder scannerResearch(@NotNull ItemStack researchStack) {
        return this.scannerResearch(b -> (ResearchRecipeBuilder.ScannerRecipeBuilder)new ResearchRecipeBuilder.ScannerRecipeBuilder().researchStack(researchStack));
    }

    public AssemblyLineRecipeBuilder stationResearch(UnaryOperator<ResearchRecipeBuilder.StationRecipeBuilder> research) {
        ResearchRecipeEntry entry = ((ResearchRecipeBuilder.StationRecipeBuilder)research.apply(new ResearchRecipeBuilder.StationRecipeBuilder())).build();
        if (this.applyResearchProperty(new ResearchPropertyData.ResearchEntry(entry.researchId, entry.dataStack))) {
            this.recipeEntries.add(entry);
        }
        return this;
    }

    @NotNull
    public Collection<ResearchRecipeEntry> getRecipeEntries() {
        return this.recipeEntries;
    }

    public static class ResearchRecipeEntry {
        private final String researchId;
        private final ItemStack researchStack;
        private final ItemStack dataStack;
        private final boolean ignoreNBT;
        private final int duration;
        private final int EUt;
        private final int CWUt;

        public ResearchRecipeEntry(@NotNull String researchId, @NotNull ItemStack researchStack, @NotNull ItemStack dataStack, int duration, int EUt, int CWUt) {
            this.researchId = researchId;
            this.researchStack = researchStack;
            this.dataStack = dataStack;
            this.duration = duration;
            this.EUt = EUt;
            this.CWUt = CWUt;
            this.ignoreNBT = true;
        }

        public ResearchRecipeEntry(@NotNull String researchId, @NotNull ItemStack researchStack, @NotNull ItemStack dataStack, boolean ignoreNBT, int duration, int EUt, int CWUt) {
            this.researchId = researchId;
            this.researchStack = researchStack;
            this.dataStack = dataStack;
            this.ignoreNBT = ignoreNBT;
            this.duration = duration;
            this.EUt = EUt;
            this.CWUt = CWUt;
        }

        @NotNull
        public String getResearchId() {
            return this.researchId;
        }

        @NotNull
        public ItemStack getResearchStack() {
            return this.researchStack;
        }

        @NotNull
        public ItemStack getDataStack() {
            return this.dataStack;
        }

        public boolean getIgnoreNBT() {
            return this.ignoreNBT;
        }

        public int getDuration() {
            return this.duration;
        }

        public int getEUt() {
            return this.EUt;
        }

        public int getCWUt() {
            return this.CWUt;
        }
    }
}

