/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pipenet.tile;

import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.cover.Cover;
import gregtech.api.cover.CoverHolder;
import gregtech.api.cover.CoverSaveHandler;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.block.IPipeType;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.util.GTUtility;
import gregtech.common.ConfigHolder;
import java.util.EnumMap;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PipeCoverableImplementation
implements CoverHolder {
    private IPipeTile<?, ?> holder;
    private final EnumMap<EnumFacing, Cover> covers = new EnumMap(EnumFacing.class);
    private final int[] sidedRedstoneInput = new int[6];

    public PipeCoverableImplementation(IPipeTile<?, ?> holder) {
        this.holder = holder;
    }

    public void transferDataTo(PipeCoverableImplementation destImpl) {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            Cover cover = this.covers.get(side);
            if (cover == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            cover.writeToNBT(tagCompound);
            Cover newCover = cover.getDefinition().createCover(destImpl, side);
            newCover.readFromNBT(tagCompound);
            destImpl.covers.put(side, newCover);
        }
    }

    @Override
    public final void addCover(@NotNull EnumFacing side, @NotNull Cover cover) {
        if (cover instanceof ITickable && !this.holder.supportsTicking()) {
            IPipeTile<?, ?> newHolderTile = this.holder.setSupportsTicking();
            newHolderTile.getCoverableImplementation().addCover(side, cover);
            this.holder = newHolderTile;
            return;
        }
        this.covers.put(side, cover);
        if (!this.getWorld().field_72995_K) {
            CoverSaveHandler.writeCoverPlacement(this, GregtechDataCodes.COVER_ATTACHED_PIPE, side, cover);
            if (cover.shouldAutoConnectToPipes()) {
                this.holder.setConnection(side, true, false);
            }
        }
        this.holder.notifyBlockUpdate();
        this.holder.markAsDirty();
    }

    @Override
    public final void removeCover(@NotNull EnumFacing side) {
        Cover cover = this.getCoverAtSide(side);
        if (cover == null) {
            return;
        }
        this.dropCover(side);
        this.covers.remove(side);
        this.writeCustomData(GregtechDataCodes.COVER_REMOVED_PIPE, buffer -> buffer.writeByte(side.func_176745_a()));
        if (cover.shouldAutoConnectToPipes()) {
            this.holder.setConnection(side, false, false);
        }
        this.holder.notifyBlockUpdate();
        this.holder.markAsDirty();
    }

    public ItemStack getStackForm() {
        BlockPipe<?, ?, ?> pipeBlock = this.holder.getPipeBlock();
        return pipeBlock.getDropItem(this.holder);
    }

    public void onLoad() {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            this.sidedRedstoneInput[side.func_176745_a()] = GTUtility.getRedstonePower(this.getWorld(), this.getPos(), side);
        }
    }

    @Override
    public final int getInputRedstoneSignal(@NotNull EnumFacing side, boolean ignoreCover) {
        if (!ignoreCover && this.getCoverAtSide(side) != null) {
            return 0;
        }
        return this.sidedRedstoneInput[side.func_176745_a()];
    }

    public void updateInputRedstoneSignals() {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            int currentValue;
            int redstoneValue = GTUtility.getRedstonePower(this.getWorld(), this.getPos(), side);
            if (redstoneValue == (currentValue = this.sidedRedstoneInput[side.func_176745_a()])) continue;
            this.sidedRedstoneInput[side.func_176745_a()] = redstoneValue;
            Cover cover = this.getCoverAtSide(side);
            if (cover == null) continue;
            cover.onRedstoneInputSignalChange(redstoneValue);
        }
    }

    @Override
    public void notifyBlockUpdate() {
        this.holder.notifyBlockUpdate();
    }

    @Override
    public void scheduleRenderUpdate() {
        BlockPos pos = this.getPos();
        this.getWorld().func_147458_c(pos.func_177958_n() - 1, pos.func_177956_o() - 1, pos.func_177952_p() - 1, pos.func_177958_n() + 1, pos.func_177956_o() + 1, pos.func_177952_p() + 1);
    }

    @Override
    public double getCoverPlateThickness() {
        float thickness = ((IPipeType)this.holder.getPipeType()).getThickness();
        if (thickness >= 1.0f) {
            return 0.0;
        }
        return Math.min(0.0625, (1.0 - (double)thickness) / 2.0);
    }

    @Override
    public boolean shouldRenderCoverBackSides() {
        return false;
    }

    @Override
    public int getPaintingColorForRendering() {
        return ConfigHolder.client.defaultPaintingColor;
    }

    @Override
    public boolean canPlaceCoverOnSide(@NotNull EnumFacing side) {
        return this.holder.canPlaceCoverOnSide(side);
    }

    @Override
    public final boolean acceptsCovers() {
        return this.covers.size() < EnumFacing.field_82609_l.length;
    }

    public boolean canConnectRedstone(@Nullable EnumFacing side) {
        if (side == null) {
            return this.canConnectRedstone(EnumFacing.UP) || this.canConnectRedstone(EnumFacing.DOWN);
        }
        Cover cover = this.getCoverAtSide(side);
        return cover != null && cover.canConnectRedstone();
    }

    public int getOutputRedstoneSignal(@Nullable EnumFacing side) {
        if (side == null) {
            return this.getHighestOutputRedstoneSignal();
        }
        Cover cover = this.getCoverAtSide(side);
        return cover == null ? 0 : cover.getRedstoneSignalOutput();
    }

    public int getHighestOutputRedstoneSignal() {
        int highestSignal = 0;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            Cover cover = this.getCoverAtSide(side);
            if (cover == null) continue;
            highestSignal = Math.max(highestSignal, cover.getRedstoneSignalOutput());
        }
        return highestSignal;
    }

    public void update() {
        if (!this.getWorld().field_72995_K) {
            this.updateCovers();
        }
    }

    @Override
    public void writeCoverData(@NotNull Cover cover, int discriminator, @NotNull @NotNull Consumer<@NotNull PacketBuffer> buf) {
        this.writeCustomData(GregtechDataCodes.UPDATE_COVER_DATA_PIPE, buffer -> {
            buffer.writeByte(cover.getAttachedSide().func_176745_a());
            buffer.func_150787_b(discriminator);
            buf.accept((PacketBuffer)buffer);
        });
    }

    public void writeInitialSyncData(PacketBuffer buf) {
        CoverSaveHandler.writeInitialSyncData(buf, this);
    }

    public void readInitialSyncData(PacketBuffer buf) {
        CoverSaveHandler.receiveInitialSyncData(buf, this);
    }

    @Override
    public void writeCustomData(int dataId, @NotNull Consumer<PacketBuffer> writer) {
        this.holder.writeCoverCustomData(dataId, writer);
    }

    public void readCustomData(int dataId, PacketBuffer buf) {
        if (dataId == GregtechDataCodes.COVER_ATTACHED_PIPE) {
            CoverSaveHandler.readCoverPlacement(buf, this);
        } else if (dataId == GregtechDataCodes.COVER_REMOVED_PIPE) {
            EnumFacing placementSide = EnumFacing.field_82609_l[buf.readByte()];
            this.covers.remove(placementSide);
            this.holder.scheduleChunkForRenderUpdate();
        } else if (dataId == GregtechDataCodes.UPDATE_COVER_DATA_PIPE) {
            EnumFacing coverSide = EnumFacing.field_82609_l[buf.readByte()];
            Cover cover = this.getCoverAtSide(coverSide);
            int internalId = buf.func_150792_a();
            if (cover != null) {
                cover.readCustomData(internalId, buf);
            }
        }
    }

    public void writeToNBT(NBTTagCompound data) {
        CoverSaveHandler.writeCoverNBT(data, this);
    }

    public void readFromNBT(NBTTagCompound data) {
        CoverSaveHandler.readCoverNBT(data, this, this.covers::put);
    }

    @Override
    public World getWorld() {
        return this.holder.getPipeWorld();
    }

    @Override
    public BlockPos getPos() {
        return this.holder.getPipePos();
    }

    public TileEntity getTileEntityHere() {
        TileEntity te;
        IPipeTile<?, ?> iPipeTile = this.holder;
        return iPipeTile instanceof TileEntity ? (te = (TileEntity)iPipeTile) : this.getWorld().func_175625_s(this.getPos());
    }

    @Override
    @Nullable
    public TileEntity getNeighbor(@NotNull EnumFacing facing) {
        return this.holder.getNeighbor(facing);
    }

    @Override
    public long getOffsetTimer() {
        return this.holder.getTickTimer();
    }

    @Override
    @Nullable
    public Cover getCoverAtSide(@NotNull EnumFacing side) {
        return this.covers.get(side);
    }

    @Override
    public boolean hasAnyCover() {
        return !this.covers.isEmpty();
    }

    @Override
    public void markDirty() {
        this.holder.markAsDirty();
    }

    @Override
    public boolean isValid() {
        return this.holder.isValidTile();
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        return this.holder.getCapabilityInternal(capability, side);
    }
}

