/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pipenet.longdist;

import gregtech.api.pipenet.WorldPipeNet;
import gregtech.api.pipenet.longdist.ILDEndpoint;
import gregtech.api.pipenet.longdist.LongDistancePipeType;
import gregtech.api.pipenet.longdist.NetworkBuilder;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LongDistanceNetwork {
    private final ObjectOpenHashSet<BlockPos> longDistancePipeBlocks = new ObjectOpenHashSet();
    private final LongDistancePipeType pipeType;
    private final WorldData world;
    private final List<ILDEndpoint> endpoints = new ArrayList<ILDEndpoint>();
    private final List<BlockPos> endpointPoss = new ArrayList<BlockPos>();
    private int activeInputIndex = -1;
    private int activeOutputIndex = -1;

    protected LongDistanceNetwork(LongDistancePipeType pipeType, WorldData world) {
        this.pipeType = pipeType;
        this.world = world;
    }

    @Nullable
    public static LongDistanceNetwork get(World world, BlockPos pos) {
        return WorldData.get(world).getNetwork(pos);
    }

    protected void recalculateNetwork(Collection<BlockPos> starts) {
        this.invalidateNetwork(true);
        new NetworkBuilder(this.world, this, starts).start();
    }

    protected void setData(Collection<BlockPos> pipes, List<ILDEndpoint> endpoints) {
        this.invalidateEndpoints();
        this.longDistancePipeBlocks.clear();
        this.longDistancePipeBlocks.addAll(pipes);
        this.endpoints.clear();
        this.endpoints.addAll(endpoints);
        if (this.longDistancePipeBlocks.isEmpty()) {
            this.invalidateNetwork(false);
            return;
        }
        for (BlockPos pos : this.longDistancePipeBlocks) {
            this.world.putNetwork(pos, this);
        }
    }

    public void onRemovePipe(BlockPos pos) {
        this.longDistancePipeBlocks.remove((Object)pos);
        this.world.removeNetwork(pos);
        if (this.longDistancePipeBlocks.isEmpty()) {
            this.invalidateNetwork(false);
            return;
        }
        ArrayList<BlockPos> neighbours = new ArrayList<BlockPos>();
        BlockPos.MutableBlockPos offsetPos = new BlockPos.MutableBlockPos();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            offsetPos.func_189533_g((Vec3i)pos).func_189536_c(facing);
            LongDistanceNetwork network = this.world.getNetwork((BlockPos)offsetPos);
            if (network != this) continue;
            neighbours.add(offsetPos.func_185334_h());
        }
        if (neighbours.size() > 1) {
            this.recalculateNetwork(neighbours);
        }
    }

    protected void addEndpoint(ILDEndpoint endpoint) {
        if (!this.endpoints.contains(endpoint)) {
            this.endpoints.add(endpoint);
        }
    }

    protected void addEndpoint(Collection<ILDEndpoint> endpoints) {
        for (ILDEndpoint endpoint : endpoints) {
            if (this.endpoints.contains(endpoint)) continue;
            this.endpoints.add(endpoint);
        }
    }

    public void onRemoveEndpoint(ILDEndpoint endpoint) {
        endpoint.invalidateLink();
        if (this.endpoints.remove(endpoint)) {
            this.invalidateEndpoints();
        }
        this.onRemovePipe(endpoint.pos());
    }

    public void onPlacePipe(BlockPos pos) {
        this.longDistancePipeBlocks.add((Object)pos);
        this.world.putNetwork(pos, this);
    }

    public void onPlaceEndpoint(ILDEndpoint endpoint) {
        this.addEndpoint(endpoint);
        this.longDistancePipeBlocks.add((Object)endpoint.pos());
        this.world.putNetwork(endpoint.pos(), this);
    }

    protected void mergePipeNet(LongDistanceNetwork network) {
        if (this.getPipeType() != network.getPipeType()) {
            throw new IllegalStateException("Can't merge unequal pipe types, " + this.getPipeType().getName() + " and " + network.getPipeType().getName() + " !");
        }
        for (BlockPos pos : network.longDistancePipeBlocks) {
            this.world.putNetwork(pos, this);
            this.longDistancePipeBlocks.add((Object)pos);
        }
        this.addEndpoint(network.endpoints);
        for (ILDEndpoint endpoint1 : this.endpoints) {
            endpoint1.invalidateLink();
        }
        network.invalidateNetwork(false);
    }

    protected void invalidateNetwork(boolean removeFromWorld) {
        if (removeFromWorld) {
            for (BlockPos pos : this.longDistancePipeBlocks) {
                this.world.removeNetwork(pos);
            }
        }
        this.longDistancePipeBlocks.clear();
        this.world.networkList.remove((Object)this);
        this.invalidateEndpoints();
        this.endpoints.clear();
    }

    public void invalidateEndpoints() {
        this.activeInputIndex = -1;
        this.activeOutputIndex = -1;
        for (ILDEndpoint endpoint : this.endpoints) {
            endpoint.invalidateLink();
        }
    }

    @Nullable
    public ILDEndpoint getOtherEndpoint(ILDEndpoint endpoint) {
        if (!this.isValid() || !endpoint.isInput() && !endpoint.isOutput()) {
            return null;
        }
        int thisIndex = this.endpoints.indexOf(endpoint);
        if (thisIndex < 0) {
            this.recalculateNetwork(Collections.singleton(endpoint.getPos()));
            return null;
        }
        if (this.isIOIndexInvalid()) {
            this.invalidateEndpoints();
        } else if (this.activeInputIndex >= 0) {
            ILDEndpoint out;
            ILDEndpoint in = this.endpoints.get(this.activeInputIndex);
            if (!this.pipeType.satisfiesMinLength(in, out = this.endpoints.get(this.activeOutputIndex))) {
                this.invalidateEndpoints();
                return this.getOtherEndpoint(endpoint);
            }
            if (in == endpoint) {
                if (!endpoint.isInput()) {
                    throw new IllegalStateException("Other endpoint from input was itself");
                }
                return out;
            }
            if (out == endpoint) {
                if (!endpoint.isOutput()) {
                    throw new IllegalStateException("Other endpoint from output was itself");
                }
                return in;
            }
            return null;
        }
        int otherIndex = this.find(endpoint);
        if (otherIndex >= 0) {
            ILDEndpoint other = this.endpoints.get(otherIndex);
            this.activeOutputIndex = endpoint.isOutput() ? thisIndex : otherIndex;
            this.activeInputIndex = endpoint.isInput() ? thisIndex : otherIndex;
            return other;
        }
        return null;
    }

    private int find(ILDEndpoint endpoint) {
        for (int i = 0; i < this.endpoints.size(); ++i) {
            ILDEndpoint other = this.endpoints.get(i);
            if (!other.isValid()) {
                other.invalidateLink();
                this.endpoints.remove(i--);
                continue;
            }
            if (endpoint == other || !other.isOutput() && !other.isInput() || other.isInput() == endpoint.isInput() || !this.pipeType.satisfiesMinLength(endpoint, other)) continue;
            return i;
        }
        return -1;
    }

    public boolean isIOIndexInvalid() {
        return this.activeInputIndex >= 0 && this.activeInputIndex >= this.endpoints.size() || this.activeOutputIndex >= 0 && this.activeOutputIndex >= this.endpoints.size() || this.activeInputIndex < 0 != this.activeOutputIndex < 0;
    }

    public ILDEndpoint getActiveInputIndex() {
        return this.activeInputIndex >= 0 ? this.endpoints.get(this.activeInputIndex) : null;
    }

    public ILDEndpoint getActiveOutputIndex() {
        return this.activeOutputIndex >= 0 ? this.endpoints.get(this.activeOutputIndex) : null;
    }

    public int getTotalSize() {
        return this.longDistancePipeBlocks.size();
    }

    public int getEndpointAmount() {
        return this.endpoints.size();
    }

    public int getPipeAmount() {
        return this.getTotalSize() - this.getEndpointAmount();
    }

    public boolean isValid() {
        return this.getEndpointAmount() > 1;
    }

    public LongDistancePipeType getPipeType() {
        return this.pipeType;
    }

    public static class WorldData
    extends WorldSavedData {
        private static final Object2ObjectOpenHashMap<World, WorldData> WORLD_DATA_MAP = new Object2ObjectOpenHashMap();
        private final Long2ObjectMap<Object2ObjectMap<BlockPos, LongDistanceNetwork>> networks = new Long2ObjectOpenHashMap();
        private final ObjectOpenHashSet<LongDistanceNetwork> networkList = new ObjectOpenHashSet();
        private WeakReference<World> worldRef = new WeakReference<Object>(null);

        public WorldData(String name) {
            super(name);
        }

        public static WorldData get(World world) {
            WorldData worldData = (WorldData)((Object)WORLD_DATA_MAP.get((Object)world));
            if (worldData != null) {
                return worldData;
            }
            String DATA_ID = WorldPipeNet.getDataID("long_dist_pipe", world);
            WorldData netWorldData = (WorldData)world.func_72943_a(WorldData.class, DATA_ID);
            if (netWorldData == null) {
                netWorldData = new WorldData(DATA_ID);
                world.func_72823_a(DATA_ID, (WorldSavedData)netWorldData);
                WORLD_DATA_MAP.put((Object)world, (Object)netWorldData);
            }
            netWorldData.setWorldAndInit(world);
            return netWorldData;
        }

        private static long getChunkPos(BlockPos pos) {
            return ChunkPos.func_77272_a((int)(pos.func_177958_n() >> 4), (int)(pos.func_177952_p() >> 4));
        }

        protected void setWorldAndInit(World world) {
            if (this.worldRef.get() != world) {
                for (LongDistanceNetwork ld : this.networkList) {
                    if (ld.endpointPoss.isEmpty()) continue;
                    ld.endpoints.clear();
                    for (BlockPos pos : ld.endpointPoss) {
                        ILDEndpoint endpoint = ILDEndpoint.tryGet(world, pos);
                        if (endpoint == null) continue;
                        ld.addEndpoint(endpoint);
                    }
                }
            }
            this.worldRef = new WeakReference<World>(world);
        }

        public LongDistanceNetwork getNetwork(BlockPos pos) {
            return (LongDistanceNetwork)((Object2ObjectMap)this.networks.getOrDefault((Object)WorldData.getChunkPos(pos), (Object)Object2ObjectMaps.emptyMap())).get((Object)pos);
        }

        private void putNetwork(BlockPos pos, LongDistanceNetwork network) {
            long chunkPos = WorldData.getChunkPos(pos);
            Object2ObjectMap chunkNetworks = (Object2ObjectMap)this.networks.get(chunkPos);
            if (chunkNetworks == null) {
                chunkNetworks = new Object2ObjectOpenHashMap();
                this.networks.put(chunkPos, (Object)chunkNetworks);
            }
            chunkNetworks.put((Object)pos, (Object)network);
            this.networkList.add((Object)network);
        }

        private void removeNetwork(BlockPos pos) {
            long chunkPos = WorldData.getChunkPos(pos);
            Object2ObjectMap chunkNetworks = (Object2ObjectMap)this.networks.get(chunkPos);
            if (chunkNetworks != null) {
                chunkNetworks.remove((Object)pos);
                if (chunkNetworks.isEmpty()) {
                    this.networks.remove(chunkPos);
                }
            }
        }

        public void func_76184_a(@NotNull NBTTagCompound nbtTagCompound) {
            this.networks.clear();
            this.networkList.clear();
            NBTTagList list = nbtTagCompound.func_150295_c("nets", 10);
            for (NBTBase nbt : list) {
                NBTTagCompound tag = (NBTTagCompound)nbt;
                LongDistancePipeType pipeType = LongDistancePipeType.getPipeType(tag.func_74779_i("class"));
                LongDistanceNetwork ld = pipeType.createNetwork(this);
                ld.activeInputIndex = tag.func_74762_e("in");
                ld.activeOutputIndex = tag.func_74762_e("out");
                this.networkList.add((Object)ld);
                NBTTagList posList = tag.func_150295_c("pipes", 4);
                for (NBTBase nbtPos : posList) {
                    BlockPos pos = BlockPos.func_177969_a((long)((NBTTagLong)nbtPos).func_150291_c());
                    this.putNetwork(pos, ld);
                    ld.longDistancePipeBlocks.add((Object)pos);
                }
                NBTTagList endpoints = tag.func_150295_c("endpoints", 4);
                for (NBTBase nbtPos : endpoints) {
                    BlockPos pos = BlockPos.func_177969_a((long)((NBTTagLong)nbtPos).func_150291_c());
                    if (ld.endpointPoss.contains(pos)) continue;
                    ld.endpointPoss.add(pos);
                }
            }
        }

        @NotNull
        public NBTTagCompound func_189551_b(@NotNull NBTTagCompound nbtTagCompound) {
            NBTTagList list = new NBTTagList();
            for (LongDistanceNetwork network : this.networkList) {
                NBTTagCompound tag = new NBTTagCompound();
                list.func_74742_a((NBTBase)tag);
                String name = network.getPipeType().getName();
                tag.func_74778_a("class", name);
                tag.func_74768_a("in", network.activeInputIndex);
                tag.func_74768_a("out", network.activeOutputIndex);
                NBTTagList posList = new NBTTagList();
                tag.func_74782_a("pipes", (NBTBase)posList);
                for (BlockPos pos : network.longDistancePipeBlocks) {
                    posList.func_74742_a((NBTBase)new NBTTagLong(pos.func_177986_g()));
                }
                NBTTagList endpoints = new NBTTagList();
                tag.func_74782_a("endpoints", (NBTBase)endpoints);
                for (ILDEndpoint endpoint : network.endpoints) {
                    endpoints.func_74742_a((NBTBase)new NBTTagLong(endpoint.pos().func_177986_g()));
                }
            }
            nbtTagCompound.func_74782_a("nets", (NBTBase)list);
            return nbtTagCompound;
        }

        public World getWorld() {
            return (World)this.worldRef.get();
        }
    }
}

