/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pipenet.block.material;

import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.block.material.BlockMaterialPipe;
import gregtech.api.pipenet.block.material.IMaterialPipeTile;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.pipenet.tile.TileEntityPipeBase;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.registry.MaterialRegistry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public abstract class TileEntityMaterialPipeBase<PipeType extends Enum<PipeType>, NodeDataType>
extends TileEntityPipeBase<PipeType, NodeDataType>
implements IMaterialPipeTile<PipeType, NodeDataType> {
    private Material pipeMaterial = Materials.Aluminium;

    @Override
    public Material getPipeMaterial() {
        return this.pipeMaterial;
    }

    public void setPipeData(BlockPipe<PipeType, NodeDataType, ?> pipeBlock, PipeType pipeType, Material pipeMaterial) {
        super.setPipeData(pipeBlock, pipeType);
        this.pipeMaterial = pipeMaterial;
        if (!this.func_145831_w().field_72995_K) {
            this.writeCustomData(GregtechDataCodes.UPDATE_PIPE_MATERIAL, this::writePipeMaterial);
        }
    }

    @Override
    public void setPipeData(BlockPipe<PipeType, NodeDataType, ?> pipeBlock, PipeType pipeType) {
        throw new UnsupportedOperationException("Unsupported for TileEntityMaterialMaterialPipeBase");
    }

    @Override
    public int getDefaultPaintingColor() {
        return this.pipeMaterial == null ? super.getDefaultPaintingColor() : this.pipeMaterial.getMaterialRGB();
    }

    @Override
    public BlockMaterialPipe<PipeType, NodeDataType, ?> getPipeBlock() {
        return (BlockMaterialPipe)super.getPipeBlock();
    }

    @Override
    public void transferDataFrom(IPipeTile<PipeType, NodeDataType> tileEntity) {
        super.transferDataFrom(tileEntity);
        this.pipeMaterial = ((IMaterialPipeTile)tileEntity).getPipeMaterial();
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74778_a("PipeMaterial", this.pipeMaterial.toString());
        return compound;
    }

    @Override
    public void func_145839_a(@NotNull NBTTagCompound compound) {
        super.func_145839_a(compound);
        MaterialRegistry registry = ((BlockMaterialPipe)this.getPipeBlock()).getMaterialRegistry();
        this.pipeMaterial = (Material)registry.func_82594_a(compound.func_74779_i("PipeMaterial"));
        if (this.pipeMaterial == null) {
            this.pipeMaterial = registry.getFallbackMaterial();
        }
    }

    private void writePipeMaterial(@NotNull PacketBuffer buf) {
        buf.func_150787_b(((BlockMaterialPipe)this.getPipeBlock()).getMaterialRegistry().func_148757_b(this.pipeMaterial));
    }

    private void readPipeMaterial(@NotNull PacketBuffer buf) {
        this.pipeMaterial = (Material)((BlockMaterialPipe)this.getPipeBlock()).getMaterialRegistry().func_148754_a(buf.func_150792_a());
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        buf.func_150787_b(((BlockMaterialPipe)this.getPipeBlock()).getMaterialRegistry().func_148757_b(this.pipeMaterial));
        super.writeInitialSyncData(buf);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        this.pipeMaterial = (Material)((BlockMaterialPipe)this.getPipeBlock()).getMaterialRegistry().func_148754_a(buf.func_150792_a());
        super.receiveInitialSyncData(buf);
    }

    @Override
    public void receiveCustomData(int discriminator, PacketBuffer buf) {
        super.receiveCustomData(discriminator, buf);
        if (discriminator == GregtechDataCodes.UPDATE_PIPE_MATERIAL) {
            this.readPipeMaterial(buf);
            this.scheduleChunkForRenderUpdate();
        }
    }
}

