/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pipenet.block.material;

import gregtech.api.pipenet.PipeNet;
import gregtech.api.pipenet.WorldPipeNet;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.block.material.IMaterialPipeTile;
import gregtech.api.pipenet.block.material.IMaterialPipeType;
import gregtech.api.pipenet.block.material.TileEntityMaterialPipeBase;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.pipenet.tile.TileEntityPipeBase;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.registry.MaterialRegistry;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.client.renderer.pipe.PipeRenderer;
import gregtech.common.blocks.MetaBlocks;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public abstract class BlockMaterialPipe<PipeType extends Enum<PipeType> & IMaterialPipeType<NodeDataType>, NodeDataType, WorldPipeNetType extends WorldPipeNet<NodeDataType, ? extends PipeNet<NodeDataType>>>
extends BlockPipe<PipeType, NodeDataType, WorldPipeNetType> {
    protected final PipeType pipeType;
    private final MaterialRegistry registry;

    public BlockMaterialPipe(@NotNull PipeType pipeType, @NotNull MaterialRegistry registry) {
        this.pipeType = pipeType;
        this.registry = registry;
    }

    @Override
    public NodeDataType createProperties(IPipeTile<PipeType, NodeDataType> pipeTile) {
        PipeType pipeType = pipeTile.getPipeType();
        Material material = ((IMaterialPipeTile)pipeTile).getPipeMaterial();
        if (pipeType == null || material == null) {
            return this.getFallbackType();
        }
        return this.createProperties(pipeType, material);
    }

    @Override
    public NodeDataType createItemProperties(ItemStack itemStack) {
        Material material = this.getItemMaterial(itemStack);
        if (this.pipeType == null || material == null) {
            return this.getFallbackType();
        }
        return this.createProperties(this.pipeType, material);
    }

    public ItemStack getItem(Material material) {
        if (material == null) {
            return ItemStack.field_190927_a;
        }
        int materialId = this.registry.func_148757_b(material);
        return new ItemStack((Block)this, 1, materialId);
    }

    public Material getItemMaterial(ItemStack itemStack) {
        return (Material)this.registry.func_148754_a(itemStack.func_77960_j());
    }

    @Override
    public void setTileEntityData(TileEntityPipeBase<PipeType, NodeDataType> pipeTile, ItemStack itemStack) {
        ((TileEntityMaterialPipeBase)pipeTile).setPipeData(this, this.pipeType, this.getItemMaterial(itemStack));
    }

    @Override
    public ItemStack getDropItem(IPipeTile<PipeType, NodeDataType> pipeTile) {
        Material material = ((IMaterialPipeTile)pipeTile).getPipeMaterial();
        return this.getItem(material);
    }

    protected abstract NodeDataType createProperties(PipeType var1, Material var2);

    public OrePrefix getPrefix() {
        return ((IMaterialPipeType)this.pipeType).getOrePrefix();
    }

    @Override
    public PipeType getItemPipeType(ItemStack is) {
        return this.pipeType;
    }

    @NotNull
    public MaterialRegistry getMaterialRegistry() {
        return this.registry;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public abstract PipeRenderer getPipeRenderer();

    public void onModelRegister() {
        ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)this), stack -> this.getPipeRenderer().getModelLocation());
        for (IBlockState state : this.func_176194_O().func_177619_a()) {
            ModelResourceLocation resourceLocation = new ModelResourceLocation(new ResourceLocation("gregtech", Objects.requireNonNull(this.getRegistryName()).func_110623_a()), MetaBlocks.statePropertiesToString(state.func_177228_b()));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)this.func_176201_c(state), (ModelResourceLocation)resourceLocation);
        }
    }
}

