/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pipenet;

import gregtech.api.pipenet.Node;
import gregtech.api.pipenet.WorldPipeNet;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class PipeNet<NodeDataType>
implements INBTSerializable<NBTTagCompound> {
    protected final WorldPipeNet<NodeDataType, PipeNet<NodeDataType>> worldData;
    private final Map<BlockPos, Node<NodeDataType>> nodeByBlockPos = new HashMap<BlockPos, Node<NodeDataType>>();
    private final Map<BlockPos, Node<NodeDataType>> unmodifiableNodeByBlockPos = Collections.unmodifiableMap(this.nodeByBlockPos);
    private final Map<ChunkPos, Integer> ownedChunks = new HashMap<ChunkPos, Integer>();
    private long lastUpdate;
    boolean isValid = false;

    public PipeNet(WorldPipeNet<NodeDataType, ? extends PipeNet<NodeDataType>> world) {
        this.worldData = world;
    }

    public Set<ChunkPos> getContainedChunks() {
        return Collections.unmodifiableSet(this.ownedChunks.keySet());
    }

    public World getWorldData() {
        return this.worldData.getWorld();
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public boolean isValid() {
        return this.isValid;
    }

    protected void onNodeConnectionsUpdate() {
        this.lastUpdate = System.currentTimeMillis();
    }

    public void onPipeConnectionsUpdate() {
    }

    public void onNeighbourUpdate(BlockPos fromPos) {
    }

    public void onChunkUnload() {
    }

    public Map<BlockPos, Node<NodeDataType>> getAllNodes() {
        return this.unmodifiableNodeByBlockPos;
    }

    public Node<NodeDataType> getNodeAt(BlockPos blockPos) {
        return this.nodeByBlockPos.get(blockPos);
    }

    public boolean containsNode(BlockPos blockPos) {
        return this.nodeByBlockPos.containsKey(blockPos);
    }

    protected void addNodeSilently(BlockPos nodePos, Node<NodeDataType> node) {
        this.nodeByBlockPos.put(nodePos, node);
        this.checkAddedInChunk(nodePos);
    }

    protected void addNode(BlockPos nodePos, Node<NodeDataType> node) {
        this.addNodeSilently(nodePos, node);
        this.onNodeConnectionsUpdate();
        this.worldData.func_76185_a();
    }

    protected Node<NodeDataType> removeNodeWithoutRebuilding(BlockPos nodePos) {
        Node<NodeDataType> removedNode = this.nodeByBlockPos.remove(nodePos);
        this.ensureRemovedFromChunk(nodePos);
        this.worldData.func_76185_a();
        return removedNode;
    }

    protected void removeNode(BlockPos nodePos) {
        if (this.nodeByBlockPos.containsKey(nodePos)) {
            Node<NodeDataType> selfNode = this.removeNodeWithoutRebuilding(nodePos);
            this.rebuildNetworkOnNodeRemoval(nodePos, selfNode);
        }
    }

    protected void checkAddedInChunk(BlockPos nodePos) {
        ChunkPos chunkPos = new ChunkPos(nodePos);
        int newValue = this.ownedChunks.compute(chunkPos, (pos, old) -> (old == null ? 0 : old) + 1);
        if (newValue == 1 && this.isValid()) {
            this.worldData.addPipeNetToChunk(chunkPos, this);
        }
    }

    protected void ensureRemovedFromChunk(BlockPos nodePos) {
        ChunkPos chunkPos = new ChunkPos(nodePos);
        int newValue = this.ownedChunks.compute(chunkPos, (pos, old) -> old == null ? 0 : old - 1);
        if (newValue == 0) {
            this.ownedChunks.remove(chunkPos);
            if (this.isValid()) {
                this.worldData.removePipeNetFromChunk(chunkPos, this);
            }
        }
    }

    protected void updateBlockedConnections(BlockPos nodePos, EnumFacing facing, boolean isBlocked) {
        Node<NodeDataType> neighbourNode;
        if (!this.containsNode(nodePos)) {
            return;
        }
        Node<NodeDataType> selfNode = this.getNodeAt(nodePos);
        if (selfNode.isBlocked(facing) == isBlocked) {
            return;
        }
        this.setBlocked(selfNode, facing, isBlocked);
        BlockPos offsetPos = nodePos.func_177972_a(facing);
        PipeNet<NodeDataType> pipeNetAtOffset = this.worldData.getNetFromPos(offsetPos);
        if (pipeNetAtOffset == null) {
            return;
        }
        if (pipeNetAtOffset == this) {
            if (isBlocked) {
                this.setBlocked(selfNode, facing, false);
                if (this.canNodesConnect(selfNode, facing, this.getNodeAt(offsetPos), this)) {
                    this.setBlocked(selfNode, facing, true);
                    HashMap<BlockPos, Node<NodeDataType>> thisENet = this.findAllConnectedBlocks(nodePos);
                    if (!this.getAllNodes().equals(thisENet)) {
                        PipeNet<NodeDataType> newPipeNet = this.worldData.createNetInstance();
                        thisENet.keySet().forEach(this::removeNodeWithoutRebuilding);
                        newPipeNet.transferNodeData(thisENet, this);
                        this.worldData.addPipeNet(newPipeNet);
                    }
                }
            }
        } else if (!isBlocked && this.canNodesConnect(selfNode, facing, neighbourNode = pipeNetAtOffset.getNodeAt(offsetPos), pipeNetAtOffset) && pipeNetAtOffset.canNodesConnect(neighbourNode, facing.func_176734_d(), selfNode, this)) {
            this.uniteNetworks(pipeNetAtOffset);
        }
        this.onNodeConnectionsUpdate();
        this.worldData.func_76185_a();
    }

    protected void updateMark(BlockPos nodePos, int newMark) {
        if (!this.containsNode(nodePos)) {
            return;
        }
        HashMap<BlockPos, Node<NodeDataType>> selfConnectedBlocks = null;
        Node<NodeDataType> selfNode = this.getNodeAt(nodePos);
        int oldMark = selfNode.mark;
        selfNode.mark = newMark;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            HashMap<BlockPos, Node<NodeDataType>> offsetConnectedBlocks;
            Node<NodeDataType> secondNode;
            BlockPos offsetPos = nodePos.func_177972_a(facing);
            PipeNet<NodeDataType> otherPipeNet = this.worldData.getNetFromPos(offsetPos);
            Node<NodeDataType> node = secondNode = otherPipeNet == null ? null : otherPipeNet.getNodeAt(offsetPos);
            if (secondNode == null || !this.areNodeBlockedConnectionsCompatible(selfNode, facing, secondNode) || !this.areNodesCustomContactable(selfNode.data, secondNode.data, otherPipeNet) || PipeNet.areMarksCompatible(oldMark, secondNode.mark) == PipeNet.areMarksCompatible(newMark, secondNode.mark)) continue;
            if (PipeNet.areMarksCompatible(newMark, secondNode.mark)) {
                if (otherPipeNet == this) continue;
                this.uniteNetworks(otherPipeNet);
                continue;
            }
            if (otherPipeNet != this) continue;
            if (selfConnectedBlocks == null) {
                selfConnectedBlocks = this.findAllConnectedBlocks(nodePos);
            }
            if (this.getAllNodes().equals(selfConnectedBlocks) || (offsetConnectedBlocks = this.findAllConnectedBlocks(offsetPos)).equals(selfConnectedBlocks)) continue;
            offsetConnectedBlocks.keySet().forEach(this::removeNodeWithoutRebuilding);
            PipeNet<NodeDataType> offsetPipeNet = this.worldData.createNetInstance();
            offsetPipeNet.transferNodeData(offsetConnectedBlocks, this);
            this.worldData.addPipeNet(offsetPipeNet);
        }
        this.onNodeConnectionsUpdate();
        this.worldData.func_76185_a();
    }

    private void setBlocked(Node<NodeDataType> selfNode, EnumFacing facing, boolean isBlocked) {
        selfNode.openConnections = !isBlocked ? (selfNode.openConnections |= 1 << facing.func_176745_a()) : (selfNode.openConnections &= ~(1 << facing.func_176745_a()));
    }

    public boolean markNodeAsActive(BlockPos nodePos, boolean isActive) {
        if (this.containsNode(nodePos) && this.getNodeAt((BlockPos)nodePos).isActive != isActive) {
            this.getNodeAt((BlockPos)nodePos).isActive = isActive;
            this.worldData.func_76185_a();
            this.onNodeConnectionsUpdate();
            return true;
        }
        return false;
    }

    protected final void uniteNetworks(PipeNet<NodeDataType> unitedPipeNet) {
        HashMap<BlockPos, Node<NodeDataType>> allNodes = new HashMap<BlockPos, Node<NodeDataType>>(unitedPipeNet.getAllNodes());
        this.worldData.removePipeNet(unitedPipeNet);
        allNodes.keySet().forEach(unitedPipeNet::removeNodeWithoutRebuilding);
        this.transferNodeData(allNodes, unitedPipeNet);
    }

    private boolean areNodeBlockedConnectionsCompatible(Node<NodeDataType> first, EnumFacing firstFacing, Node<NodeDataType> second) {
        return !first.isBlocked(firstFacing) && !second.isBlocked(firstFacing.func_176734_d());
    }

    private static boolean areMarksCompatible(int mark1, int mark2) {
        return mark1 == mark2 || mark1 == 0 || mark2 == 0;
    }

    protected final boolean canNodesConnect(Node<NodeDataType> first, EnumFacing firstFacing, Node<NodeDataType> second, PipeNet<NodeDataType> secondPipeNet) {
        return this.areNodeBlockedConnectionsCompatible(first, firstFacing, second) && PipeNet.areMarksCompatible(first.mark, second.mark) && this.areNodesCustomContactable(first.data, second.data, secondPipeNet);
    }

    protected HashMap<BlockPos, Node<NodeDataType>> findAllConnectedBlocks(BlockPos startPos) {
        HashMap<BlockPos, Node<NodeDataType>> observedSet = new HashMap<BlockPos, Node<NodeDataType>>();
        observedSet.put(startPos, this.getNodeAt(startPos));
        Node<NodeDataType> firstNode = this.getNodeAt(startPos);
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos(startPos);
        ArrayDeque<EnumFacing> moveStack = new ArrayDeque<EnumFacing>();
        while (true) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                currentPos.func_189536_c(facing);
                Node<NodeDataType> secondNode = this.getNodeAt((BlockPos)currentPos);
                if (secondNode != null && this.canNodesConnect(firstNode, facing, secondNode, this) && !observedSet.containsKey(currentPos)) {
                    observedSet.put(currentPos.func_185334_h(), this.getNodeAt((BlockPos)currentPos));
                    firstNode = secondNode;
                    moveStack.push(facing.func_176734_d());
                    continue;
                }
                currentPos.func_189536_c(facing.func_176734_d());
            }
            if (moveStack.isEmpty()) break;
            currentPos.func_189536_c((EnumFacing)moveStack.pop());
            firstNode = this.getNodeAt((BlockPos)currentPos);
        }
        return observedSet;
    }

    protected void rebuildNetworkOnNodeRemoval(BlockPos nodePos, Node<NodeDataType> selfNode) {
        BlockPos offsetPos;
        int amountOfConnectedSides = 0;
        for (EnumFacing facing : EnumFacing.values()) {
            offsetPos = nodePos.func_177972_a(facing);
            if (!this.containsNode(offsetPos)) continue;
            ++amountOfConnectedSides;
        }
        if (amountOfConnectedSides >= 2) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                offsetPos = nodePos.func_177972_a(facing);
                Node<NodeDataType> secondNode = this.getNodeAt(offsetPos);
                if (secondNode == null || !this.canNodesConnect(selfNode, facing, secondNode, this)) continue;
                HashMap<BlockPos, Node<NodeDataType>> thisENet = this.findAllConnectedBlocks(offsetPos);
                if (this.getAllNodes().equals(thisENet)) break;
                PipeNet<NodeDataType> energyNet = this.worldData.createNetInstance();
                thisENet.keySet().forEach(this::removeNodeWithoutRebuilding);
                energyNet.transferNodeData(thisENet, this);
                this.worldData.addPipeNet(energyNet);
            }
        }
        if (this.getAllNodes().isEmpty()) {
            this.worldData.removePipeNet(this);
        }
        this.onNodeConnectionsUpdate();
        this.worldData.func_76185_a();
    }

    protected boolean areNodesCustomContactable(NodeDataType first, NodeDataType second, PipeNet<NodeDataType> secondNodePipeNet) {
        return true;
    }

    protected boolean canAttachNode(NodeDataType nodeData) {
        return true;
    }

    protected void transferNodeData(Map<BlockPos, Node<NodeDataType>> transferredNodes, PipeNet<NodeDataType> parentNet) {
        transferredNodes.forEach(this::addNodeSilently);
        this.onNodeConnectionsUpdate();
        this.worldData.func_76185_a();
    }

    protected abstract void writeNodeData(NodeDataType var1, NBTTagCompound var2);

    protected abstract NodeDataType readNodeData(NBTTagCompound var1);

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("Nodes", (NBTBase)this.serializeAllNodeList(this.nodeByBlockPos));
        return compound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.nodeByBlockPos.clear();
        this.ownedChunks.clear();
        this.deserializeAllNodeList(nbt.func_74775_l("Nodes"));
    }

    protected void deserializeAllNodeList(NBTTagCompound compound) {
        int i;
        NBTTagList allNodesList = compound.func_150295_c("NodeIndexes", 10);
        NBTTagList wirePropertiesList = compound.func_150295_c("WireProperties", 10);
        Int2ObjectOpenHashMap readProperties = new Int2ObjectOpenHashMap();
        for (i = 0; i < wirePropertiesList.func_74745_c(); ++i) {
            NBTTagCompound propertiesTag = wirePropertiesList.func_150305_b(i);
            int wirePropertiesIndex = propertiesTag.func_74762_e("index");
            NodeDataType nodeData = this.readNodeData(propertiesTag);
            readProperties.put(wirePropertiesIndex, nodeData);
        }
        for (i = 0; i < allNodesList.func_74745_c(); ++i) {
            NBTTagCompound nodeTag = allNodesList.func_150305_b(i);
            int x = nodeTag.func_74762_e("x");
            int y = nodeTag.func_74762_e("y");
            int z = nodeTag.func_74762_e("z");
            int wirePropertiesIndex = nodeTag.func_74762_e("index");
            BlockPos blockPos = new BlockPos(x, y, z);
            Object nodeData = readProperties.get(wirePropertiesIndex);
            int openConnections = nodeTag.func_74762_e("open");
            int mark = nodeTag.func_74762_e("mark");
            boolean isNodeActive = nodeTag.func_74767_n("active");
            this.addNodeSilently(blockPos, new Node<Object>(nodeData, openConnections, mark, isNodeActive));
        }
    }

    protected NBTTagCompound serializeAllNodeList(Map<BlockPos, Node<NodeDataType>> allNodes) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList allNodesList = new NBTTagList();
        NBTTagList wirePropertiesList = new NBTTagList();
        Object2IntOpenHashMap alreadyWritten = new Object2IntOpenHashMap(10, 0.5f);
        alreadyWritten.defaultReturnValue(-1);
        int currentIndex = 0;
        for (Map.Entry<BlockPos, Node<NodeDataType>> entry : allNodes.entrySet()) {
            BlockPos nodePos = entry.getKey();
            Node<NodeDataType> node = entry.getValue();
            NBTTagCompound nodeTag = new NBTTagCompound();
            nodeTag.func_74768_a("x", nodePos.func_177958_n());
            nodeTag.func_74768_a("y", nodePos.func_177956_o());
            nodeTag.func_74768_a("z", nodePos.func_177952_p());
            int wirePropertiesIndex = alreadyWritten.getInt(node.data);
            if (wirePropertiesIndex == -1) {
                wirePropertiesIndex = currentIndex++;
                alreadyWritten.put(node.data, wirePropertiesIndex);
            }
            nodeTag.func_74768_a("index", wirePropertiesIndex);
            if (node.mark != 0) {
                nodeTag.func_74768_a("mark", node.mark);
            }
            if (node.openConnections > 0) {
                nodeTag.func_74768_a("open", node.openConnections);
            }
            if (node.isActive) {
                nodeTag.func_74757_a("active", true);
            }
            allNodesList.func_74742_a((NBTBase)nodeTag);
        }
        for (Object2IntMap.Entry entry : alreadyWritten.object2IntEntrySet()) {
            NBTTagCompound propertiesTag = new NBTTagCompound();
            propertiesTag.func_74768_a("index", entry.getIntValue());
            this.writeNodeData(entry.getKey(), propertiesTag);
            wirePropertiesList.func_74742_a((NBTBase)propertiesTag);
        }
        compound.func_74782_a("NodeIndexes", (NBTBase)allNodesList);
        compound.func_74782_a("WireProperties", (NBTBase)wirePropertiesList);
        return compound;
    }
}

