/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.multiblock;

import gregtech.api.GTValues;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.util.GTUtility;
import gregtech.api.util.TextComponentUtil;
import gregtech.api.util.TextFormattingUtil;
import gregtech.common.ConfigHolder;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class MultiblockDisplayText {
    private static final ITextComponent EMPTY_COMPONENT = new TextComponentString("");

    public static Builder builder(List<ITextComponent> textList, boolean isStructureFormed) {
        return MultiblockDisplayText.builder(textList, isStructureFormed, true);
    }

    public static Builder builder(List<ITextComponent> textList, boolean isStructureFormed, boolean showIncompleteStructureWarning) {
        return new Builder(textList, isStructureFormed, showIncompleteStructureWarning);
    }

    public static class Builder {
        private final List<ITextComponent> textList;
        private final boolean isStructureFormed;
        private boolean isWorkingEnabled;
        private boolean isActive;
        private String idlingKey = "gregtech.multiblock.idling";
        private String pausedKey = "gregtech.multiblock.work_paused";
        private String runningKey = "gregtech.multiblock.running";

        private Builder(List<ITextComponent> textList, boolean isStructureFormed, boolean showIncompleteStructureWarning) {
            this.textList = textList;
            this.isStructureFormed = isStructureFormed;
            if (!isStructureFormed && showIncompleteStructureWarning) {
                TextComponentTranslation base = TextComponentUtil.translationWithColor(TextFormatting.RED, "gregtech.multiblock.invalid_structure", new Object[0]);
                TextComponentTranslation hover = TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.invalid_structure.tooltip", new Object[0]);
                textList.add(TextComponentUtil.setHover((ITextComponent)base, new ITextComponent[]{hover}));
            }
        }

        public Builder setWorkingStatus(boolean isWorkingEnabled, boolean isActive) {
            this.isWorkingEnabled = isWorkingEnabled;
            this.isActive = isActive;
            return this;
        }

        public Builder setWorkingStatusKeys(String idlingKey, String pausedKey, String runningKey) {
            if (idlingKey != null) {
                this.idlingKey = idlingKey;
            }
            if (pausedKey != null) {
                this.pausedKey = pausedKey;
            }
            if (runningKey != null) {
                this.runningKey = runningKey;
            }
            return this;
        }

        public Builder addEnergyUsageLine(IEnergyContainer energyContainer) {
            if (!this.isStructureFormed) {
                return this;
            }
            if (energyContainer != null && energyContainer.getEnergyCapacity() > 0L) {
                long maxVoltage = Math.max(energyContainer.getInputVoltage(), energyContainer.getOutputVoltage());
                String energyFormatted = TextFormattingUtil.formatNumbers(maxVoltage);
                TextComponentString voltageName = new TextComponentString(GTValues.VNF[GTUtility.getFloorTierByVoltage(maxVoltage)]);
                TextComponentTranslation bodyText = TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.max_energy_per_tick", energyFormatted, voltageName);
                TextComponentTranslation hoverText = TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.max_energy_per_tick_hover", new Object[0]);
                this.textList.add(TextComponentUtil.setHover((ITextComponent)bodyText, new ITextComponent[]{hoverText}));
            }
            return this;
        }

        public Builder addEnergyTierLine(int tier) {
            if (!this.isStructureFormed) {
                return this;
            }
            if (tier < 0 || tier > 14) {
                return this;
            }
            TextComponentString voltageName = new TextComponentString(GTValues.VNF[tier]);
            TextComponentTranslation bodyText = TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.max_recipe_tier", voltageName);
            TextComponentTranslation hoverText = TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.max_recipe_tier_hover", new Object[0]);
            this.textList.add(TextComponentUtil.setHover((ITextComponent)bodyText, new ITextComponent[]{hoverText}));
            return this;
        }

        public Builder addEnergyUsageExactLine(long energyUsage) {
            if (!this.isStructureFormed) {
                return this;
            }
            if (energyUsage > 0L) {
                String energyFormatted = TextFormattingUtil.formatNumbers(energyUsage);
                TextComponentString voltageName = new TextComponentString(GTValues.VNF[GTUtility.getTierByVoltage(energyUsage)]);
                this.textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.energy_consumption", energyFormatted, voltageName));
            }
            return this;
        }

        public Builder addEnergyProductionLine(long maxVoltage, long recipeEUt) {
            if (!this.isStructureFormed) {
                return this;
            }
            if (maxVoltage != 0L && maxVoltage >= -recipeEUt) {
                String energyFormatted = TextFormattingUtil.formatNumbers(maxVoltage);
                TextComponentString voltageName = new TextComponentString(GTValues.VNF[GTUtility.getFloorTierByVoltage(maxVoltage)]);
                this.textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.max_energy_per_tick", energyFormatted, voltageName));
            }
            return this;
        }

        public Builder addEnergyProductionAmpsLine(long maxVoltage, int amperage) {
            if (!this.isStructureFormed) {
                return this;
            }
            if (maxVoltage != 0L && amperage != 0) {
                String energyFormatted = TextFormattingUtil.formatNumbers(maxVoltage);
                TextComponentString voltageName = new TextComponentString(GTValues.VNF[GTUtility.getFloorTierByVoltage(maxVoltage)]);
                this.textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.max_energy_per_tick_amps", energyFormatted, amperage, voltageName));
            }
            return this;
        }

        public Builder addComputationUsageLine(int maxCWUt) {
            if (!this.isStructureFormed) {
                return this;
            }
            if (maxCWUt > 0) {
                TextComponentString computation = TextComponentUtil.stringWithColor(TextFormatting.AQUA, TextFormattingUtil.formatNumbers(maxCWUt));
                this.textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.computation.max", computation));
            }
            return this;
        }

        public Builder addComputationUsageExactLine(int currentCWUt) {
            if (!this.isStructureFormed) {
                return this;
            }
            if (this.isActive && currentCWUt > 0) {
                TextComponentString computation = TextComponentUtil.stringWithColor(TextFormatting.AQUA, TextFormattingUtil.formatNumbers(currentCWUt) + " CWU/t");
                this.textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.computation.usage", computation));
            }
            return this;
        }

        public Builder addWorkingStatusLine() {
            if (!this.isStructureFormed) {
                return this;
            }
            if (!this.isWorkingEnabled) {
                return this.addWorkPausedLine(false);
            }
            if (this.isActive) {
                return this.addRunningPerfectlyLine(false);
            }
            return this.addIdlingLine(false);
        }

        public Builder addWorkPausedLine(boolean checkState) {
            if (!this.isStructureFormed) {
                return this;
            }
            if (!checkState || !this.isWorkingEnabled) {
                this.textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GOLD, this.pausedKey, new Object[0]));
            }
            return this;
        }

        public Builder addRunningPerfectlyLine(boolean checkState) {
            if (!this.isStructureFormed) {
                return this;
            }
            if (!checkState || this.isActive) {
                this.textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GREEN, this.runningKey, new Object[0]));
            }
            return this;
        }

        public Builder addIdlingLine(boolean checkState) {
            if (!this.isStructureFormed) {
                return this;
            }
            if (!checkState || this.isWorkingEnabled && !this.isActive) {
                this.textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GRAY, this.idlingKey, new Object[0]));
            }
            return this;
        }

        public Builder addProgressLine(double progressPercent) {
            if (!this.isStructureFormed || !this.isActive) {
                return this;
            }
            int currentProgress = (int)(progressPercent * 100.0);
            this.textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.progress", new Object[]{currentProgress}));
            return this;
        }

        public Builder addParallelsLine(int numParallels) {
            if (!this.isStructureFormed) {
                return this;
            }
            if (numParallels > 1) {
                TextComponentString parallels = TextComponentUtil.stringWithColor(TextFormatting.DARK_PURPLE, TextFormattingUtil.formatNumbers(numParallels));
                this.textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.parallel", parallels));
            }
            return this;
        }

        public Builder addLowPowerLine(boolean isLowPower) {
            if (!this.isStructureFormed) {
                return this;
            }
            if (isLowPower) {
                this.textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.YELLOW, "gregtech.multiblock.not_enough_energy", new Object[0]));
            }
            return this;
        }

        public Builder addLowComputationLine(boolean isLowComputation) {
            if (!this.isStructureFormed) {
                return this;
            }
            if (isLowComputation) {
                this.textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.YELLOW, "gregtech.multiblock.computation.not_enough_computation", new Object[0]));
            }
            return this;
        }

        public Builder addLowDynamoTierLine(boolean isTooLow) {
            if (!this.isStructureFormed) {
                return this;
            }
            if (isTooLow) {
                this.textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.YELLOW, "gregtech.multiblock.not_enough_energy_output", new Object[0]));
            }
            return this;
        }

        public Builder addMaintenanceProblemLines(byte maintenanceProblems) {
            if (!this.isStructureFormed || !ConfigHolder.machines.enableMaintenance) {
                return this;
            }
            if (maintenanceProblems < 63) {
                boolean hasAddedHeader = false;
                if ((maintenanceProblems & 1) == 0) {
                    hasAddedHeader = this.addMaintenanceProblemHeader(hasAddedHeader);
                    this.textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.universal.problem.wrench", new Object[0]));
                }
                if ((maintenanceProblems >> 1 & 1) == 0) {
                    hasAddedHeader = this.addMaintenanceProblemHeader(hasAddedHeader);
                    this.textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.universal.problem.screwdriver", new Object[0]));
                }
                if ((maintenanceProblems >> 2 & 1) == 0) {
                    hasAddedHeader = this.addMaintenanceProblemHeader(hasAddedHeader);
                    this.textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.universal.problem.soft_mallet", new Object[0]));
                }
                if ((maintenanceProblems >> 3 & 1) == 0) {
                    hasAddedHeader = this.addMaintenanceProblemHeader(hasAddedHeader);
                    this.textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.universal.problem.hard_hammer", new Object[0]));
                }
                if ((maintenanceProblems >> 4 & 1) == 0) {
                    hasAddedHeader = this.addMaintenanceProblemHeader(hasAddedHeader);
                    this.textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.universal.problem.wire_cutter", new Object[0]));
                }
                if ((maintenanceProblems >> 5 & 1) == 0) {
                    this.addMaintenanceProblemHeader(hasAddedHeader);
                    this.textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.universal.problem.crowbar", new Object[0]));
                }
            }
            return this;
        }

        private boolean addMaintenanceProblemHeader(boolean hasAddedHeader) {
            if (!hasAddedHeader) {
                this.textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.YELLOW, "gregtech.multiblock.universal.has_problems", new Object[0]));
            }
            return true;
        }

        public Builder addMufflerObstructedLine(boolean isObstructed) {
            if (!this.isStructureFormed) {
                return this;
            }
            if (isObstructed) {
                this.textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.RED, "gregtech.multiblock.universal.muffler_obstructed", new Object[0]));
                this.textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.universal.muffler_obstructed_desc", new Object[0]));
            }
            return this;
        }

        public Builder addFuelNeededLine(String fuelName, int previousRecipeDuration) {
            if (!this.isStructureFormed || !this.isActive || fuelName == null) {
                return this;
            }
            TextComponentString fuelNeeded = TextComponentUtil.stringWithColor(TextFormatting.RED, fuelName);
            TextComponentString numTicks = TextComponentUtil.stringWithColor(TextFormatting.AQUA, TextFormattingUtil.formatNumbers(previousRecipeDuration));
            this.textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.turbine.fuel_needed", fuelNeeded, numTicks));
            return this;
        }

        public Builder addEmptyLine() {
            this.textList.add(EMPTY_COMPONENT);
            return this;
        }

        public Builder addCustom(Consumer<List<ITextComponent>> customConsumer) {
            customConsumer.accept(this.textList);
            return this;
        }
    }
}

