/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.me.helpers.AENetworkProxy;
import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import com.google.common.base.Preconditions;
import gregtech.api.GTValues;
import gregtech.api.GregTechAPI;
import gregtech.api.block.machines.BlockMachine;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.IDataStickIntractable;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.capability.impl.FluidHandlerProxy;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.ItemHandlerProxy;
import gregtech.api.capability.impl.NotifiableFluidTank;
import gregtech.api.cover.Cover;
import gregtech.api.cover.CoverHolder;
import gregtech.api.cover.CoverRayTracer;
import gregtech.api.cover.CoverSaveHandler;
import gregtech.api.cover.CoverUtil;
import gregtech.api.gui.ModularUI;
import gregtech.api.items.itemhandlers.GTItemStackHandler;
import gregtech.api.items.toolitem.ToolHelper;
import gregtech.api.metatileentity.IVoidable;
import gregtech.api.metatileentity.MTETrait;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.MetaTileEntityUIFactory;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.interfaces.ISyncedTileEntity;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTTransferUtils;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.BloomEffectUtil;
import gregtech.common.ConfigHolder;
import gregtech.common.items.MetaItems;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MetaTileEntity
implements ISyncedTileEntity,
CoverHolder,
IVoidable {
    public static final IndexedCuboid6 FULL_CUBE_COLLISION = new IndexedCuboid6(null, Cuboid6.full);
    public static final String TAG_KEY_PAINTING_COLOR = "PaintingColor";
    public static final String TAG_KEY_MUFFLED = "Muffled";
    public final ResourceLocation metaTileEntityId;
    IGregTechTileEntity holder;
    protected IItemHandlerModifiable importItems;
    protected IItemHandlerModifiable exportItems;
    protected IItemHandler itemInventory;
    protected FluidTankList importFluids;
    protected FluidTankList exportFluids;
    protected IFluidHandler fluidInventory;
    private final Map<String, MTETrait> mteTraits = new Object2ObjectOpenHashMap();
    private final Int2ObjectMap<MTETrait> mteTraitByNetworkId = new Int2ObjectOpenHashMap();
    protected EnumFacing frontFacing = EnumFacing.NORTH;
    private int paintingColor = -1;
    private final int[] sidedRedstoneOutput = new int[6];
    private final int[] sidedRedstoneInput = new int[6];
    private int cachedLightValue;
    private boolean wasExploded = false;
    private final EnumMap<EnumFacing, Cover> covers = new EnumMap(EnumFacing.class);
    protected List<IItemHandlerModifiable> notifiedItemOutputList = new ArrayList<IItemHandlerModifiable>();
    protected List<IItemHandlerModifiable> notifiedItemInputList = new ArrayList<IItemHandlerModifiable>();
    protected List<IFluidHandler> notifiedFluidInputList = new ArrayList<IFluidHandler>();
    protected List<IFluidHandler> notifiedFluidOutputList = new ArrayList<IFluidHandler>();
    protected boolean muffled = false;
    private int playSoundCooldown = 0;
    private int lastTick = 0;
    @SideOnly(value=Side.CLIENT)
    protected ItemStack renderContextStack;

    public MetaTileEntity(ResourceLocation metaTileEntityId) {
        this.metaTileEntityId = metaTileEntityId;
        this.initializeInventory();
    }

    protected void initializeInventory() {
        this.importItems = this.createImportItemHandler();
        this.exportItems = this.createExportItemHandler();
        this.itemInventory = new ItemHandlerProxy((IItemHandler)this.importItems, (IItemHandler)this.exportItems);
        this.importFluids = this.createImportFluidHandler();
        this.exportFluids = this.createExportFluidHandler();
        this.fluidInventory = new FluidHandlerProxy(this.importFluids, this.exportFluids);
    }

    public IGregTechTileEntity getHolder() {
        return this.holder;
    }

    public abstract MetaTileEntity createMetaTileEntity(IGregTechTileEntity var1);

    @Override
    public World getWorld() {
        return this.holder == null ? null : this.holder.world();
    }

    @Override
    public BlockPos getPos() {
        return this.holder == null ? null : this.holder.pos();
    }

    @Override
    public void markDirty() {
        if (this.holder != null) {
            this.holder.markAsDirty();
        }
    }

    public boolean isFirstTick() {
        return this.holder != null && this.holder.isFirstTick();
    }

    @Override
    public long getOffsetTimer() {
        return this.holder == null ? 0L : this.holder.getOffsetTimer();
    }

    @Override
    @Nullable
    public TileEntity getNeighbor(@NotNull EnumFacing facing) {
        return this.holder != null ? this.holder.getNeighbor(facing) : null;
    }

    @Override
    public final void writeCustomData(int discriminator, @NotNull @NotNull Consumer<@NotNull PacketBuffer> dataWriter) {
        if (this.holder != null) {
            this.holder.writeCustomData(discriminator, dataWriter);
        }
    }

    public void addDebugInfo(List<String> list) {
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
    }

    @SideOnly(value=Side.CLIENT)
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        if (this.getSound() != null) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.hammer", (Object[])new Object[0]));
        }
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.crowbar", (Object[])new Object[0]));
    }

    public boolean showToolUsages() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return Pair.of((Object)TextureUtils.getMissingSprite(), (Object)0xFFFFFF);
    }

    @SideOnly(value=Side.CLIENT)
    public void setRenderContextStack(ItemStack itemStack) {
        this.renderContextStack = itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        TextureAtlasSprite atlasSprite = TextureUtils.getMissingSprite();
        IVertexOperation[] renderPipeline = (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering())));
        for (EnumFacing face : EnumFacing.field_82609_l) {
            Textures.renderFace(renderState, translation, renderPipeline, face, Cuboid6.full, atlasSprite, BlockRenderLayer.CUTOUT_MIPPED);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(BlockRenderLayer renderLayer) {
        return renderLayer == BlockRenderLayer.CUTOUT_MIPPED || renderLayer == BloomEffectUtil.getEffectiveBloomLayer() || renderLayer == BlockRenderLayer.TRANSLUCENT && (Boolean)this.getWorld().func_180495_p(this.getPos()).func_177229_b((IProperty)BlockMachine.OPAQUE) == false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getPaintingColorForRendering() {
        NBTTagCompound tagCompound;
        if (this.getWorld() == null && this.renderContextStack != null && (tagCompound = this.renderContextStack.func_77978_p()) != null && tagCompound.func_150297_b(TAG_KEY_PAINTING_COLOR, 3)) {
            return tagCompound.func_74762_e(TAG_KEY_PAINTING_COLOR);
        }
        return this.isPainted() ? this.paintingColor : this.getDefaultPaintingColor();
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick() {
    }

    public void initFromItemStackData(NBTTagCompound itemStack) {
    }

    public void writeItemStackData(NBTTagCompound itemStack) {
    }

    public void getSubItems(CreativeTabs creativeTab, NonNullList<ItemStack> subItems) {
        subItems.add((Object)this.getStackForm());
    }

    public boolean isInCreativeTab(CreativeTabs creativeTab) {
        return creativeTab == CreativeTabs.field_78027_g || creativeTab == GregTechAPI.TAB_GREGTECH_MACHINES;
    }

    public String getItemSubTypeId(ItemStack itemStack) {
        return "";
    }

    public ICapabilityProvider initItemStackCapabilities(ItemStack itemStack) {
        return null;
    }

    public String getMetaName() {
        return String.format("%s.machine.%s", this.metaTileEntityId.func_110624_b(), this.metaTileEntityId.func_110623_a());
    }

    public final String getMetaFullName() {
        return this.getMetaName() + ".name";
    }

    public <T> void addNotifiedInput(T input) {
        if (input instanceof IItemHandlerModifiable) {
            if (!this.notifiedItemInputList.contains(input)) {
                this.notifiedItemInputList.add((IItemHandlerModifiable)input);
            }
        } else if (input instanceof IFluidHandler && !this.notifiedFluidInputList.contains(input)) {
            this.notifiedFluidInputList.add((IFluidHandler)input);
        }
    }

    public <T> void addNotifiedOutput(T output) {
        if (output instanceof IItemHandlerModifiable) {
            if (!this.notifiedItemOutputList.contains(output)) {
                this.notifiedItemOutputList.add((IItemHandlerModifiable)output);
            }
        } else if (output instanceof NotifiableFluidTank && !this.notifiedFluidOutputList.contains(output)) {
            this.notifiedFluidOutputList.add((IFluidHandler)((NotifiableFluidTank)output));
        }
    }

    void addMetaTileEntityTrait(@NotNull MTETrait trait) {
        this.mteTraits.put(trait.getName(), trait);
        this.mteTraitByNetworkId.put(trait.getNetworkID(), (Object)trait);
    }

    @Nullable
    public final MTETrait getMTETrait(@NotNull String name) {
        return this.mteTraits.get(name);
    }

    protected IItemHandlerModifiable createImportItemHandler() {
        return new GTItemStackHandler(this, 0);
    }

    protected IItemHandlerModifiable createExportItemHandler() {
        return new GTItemStackHandler(this, 0);
    }

    protected FluidTankList createImportFluidHandler() {
        return new FluidTankList(false, new IFluidTank[0]);
    }

    protected FluidTankList createExportFluidHandler() {
        return new FluidTankList(false, new IFluidTank[0]);
    }

    protected boolean openGUIOnRightClick() {
        return true;
    }

    protected abstract ModularUI createUI(EntityPlayer var1);

    public ModularUI getModularUI(EntityPlayer entityPlayer) {
        return this.createUI(entityPlayer);
    }

    public final void onCoverLeftClick(EntityPlayer playerIn, CuboidRayTraceResult result) {
        Cover cover = this.getCoverAtSide(result.field_178784_b);
        if (cover == null || !cover.onLeftClick(playerIn, result)) {
            this.onLeftClick(playerIn, result.field_178784_b, result);
        }
    }

    public boolean onRightClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        Cover cover;
        ItemStack heldStack = playerIn.func_184586_b(hand);
        MetaTileEntity metaTileEntity = this;
        if (metaTileEntity instanceof IDataStickIntractable) {
            IDataStickIntractable dsi = (IDataStickIntractable)((Object)metaTileEntity);
            if (MetaItems.TOOL_DATA_STICK.isItemEqual(heldStack) && dsi.onDataStickRightClick(playerIn, heldStack)) {
                return true;
            }
        }
        if (!playerIn.func_70093_af() && this.openGUIOnRightClick()) {
            if (this.getWorld() != null && !this.getWorld().field_72995_K) {
                MetaTileEntityUIFactory.INSTANCE.openUI(this.getHolder(), (EntityPlayerMP)playerIn);
            }
            return true;
        }
        if (heldStack.func_77973_b() == Items.field_151057_cb && playerIn.func_70093_af() && heldStack.func_77978_p() != null && heldStack.func_77978_p().func_74764_b("display")) {
            MetaTileEntityHolder mteHolder = (MetaTileEntityHolder)this.getHolder();
            mteHolder.setCustomName(heldStack.func_77978_p().func_74775_l("display").func_74779_i("Name"));
            if (!playerIn.func_184812_l_()) {
                heldStack.func_190918_g(1);
            }
            return true;
        }
        EnumFacing hitFacing = hitResult.field_178784_b;
        Cover cover2 = cover = hitFacing == null ? null : this.getCoverAtSide(hitFacing);
        if (cover != null && cover.onRightClick(playerIn, hand, hitResult) == EnumActionResult.SUCCESS) {
            return true;
        }
        EnumFacing gridSideHit = CoverRayTracer.determineGridSideHit((RayTraceResult)hitResult);
        Cover cover3 = cover = gridSideHit == null ? null : this.getCoverAtSide(gridSideHit);
        if (cover != null && playerIn.func_70093_af() && playerIn.func_184614_ca().func_190926_b()) {
            return cover.onScrewdriverClick(playerIn, hand, hitResult) == EnumActionResult.SUCCESS;
        }
        return false;
    }

    public final boolean onToolClick(EntityPlayer playerIn, @NotNull Set<String> toolClasses, EnumHand hand, CuboidRayTraceResult hitResult) {
        Cover cover;
        EnumFacing gridSideHit = CoverRayTracer.determineGridSideHit((RayTraceResult)hitResult);
        Cover cover2 = cover = gridSideHit == null ? null : this.getCoverAtSide(gridSideHit);
        if (toolClasses.contains("screwdriver")) {
            if (cover != null && cover.onScrewdriverClick(playerIn, hand, hitResult) == EnumActionResult.SUCCESS) {
                return true;
            }
            return this.onScrewdriverClick(playerIn, hand, gridSideHit, hitResult);
        }
        if (toolClasses.contains("mallet")) {
            if (cover != null && cover.onSoftMalletClick(playerIn, hand, hitResult) == EnumActionResult.SUCCESS) {
                return true;
            }
            return this.onSoftMalletClick(playerIn, hand, gridSideHit, hitResult);
        }
        if (toolClasses.contains("wrench")) {
            return this.onWrenchClick(playerIn, hand, gridSideHit, hitResult);
        }
        if (toolClasses.contains("crowbar")) {
            return this.onCrowbarClick(playerIn, hand, gridSideHit, hitResult);
        }
        if (toolClasses.contains("hammer")) {
            return this.onHardHammerClick(playerIn, hand, gridSideHit, hitResult);
        }
        return false;
    }

    public boolean onWrenchClick(EntityPlayer playerIn, EnumHand hand, EnumFacing wrenchSide, CuboidRayTraceResult hitResult) {
        if (!this.needsSneakToRotate() || playerIn.func_70093_af()) {
            if (wrenchSide == this.getFrontFacing() || !this.isValidFrontFacing(wrenchSide) || !this.hasFrontFacing()) {
                return false;
            }
            if (wrenchSide != null && !this.getWorld().field_72995_K) {
                this.setFrontFacing(wrenchSide);
            }
            return true;
        }
        return false;
    }

    public boolean onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        return false;
    }

    public boolean onCrowbarClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (this.getCoverAtSide(facing) != null) {
            this.removeCover(facing);
            return true;
        }
        return false;
    }

    public boolean onSoftMalletClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        IControllable controllable = this.getCapability(GregtechTileCapabilities.CAPABILITY_CONTROLLABLE, null);
        if (controllable != null) {
            controllable.setWorkingEnabled(!controllable.isWorkingEnabled());
            if (!this.getWorld().field_72995_K) {
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation(controllable.isWorkingEnabled() ? "behaviour.soft_hammer.enabled" : "behaviour.soft_hammer.disabled", new Object[0]), true);
            }
            return true;
        }
        return false;
    }

    public boolean onHardHammerClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        this.toggleMuffled();
        if (!this.getWorld().field_72995_K) {
            playerIn.func_146105_b((ITextComponent)new TextComponentTranslation(this.isMuffled() ? "gregtech.machine.muffle.on" : "gregtech.machine.muffle.off", new Object[0]), true);
        }
        return true;
    }

    public void onLeftClick(EntityPlayer player, EnumFacing facing, CuboidRayTraceResult hitResult) {
        MetaTileEntity metaTileEntity = this;
        if (metaTileEntity instanceof IDataStickIntractable) {
            IDataStickIntractable dsi = (IDataStickIntractable)((Object)metaTileEntity);
            ItemStack stack = player.func_184614_ca();
            if (MetaItems.TOOL_DATA_STICK.isItemEqual(stack)) {
                dsi.onDataStickLeftClick(player, stack);
            }
        }
    }

    public boolean needsSneakToRotate() {
        return false;
    }

    @Override
    @Nullable
    public Cover getCoverAtSide(@NotNull EnumFacing side) {
        return this.covers.get(side);
    }

    @Override
    public boolean hasAnyCover() {
        return !this.covers.isEmpty();
    }

    @Override
    public void addCover(@NotNull EnumFacing side, @NotNull Cover cover) {
        this.covers.put(side, cover);
        if (!this.getWorld().field_72995_K) {
            CoverSaveHandler.writeCoverPlacement(this, GregtechDataCodes.COVER_ATTACHED_MTE, side, cover);
        }
        this.notifyBlockUpdate();
        this.markDirty();
        this.onCoverPlacementUpdate();
    }

    @Override
    public boolean canPlaceCoverOnSide(@NotNull EnumFacing side) {
        ArrayList<IndexedCuboid6> collisionList = new ArrayList<IndexedCuboid6>();
        this.addCollisionBoundingBox(collisionList);
        return !CoverUtil.doesCoverCollide(side, collisionList, this.getCoverPlateThickness());
    }

    @Override
    public final boolean acceptsCovers() {
        return this.covers.size() < EnumFacing.field_82609_l.length;
    }

    @Override
    public final void removeCover(@NotNull EnumFacing side) {
        Cover cover = this.getCoverAtSide(side);
        if (cover == null) {
            return;
        }
        this.dropCover(side);
        this.covers.remove(side);
        this.writeCustomData(GregtechDataCodes.COVER_REMOVED_MTE, buffer -> buffer.writeByte(side.func_176745_a()));
        this.notifyBlockUpdate();
        this.markDirty();
        this.onCoverPlacementUpdate();
    }

    protected void onCoverPlacementUpdate() {
    }

    @Override
    public double getCoverPlateThickness() {
        return 0.0;
    }

    @Override
    public boolean shouldRenderCoverBackSides() {
        return !this.isOpaqueCube();
    }

    public void onLoad() {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            this.sidedRedstoneInput[side.func_176745_a()] = GTUtility.getRedstonePower(this.getWorld(), this.getPos(), side);
        }
    }

    public void onUnload() {
    }

    public final boolean canConnectRedstone(@Nullable EnumFacing side) {
        if (side == null) {
            return this.canConnectRedstone(EnumFacing.UP) || this.canConnectRedstone(EnumFacing.DOWN);
        }
        Cover cover = this.getCoverAtSide(side);
        if (cover == null) {
            return this.canMachineConnectRedstone(side);
        }
        return cover.canConnectRedstone();
    }

    protected boolean canMachineConnectRedstone(EnumFacing side) {
        return false;
    }

    @Override
    public final int getInputRedstoneSignal(@NotNull EnumFacing side, boolean ignoreCover) {
        if (!ignoreCover && this.getCoverAtSide(side) != null) {
            return 0;
        }
        return this.sidedRedstoneInput[side.func_176745_a()];
    }

    public final boolean isBlockRedstonePowered() {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (this.getInputRedstoneSignal(side, false) <= 0) continue;
            return true;
        }
        return false;
    }

    public void onNeighborChanged() {
    }

    public void updateInputRedstoneSignals() {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            int currentValue;
            int redstoneValue = GTUtility.getRedstonePower(this.getWorld(), this.getPos(), side);
            if (redstoneValue == (currentValue = this.sidedRedstoneInput[side.func_176745_a()])) continue;
            this.sidedRedstoneInput[side.func_176745_a()] = redstoneValue;
            Cover cover = this.getCoverAtSide(side);
            if (cover == null) continue;
            cover.onRedstoneInputSignalChange(redstoneValue);
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.9")
    public int getActualComparatorValue() {
        return 0;
    }

    public int getActualLightValue() {
        return 0;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.9")
    public final int getComparatorValue() {
        return 0;
    }

    public final int getLightValue() {
        return this.cachedLightValue;
    }

    private void updateLightValue() {
        int newLightValue = this.getActualLightValue();
        if (this.cachedLightValue != newLightValue) {
            this.cachedLightValue = newLightValue;
            if (this.getWorld() != null) {
                this.getWorld().func_175664_x(this.getPos());
            }
        }
    }

    public void update() {
        if (!this.getWorld().field_72995_K && !this.allowTickAcceleration()) {
            int currentTick = FMLCommonHandler.instance().getMinecraftServerInstance().func_71259_af();
            if (currentTick == this.lastTick) {
                return;
            }
            this.lastTick = currentTick;
        }
        for (MTETrait mteTrait : this.mteTraits.values()) {
            if (!this.shouldUpdate(mteTrait)) continue;
            mteTrait.update();
        }
        if (!this.getWorld().field_72995_K) {
            this.updateCovers();
        } else {
            this.updateSound();
        }
        if (this.getOffsetTimer() % 5L == 0L) {
            this.updateLightValue();
        }
    }

    public boolean allowTickAcceleration() {
        return ConfigHolder.machines.allowTickAcceleration;
    }

    protected boolean shouldUpdate(MTETrait trait) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSound() {
        if (!ConfigHolder.machines.machineSounds || this.isMuffled()) {
            return;
        }
        SoundEvent sound = this.getSound();
        if (sound == null) {
            return;
        }
        if (this.isValid() && this.isActive()) {
            if (--this.playSoundCooldown > 0) {
                return;
            }
            GregTechAPI.soundManager.startTileSound(sound.func_187503_a(), this.getVolume(), this.getPos());
            this.playSoundCooldown = 20;
        } else {
            GregTechAPI.soundManager.stopTileSound(this.getPos());
            this.playSoundCooldown = 0;
        }
    }

    public final ItemStack getStackForm(int amount) {
        int metaTileEntityIntId = GregTechAPI.MTE_REGISTRY.getIdByObjectName(this.metaTileEntityId);
        return new ItemStack((Block)GregTechAPI.MACHINE, amount, metaTileEntityIntId);
    }

    public final ItemStack getStackForm() {
        return this.getStackForm(1);
    }

    public void getDrops(NonNullList<ItemStack> dropsList, @Nullable EntityPlayer harvester) {
    }

    public final ItemStack getPickItem(CuboidRayTraceResult result, EntityPlayer player) {
        Cover cover;
        IndexedCuboid6 hitCuboid = result.cuboid6;
        Object object = hitCuboid.data;
        if (object instanceof CoverRayTracer.CoverSideData) {
            CoverRayTracer.CoverSideData coverSideData = (CoverRayTracer.CoverSideData)object;
            cover = this.getCoverAtSide(coverSideData.side);
            return cover == null ? ItemStack.field_190927_a : cover.getPickItem();
        }
        if (hitCuboid.data == null || hitCuboid.data instanceof CoverRayTracer.PrimaryBoxData) {
            cover = this.getCoverAtSide(result.field_178784_b);
            if (cover != null) {
                return cover.getPickItem();
            }
            return this.getPickItem(player);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getPickItem(EntityPlayer player) {
        return this.getStackForm();
    }

    public boolean isOpaqueCube() {
        return true;
    }

    public int getLightOpacity() {
        return 255;
    }

    public void addCollisionBoundingBox(List<IndexedCuboid6> collisionList) {
        collisionList.add(FULL_CUBE_COLLISION);
    }

    public BlockFaceShape getFaceShape(EnumFacing side) {
        return this.isOpaqueCube() ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public String getHarvestTool() {
        return "wrench";
    }

    public int getHarvestLevel() {
        return 1;
    }

    @Override
    public void writeInitialSyncData(@NotNull PacketBuffer buf) {
        buf.writeByte(this.frontFacing.func_176745_a());
        buf.writeInt(this.paintingColor);
        buf.writeShort(this.mteTraitByNetworkId.size());
        for (Int2ObjectMap.Entry entry : this.mteTraitByNetworkId.int2ObjectEntrySet()) {
            buf.func_150787_b(entry.getIntKey());
            ((MTETrait)entry.getValue()).writeInitialData(buf);
        }
        CoverSaveHandler.writeInitialSyncData(buf, this);
        buf.writeBoolean(this.muffled);
    }

    public boolean isPainted() {
        return this.paintingColor != -1;
    }

    @Override
    public void receiveInitialSyncData(@NotNull PacketBuffer buf) {
        this.frontFacing = EnumFacing.field_82609_l[buf.readByte()];
        this.paintingColor = buf.readInt();
        int amountOfTraits = buf.readShort();
        for (int i = 0; i < amountOfTraits; ++i) {
            int traitNetworkId = buf.func_150792_a();
            MTETrait trait = (MTETrait)this.mteTraitByNetworkId.get(traitNetworkId);
            if (trait == null) {
                GTLog.logger.warn("Could not find MTETrait for id: {} at position {}.", (Object)traitNetworkId, (Object)this.getPos());
                continue;
            }
            trait.receiveInitialData(buf);
        }
        CoverSaveHandler.receiveInitialSyncData(buf, this);
        this.muffled = buf.readBoolean();
    }

    public void writeTraitData(MTETrait trait, int internalId, Consumer<PacketBuffer> dataWriter) {
        this.writeCustomData(GregtechDataCodes.SYNC_MTE_TRAITS, buffer -> {
            buffer.func_150787_b(trait.getNetworkID());
            buffer.func_150787_b(internalId);
            dataWriter.accept((PacketBuffer)buffer);
        });
    }

    @Override
    public void writeCoverData(@NotNull Cover cover, int discriminator, @NotNull @NotNull Consumer<@NotNull PacketBuffer> buf) {
        this.writeCustomData(GregtechDataCodes.UPDATE_COVER_DATA_MTE, buffer -> {
            buffer.writeByte(cover.getAttachedSide().func_176745_a());
            buffer.func_150787_b(discriminator);
            buf.accept((PacketBuffer)buffer);
        });
    }

    @Override
    public void receiveCustomData(int dataId, @NotNull PacketBuffer buf) {
        if (dataId == GregtechDataCodes.UPDATE_FRONT_FACING) {
            this.frontFacing = EnumFacing.field_82609_l[buf.readByte()];
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.UPDATE_PAINTING_COLOR) {
            this.paintingColor = buf.readInt();
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.SYNC_MTE_TRAITS) {
            int traitNetworkId = buf.func_150792_a();
            MTETrait trait = (MTETrait)this.mteTraitByNetworkId.get(traitNetworkId);
            if (trait == null) {
                GTLog.logger.warn("Could not find MTETrait for id: {} at position {}.", (Object)traitNetworkId, (Object)this.getPos());
            } else {
                trait.receiveCustomData(buf.func_150792_a(), buf);
            }
        } else if (dataId == GregtechDataCodes.COVER_ATTACHED_MTE) {
            CoverSaveHandler.readCoverPlacement(buf, this);
        } else if (dataId == GregtechDataCodes.COVER_REMOVED_MTE) {
            EnumFacing placementSide = EnumFacing.field_82609_l[buf.readByte()];
            this.covers.remove(placementSide);
            this.onCoverPlacementUpdate();
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.UPDATE_COVER_DATA_MTE) {
            EnumFacing coverSide = EnumFacing.field_82609_l[buf.readByte()];
            Cover cover = this.getCoverAtSide(coverSide);
            int internalId = buf.func_150792_a();
            if (cover != null) {
                cover.readCustomData(internalId, buf);
            }
        } else if (dataId == GregtechDataCodes.UPDATE_SOUND_MUFFLED) {
            this.muffled = buf.readBoolean();
            if (this.muffled) {
                GregTechAPI.soundManager.stopTileSound(this.getPos());
            }
        }
    }

    public BlockFaceShape getCoverFaceShape(EnumFacing side) {
        if (this.getCoverAtSide(side) != null) {
            return BlockFaceShape.SOLID;
        }
        return this.getFaceShape(side);
    }

    public final <T> T getCoverCapability(Capability<T> capability, EnumFacing side) {
        boolean isCoverable = capability == GregtechTileCapabilities.CAPABILITY_COVER_HOLDER;
        Cover cover = side == null ? null : this.getCoverAtSide(side);
        T originalCapability = this.getCapability(capability, side);
        if (cover != null && !isCoverable) {
            return cover.getCapability(capability, originalCapability);
        }
        return originalCapability;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        IEnergyContainer energyContainer;
        MTETrait mteTrait;
        if (capability == GregtechTileCapabilities.CAPABILITY_COVER_HOLDER) {
            return (T)GregtechTileCapabilities.CAPABILITY_COVER_HOLDER.cast((Object)this);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.getFluidInventory().getTankProperties().length > 0) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.getFluidInventory());
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.getItemInventory().getSlots() > 0) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.getItemInventory());
        }
        T capabilityResult = null;
        Iterator<MTETrait> iterator = this.mteTraits.values().iterator();
        while (iterator.hasNext() && (capabilityResult = (T)(mteTrait = iterator.next()).getCapability(capability)) == null) {
        }
        if (side != null && capabilityResult instanceof IEnergyContainer && !(energyContainer = (IEnergyContainer)capabilityResult).inputsEnergy(side) && !energyContainer.outputsEnergy(side)) {
            return null;
        }
        return capabilityResult;
    }

    public void fillInternalTankFromFluidContainer() {
        this.fillInternalTankFromFluidContainer(this.importFluids);
    }

    public void fillInternalTankFromFluidContainer(IFluidHandler fluidHandler) {
        for (int i = 0; i < this.importItems.getSlots(); ++i) {
            ItemStack remainingItem;
            ItemStack inputContainerStack = this.importItems.extractItem(i, 1, true);
            FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)inputContainerStack, (IFluidHandler)fluidHandler, (int)Integer.MAX_VALUE, null, (boolean)false);
            if (!result.isSuccess() || ItemStack.func_77989_b((ItemStack)inputContainerStack, (ItemStack)(remainingItem = result.getResult())) || !remainingItem.func_190926_b() && !GTTransferUtils.insertItem((IItemHandler)this.exportItems, remainingItem, true).func_190926_b()) continue;
            FluidUtil.tryEmptyContainer((ItemStack)inputContainerStack, (IFluidHandler)fluidHandler, (int)Integer.MAX_VALUE, null, (boolean)true);
            this.importItems.extractItem(i, 1, false);
            GTTransferUtils.insertItem((IItemHandler)this.exportItems, remainingItem, false);
        }
    }

    public void fillContainerFromInternalTank() {
        this.fillContainerFromInternalTank(this.exportFluids);
    }

    public void fillContainerFromInternalTank(IFluidHandler fluidHandler) {
        for (int i = 0; i < this.importItems.getSlots(); ++i) {
            ItemStack remainingItem;
            ItemStack emptyContainer = this.importItems.extractItem(i, 1, true);
            FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)emptyContainer, (IFluidHandler)fluidHandler, (int)Integer.MAX_VALUE, null, (boolean)false);
            if (!result.isSuccess() || !(remainingItem = result.getResult()).func_190926_b() && !GTTransferUtils.insertItem((IItemHandler)this.exportItems, remainingItem, true).func_190926_b()) continue;
            FluidUtil.tryFillContainer((ItemStack)emptyContainer, (IFluidHandler)fluidHandler, (int)Integer.MAX_VALUE, null, (boolean)true);
            this.importItems.extractItem(i, 1, false);
            GTTransferUtils.insertItem((IItemHandler)this.exportItems, remainingItem, false);
        }
    }

    public void pushFluidsIntoNearbyHandlers(EnumFacing ... allowedFaces) {
        this.transferToNearby(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, GTTransferUtils::transferFluids, allowedFaces);
    }

    public void pullFluidsFromNearbyHandlers(EnumFacing ... allowedFaces) {
        this.transferToNearby(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, (thisCap, otherCap) -> GTTransferUtils.transferFluids(otherCap, thisCap), allowedFaces);
    }

    public void pushItemsIntoNearbyHandlers(EnumFacing ... allowedFaces) {
        this.transferToNearby(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, GTTransferUtils::moveInventoryItems, allowedFaces);
    }

    public void pullItemsFromNearbyHandlers(EnumFacing ... allowedFaces) {
        this.transferToNearby(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (thisCap, otherCap) -> GTTransferUtils.moveInventoryItems(otherCap, thisCap), allowedFaces);
    }

    private <T> void transferToNearby(Capability<T> capability, BiConsumer<T, T> transfer, EnumFacing ... allowedFaces) {
        for (EnumFacing nearbyFacing : allowedFaces) {
            TileEntity tileEntity = this.getNeighbor(nearbyFacing);
            if (tileEntity == null) continue;
            Object otherCap = tileEntity.getCapability(capability, nearbyFacing.func_176734_d());
            T thisCap = this.getCoverCapability(capability, nearbyFacing);
            if (otherCap == null || thisCap == null) continue;
            transfer.accept(thisCap, otherCap);
        }
    }

    public final int getOutputRedstoneSignal(@Nullable EnumFacing side) {
        if (side == null) {
            return this.getHighestOutputRedstoneSignal();
        }
        Cover cover = this.getCoverAtSide(side);
        int sidedOutput = this.sidedRedstoneOutput[side.func_176745_a()];
        return cover == null ? sidedOutput : cover.getRedstoneSignalOutput();
    }

    public final int getHighestOutputRedstoneSignal() {
        int highestSignal = 0;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            Cover cover = this.getCoverAtSide(side);
            int sidedOutput = this.sidedRedstoneOutput[side.func_176745_a()];
            int sideResult = cover == null ? sidedOutput : cover.getRedstoneSignalOutput();
            highestSignal = Math.max(highestSignal, sideResult);
        }
        return highestSignal;
    }

    public final void setOutputRedstoneSignal(EnumFacing side, int strength) {
        Preconditions.checkNotNull((Object)side, (Object)"side");
        this.sidedRedstoneOutput[side.func_176745_a()] = strength;
        if (this.getWorld() != null && !this.getWorld().field_72995_K && this.getCoverAtSide(side) == null) {
            this.notifyBlockUpdate();
        }
    }

    @Override
    public void notifyBlockUpdate() {
        if (this.holder != null) {
            this.holder.notifyBlockUpdate();
        }
    }

    @Override
    public void scheduleRenderUpdate() {
        if (this.holder != null) {
            this.holder.scheduleRenderUpdate();
        }
    }

    public void setFrontFacing(EnumFacing frontFacing) {
        Preconditions.checkNotNull((Object)frontFacing, (Object)"frontFacing");
        this.frontFacing = frontFacing;
        if (this.getWorld() != null && !this.getWorld().field_72995_K) {
            this.notifyBlockUpdate();
            this.markDirty();
            this.writeCustomData(GregtechDataCodes.UPDATE_FRONT_FACING, buf -> buf.writeByte(frontFacing.func_176745_a()));
            for (MTETrait mteTrait : this.mteTraits.values()) {
                mteTrait.onFrontFacingSet(frontFacing);
            }
        }
    }

    public void setPaintingColor(int paintingColor) {
        this.paintingColor = paintingColor;
        if (this.getWorld() != null && !this.getWorld().field_72995_K) {
            this.notifyBlockUpdate();
            this.markDirty();
            this.writeCustomData(GregtechDataCodes.UPDATE_PAINTING_COLOR, buf -> buf.writeInt(paintingColor));
        }
    }

    public int getDefaultPaintingColor() {
        return ConfigHolder.client.defaultPaintingColor;
    }

    public boolean isValidFrontFacing(EnumFacing facing) {
        if (this.hasFrontFacing() && this.getFrontFacing() == facing) {
            return false;
        }
        return facing != EnumFacing.UP && facing != EnumFacing.DOWN;
    }

    public boolean hasFrontFacing() {
        return true;
    }

    protected boolean shouldSerializeInventories() {
        return true;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        data.func_74768_a("FrontFacing", this.frontFacing.func_176745_a());
        if (this.isPainted()) {
            data.func_74768_a(TAG_KEY_PAINTING_COLOR, this.paintingColor);
        }
        data.func_74768_a("CachedLightValue", this.cachedLightValue);
        if (this.shouldSerializeInventories()) {
            GTUtility.writeItems((IItemHandler)this.importItems, "ImportInventory", data);
            GTUtility.writeItems((IItemHandler)this.exportItems, "ExportInventory", data);
            data.func_74782_a("ImportFluidInventory", (NBTBase)this.importFluids.serializeNBT());
            data.func_74782_a("ExportFluidInventory", (NBTBase)this.exportFluids.serializeNBT());
        }
        for (MTETrait mteTrait : this.mteTraits.values()) {
            data.func_74782_a(mteTrait.getName(), (NBTBase)mteTrait.serializeNBT());
        }
        CoverSaveHandler.writeCoverNBT(data, this);
        data.func_74757_a(TAG_KEY_MUFFLED, this.muffled);
        return data;
    }

    public void readFromNBT(NBTTagCompound data) {
        this.frontFacing = EnumFacing.field_82609_l[data.func_74762_e("FrontFacing")];
        if (data.func_74764_b(TAG_KEY_PAINTING_COLOR)) {
            this.paintingColor = data.func_74762_e(TAG_KEY_PAINTING_COLOR);
        }
        this.cachedLightValue = data.func_74762_e("CachedLightValue");
        if (this.shouldSerializeInventories()) {
            GTUtility.readItems(this.importItems, "ImportInventory", data);
            GTUtility.readItems(this.exportItems, "ExportInventory", data);
            this.importFluids.deserializeNBT(data.func_74775_l("ImportFluidInventory"));
            this.exportFluids.deserializeNBT(data.func_74775_l("ExportFluidInventory"));
        }
        for (MTETrait mteTrait : this.mteTraits.values()) {
            NBTTagCompound traitCompound = data.func_74775_l(mteTrait.getName());
            mteTrait.deserializeNBT(traitCompound);
        }
        CoverSaveHandler.readCoverNBT(data, this, this.covers::put);
        this.muffled = data.func_74767_n(TAG_KEY_MUFFLED);
    }

    @Override
    public boolean isValid() {
        return this.getHolder() != null && this.getHolder().isValid();
    }

    public void clearMachineInventory(NonNullList<ItemStack> itemBuffer) {
        MetaTileEntity.clearInventory(itemBuffer, this.importItems);
        MetaTileEntity.clearInventory(itemBuffer, this.exportItems);
    }

    public static void clearInventory(NonNullList<ItemStack> itemBuffer, IItemHandlerModifiable inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stackInSlot = inventory.getStackInSlot(i);
            if (stackInSlot.func_190926_b()) continue;
            inventory.setStackInSlot(i, ItemStack.field_190927_a);
            itemBuffer.add((Object)stackInSlot);
        }
    }

    public int getItemStackLimit(ItemStack stack) {
        return 64;
    }

    public void onPlacement() {
    }

    public void onRemoval() {
    }

    public void invalidate() {
        if (this.getWorld() != null && this.getWorld().field_72995_K) {
            GregTechAPI.soundManager.stopTileSound(this.getPos());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public SoundEvent getSound() {
        return null;
    }

    public boolean isActive() {
        return false;
    }

    @NotNull
    public EnumFacing getFrontFacing() {
        return this.frontFacing;
    }

    public int getPaintingColor() {
        return this.paintingColor;
    }

    public IItemHandler getItemInventory() {
        return this.itemInventory;
    }

    public IFluidHandler getFluidInventory() {
        return this.fluidInventory;
    }

    public IItemHandlerModifiable getImportItems() {
        return this.importItems;
    }

    public IItemHandlerModifiable getExportItems() {
        return this.exportItems;
    }

    public FluidTankList getImportFluids() {
        return this.importFluids;
    }

    public FluidTankList getExportFluids() {
        return this.exportFluids;
    }

    public List<IItemHandlerModifiable> getNotifiedItemOutputList() {
        return this.notifiedItemOutputList;
    }

    public List<IItemHandlerModifiable> getNotifiedItemInputList() {
        return this.notifiedItemInputList;
    }

    public List<IFluidHandler> getNotifiedFluidInputList() {
        return this.notifiedFluidInputList;
    }

    public List<IFluidHandler> getNotifiedFluidOutputList() {
        return this.notifiedFluidOutputList;
    }

    public boolean shouldDropWhenDestroyed() {
        return !this.wasExploded();
    }

    public float getBlockHardness() {
        return 6.0f;
    }

    public float getBlockResistance() {
        return 6.0f;
    }

    public boolean keepsInventory() {
        return false;
    }

    public boolean getWitherProof() {
        return false;
    }

    public final void toggleMuffled() {
        boolean bl = this.muffled = !this.muffled;
        if (!this.getWorld().field_72995_K) {
            this.writeCustomData(GregtechDataCodes.UPDATE_SOUND_MUFFLED, buf -> buf.writeBoolean(this.muffled));
        }
    }

    public boolean isMuffled() {
        return this.muffled;
    }

    public boolean canRenderFrontFaceX() {
        return false;
    }

    public boolean isSideUsed(EnumFacing face) {
        if (this.getCoverAtSide(face) != null) {
            return true;
        }
        return face == this.getFrontFacing() && this.canRenderFrontFaceX();
    }

    @Nullable
    public final AbstractRecipeLogic getRecipeLogic() {
        MTETrait trait = this.getMTETrait("RecipeMapWorkable");
        if (trait instanceof AbstractRecipeLogic) {
            return (AbstractRecipeLogic)trait;
        }
        if (trait != null) {
            throw new IllegalStateException("MTE Trait " + trait.getName() + " has name " + "RecipeMapWorkable" + " but is not instanceof AbstractRecipeLogic");
        }
        return null;
    }

    @Nullable
    public final RecipeMap<?> getRecipeMap() {
        AbstractRecipeLogic recipeLogic = this.getRecipeLogic();
        return recipeLogic == null ? null : recipeLogic.getRecipeMap();
    }

    public void checkWeatherOrTerrainExplosion(float explosionPower, double additionalFireChance, IEnergyContainer energyContainer) {
        World world = this.getWorld();
        if (!world.field_72995_K && ConfigHolder.machines.doTerrainExplosion && !this.getIsWeatherOrTerrainResistant() && energyContainer.getEnergyStored() != 0L) {
            if (GTValues.RNG.nextInt(1000) == 0) {
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    Block block = this.getWorld().func_180495_p(this.getPos().func_177972_a(side)).func_177230_c();
                    if (block != Blocks.field_150480_ab && block != Blocks.field_150355_j && block != Blocks.field_150358_i && block != Blocks.field_150353_l && block != Blocks.field_150356_k) continue;
                    this.doExplosion(explosionPower);
                    return;
                }
            }
            if (GTValues.RNG.nextInt(1000) == 0 && (world.func_175727_C(this.getPos()) || world.func_175727_C(this.getPos().func_177974_f()) || world.func_175727_C(this.getPos().func_177976_e()) || world.func_175727_C(this.getPos().func_177978_c()) || world.func_175727_C(this.getPos().func_177968_d()))) {
                if (world.func_72911_I() && GTValues.RNG.nextInt(3) == 0) {
                    this.doExplosion(explosionPower);
                } else if (GTValues.RNG.nextInt(10) == 0) {
                    this.doExplosion(explosionPower);
                } else {
                    this.setOnFire(additionalFireChance);
                }
            }
        }
    }

    public void doExplosion(float explosionPower) {
        this.setExploded();
        this.getWorld().func_175698_g(this.getPos());
        this.getWorld().func_72876_a(null, (double)this.getPos().func_177958_n() + 0.5, (double)this.getPos().func_177956_o() + 0.5, (double)this.getPos().func_177952_p() + 0.5, explosionPower, ConfigHolder.machines.doesExplosionDamagesTerrain);
    }

    protected final void setExploded() {
        this.wasExploded = true;
    }

    protected final boolean wasExploded() {
        return this.wasExploded;
    }

    public void setOnFire(double additionalFireChance) {
        boolean isFirstFireSpawned = false;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (!this.getWorld().func_175623_d(this.getPos().func_177972_a(side))) continue;
            if (!isFirstFireSpawned) {
                this.getWorld().func_180501_a(this.getPos().func_177972_a(side), Blocks.field_150480_ab.func_176223_P(), 11);
                if (this.getWorld().func_175623_d(this.getPos().func_177972_a(side))) continue;
                isFirstFireSpawned = true;
                continue;
            }
            if (!(additionalFireChance >= GTValues.RNG.nextDouble() * 100.0)) continue;
            this.getWorld().func_180501_a(this.getPos().func_177972_a(side), Blocks.field_150480_ab.func_176223_P(), 11);
        }
    }

    public boolean getIsWeatherOrTerrainResistant() {
        return false;
    }

    public boolean doTickProfileMessage() {
        return true;
    }

    public boolean canRenderMachineGrid(@NotNull ItemStack mainHandStack, @NotNull ItemStack offHandStack) {
        String[] tools = new String[]{"wrench", "screwdriver"};
        return ToolHelper.isTool(mainHandStack, tools) || ToolHelper.isTool(offHandStack, tools);
    }

    public float getVolume() {
        return 1.0f;
    }

    @Override
    public boolean canVoidRecipeItemOutputs() {
        return false;
    }

    @Override
    public boolean canVoidRecipeFluidOutputs() {
        return false;
    }

    @Optional.Method(modid="appliedenergistics2")
    @NotNull
    public AECableType getCableConnectionType(@NotNull AEPartLocation part) {
        return AECableType.NONE;
    }

    @Optional.Method(modid="appliedenergistics2")
    @Nullable
    public AENetworkProxy getProxy() {
        return null;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void gridChanged() {
    }
}

