/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.materialitem;

import gregtech.api.GregTechAPI;
import gregtech.api.damagesources.DamageSources;
import gregtech.api.items.armor.ArmorMetaItem;
import gregtech.api.items.metaitem.StandardMetaItem;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.info.MaterialIconSet;
import gregtech.api.unification.material.properties.DustProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.material.properties.ToolProperty;
import gregtech.api.unification.material.registry.MaterialRegistry;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaPrefixItem
extends StandardMetaItem {
    private final MaterialRegistry registry;
    private final OrePrefix prefix;
    public static final Map<OrePrefix, OrePrefix> purifyMap = new HashMap<OrePrefix, OrePrefix>();

    public MetaPrefixItem(@NotNull MaterialRegistry registry, @NotNull OrePrefix orePrefix) {
        this.registry = registry;
        this.prefix = orePrefix;
        this.setCreativeTab(GregTechAPI.TAB_GREGTECH_MATERIALS);
    }

    @Override
    public void registerSubItems() {
        Iterator iterator = this.registry.iterator();
        while (iterator.hasNext()) {
            Material material = (Material)iterator.next();
            short i = (short)this.registry.func_148757_b(material);
            if (this.prefix == null || !MetaPrefixItem.canGenerate(this.prefix, material)) continue;
            this.addItem(i, new UnificationEntry(this.prefix, material).toString());
        }
    }

    public void registerOreDict() {
        ShortIterator shortIterator = this.metaItems.keySet().iterator();
        while (shortIterator.hasNext()) {
            short metaItem = (Short)shortIterator.next();
            Material material = this.getMaterial(metaItem);
            ItemStack item = new ItemStack((Item)this, 1, (int)metaItem);
            OreDictUnifier.registerOre(item, this.prefix, material);
            MetaPrefixItem.registerSpecialOreDict(item, material, this.prefix);
        }
    }

    private static void registerSpecialOreDict(ItemStack item, Material material, OrePrefix prefix) {
        if (prefix.getAlternativeOreName() != null) {
            OreDictUnifier.registerOre(item, prefix.getAlternativeOreName(), material);
        }
        if (material == Materials.Plutonium239) {
            OreDictUnifier.registerOre(item, prefix.name() + material.toCamelCaseString() + "239");
        } else if (material == Materials.Uranium238) {
            OreDictUnifier.registerOre(item, prefix.name() + material.toCamelCaseString() + "238");
        } else if (material == Materials.Saltpeter) {
            OreDictUnifier.registerOre(item, prefix.name() + material.toCamelCaseString());
        }
    }

    protected static boolean canGenerate(OrePrefix orePrefix, Material material) {
        return orePrefix.doGenerateItem(material);
    }

    @Override
    @NotNull
    public String func_77653_i(@NotNull ItemStack itemStack) {
        Material material = this.getMaterial(itemStack);
        if (material == null || this.prefix == null) {
            return "";
        }
        return this.prefix.getLocalNameForItem(material);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected int getColorForItemStack(@NotNull ItemStack stack, int tintIndex) {
        if (tintIndex == 0) {
            Material material = this.getMaterial(stack);
            if (material == null) {
                return 0xFFFFFF;
            }
            return material.getMaterialRGB();
        }
        return super.getColorForItemStack(stack, tintIndex);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        Short2ObjectOpenHashMap alreadyRegistered = new Short2ObjectOpenHashMap();
        ShortIterator shortIterator = this.metaItems.keySet().iterator();
        while (shortIterator.hasNext()) {
            ModelResourceLocation resourceLocation;
            short metaItem = (Short)shortIterator.next();
            MaterialIconSet materialIconSet = this.getMaterial(metaItem).getMaterialIconSet();
            short registrationKey = (short)(this.prefix.id + materialIconSet.id);
            if (!alreadyRegistered.containsKey(registrationKey)) {
                resourceLocation = Objects.requireNonNull(this.prefix.materialIconType).getItemModelPath(materialIconSet);
                ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{resourceLocation});
                alreadyRegistered.put(registrationKey, new ModelResourceLocation((ResourceLocation)resourceLocation, "inventory"));
            }
            resourceLocation = (ModelResourceLocation)alreadyRegistered.get(registrationKey);
            this.metaItemsModels.put(metaItem, (Object)resourceLocation);
        }
        if (this.metaItems.keySet().isEmpty()) {
            MaterialIconSet defaultIcon = MaterialIconSet.DULL;
            ResourceLocation defaultLocation = Objects.requireNonNull(OrePrefix.ingot.materialIconType).getItemModelPath(defaultIcon);
            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{defaultLocation});
        }
    }

    @Override
    public int getItemStackLimit(@NotNull ItemStack stack) {
        if (this.prefix == null) {
            return 64;
        }
        return this.prefix.maxStackSize;
    }

    @Override
    public void func_77663_a(@NotNull ItemStack itemStack, @NotNull World worldIn, @NotNull Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(itemStack, worldIn, entityIn, itemSlot, isSelected);
        if (this.metaItems.containsKey((short)itemStack.func_77952_i()) && entityIn instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)entityIn;
            if (entityIn.field_70173_aa % 20 == 0) {
                ArmorMetaItem.ArmorMetaValueItem metaValueItem;
                if (this.prefix.heatDamageFunction == null) {
                    return;
                }
                Material material = this.getMaterial(itemStack);
                if (material == null || !material.hasProperty(PropertyKey.BLAST)) {
                    return;
                }
                float heatDamage = this.prefix.heatDamageFunction.apply(material.getBlastTemperature()).floatValue();
                ItemStack armor = entity.func_184582_a(EntityEquipmentSlot.CHEST);
                if (!armor.func_190926_b() && armor.func_77973_b() instanceof ArmorMetaItem && (metaValueItem = (ArmorMetaItem.ArmorMetaValueItem)((ArmorMetaItem)armor.func_77973_b()).getItem(armor)) != null) {
                    heatDamage *= metaValueItem.getArmorLogic().getHeatResistance();
                }
                if ((double)heatDamage > 0.0) {
                    entity.func_70097_a(DamageSources.getHeatDamage().func_76348_h(), heatDamage);
                } else if ((double)heatDamage < 0.0) {
                    entity.func_70097_a(DamageSources.getFrostDamage().func_76348_h(), -heatDamage);
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@NotNull ItemStack itemStack, @Nullable World worldIn, @NotNull List<String> lines, @NotNull ITooltipFlag tooltipFlag) {
        super.func_77624_a(itemStack, worldIn, lines, tooltipFlag);
        Material material = this.getMaterial(itemStack);
        if (this.prefix == null || material == null) {
            return;
        }
        this.addMaterialTooltip(lines, itemStack);
    }

    @Nullable
    public Material getMaterial(@NotNull ItemStack stack) {
        return (Material)this.registry.func_148754_a(stack.func_77960_j());
    }

    @NotNull
    protected Material getMaterial(int metadata) {
        return Objects.requireNonNull((Material)this.registry.func_148754_a(metadata));
    }

    @Nullable
    public static Material tryGetMaterial(@NotNull ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (item instanceof MetaPrefixItem) {
            MetaPrefixItem metaPrefixItem = (MetaPrefixItem)item;
            return metaPrefixItem.getMaterial(itemStack);
        }
        return null;
    }

    public OrePrefix getOrePrefix() {
        return this.prefix;
    }

    @Override
    public int getItemBurnTime(@NotNull ItemStack itemStack) {
        DustProperty property;
        Material material = this.getMaterial(itemStack);
        DustProperty dustProperty = property = material == null ? null : material.getProperty(PropertyKey.DUST);
        if (property != null) {
            return (int)((long)property.getBurnTime() * this.prefix.getMaterialAmount(material) / 3628800L);
        }
        return super.getItemBurnTime(itemStack);
    }

    public boolean isBeaconPayment(@NotNull ItemStack stack) {
        Material material = this.getMaterial(stack);
        if (material != null && this.prefix != OrePrefix.ingot && this.prefix != OrePrefix.gem) {
            ToolProperty property = material.getProperty(PropertyKey.TOOL);
            return property != null && property.getToolHarvestLevel() >= 2;
        }
        return false;
    }

    public boolean onEntityItemUpdate(EntityItem itemEntity) {
        if (itemEntity.func_130014_f_().field_72995_K) {
            return false;
        }
        Material material = this.getMaterial(itemEntity.func_92059_d());
        if (!purifyMap.containsKey(this.prefix)) {
            return false;
        }
        BlockPos blockPos = new BlockPos((Entity)itemEntity);
        IBlockState blockState = itemEntity.func_130014_f_().func_180495_p(blockPos);
        if (!(blockState.func_177230_c() instanceof BlockCauldron)) {
            return false;
        }
        int waterLevel = (Integer)blockState.func_177229_b((IProperty)BlockCauldron.field_176591_a);
        if (waterLevel == 0) {
            return false;
        }
        itemEntity.func_130014_f_().func_175656_a(blockPos, blockState.func_177226_a((IProperty)BlockCauldron.field_176591_a, (Comparable)Integer.valueOf(waterLevel - 1)));
        ItemStack replacementStack = OreDictUnifier.get(purifyMap.get(this.prefix), material, itemEntity.func_92059_d().func_190916_E());
        itemEntity.func_92058_a(replacementStack);
        return false;
    }

    protected void addMaterialTooltip(@NotNull List<String> lines, @NotNull ItemStack itemStack) {
        if (this.prefix.tooltipFunc != null) {
            lines.addAll((Collection<String>)this.prefix.tooltipFunc.apply(this.getMaterial(itemStack)));
        }
    }

    static {
        purifyMap.put(OrePrefix.crushed, OrePrefix.crushedPurified);
        purifyMap.put(OrePrefix.dustImpure, OrePrefix.dust);
        purifyMap.put(OrePrefix.dustPure, OrePrefix.dust);
    }
}

