/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.behavior;

import gregtech.api.items.behavior.MonitorPluginBaseBehavior;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;

public abstract class ProxyHolderPluginBehavior
extends MonitorPluginBaseBehavior {
    protected IGregTechTileEntity holder;
    private BlockPos pos;

    @Override
    public void update() {
        if (this.pos != null && this.holder == null) {
            this.holder = this.screen.getHolderFromPos(this.pos);
            if (this.holder != null) {
                this.onHolderChanged(null);
            }
        }
    }

    @Override
    public void addInformation(ItemStack itemStack, List<String> lines) {
        super.addInformation(itemStack, lines);
        lines.add(I18n.func_135052_a((String)"metaitem.plugin.proxy.tooltips.1", (Object[])new Object[0]));
    }

    public void onHolderPosUpdated(BlockPos pos) {
        if (Objects.equals(this.pos, pos)) {
            return;
        }
        this.pos = pos;
        IGregTechTileEntity lastHolder = this.holder;
        this.holder = this.screen.getHolderFromPos(pos);
        if (!Objects.equals(lastHolder, this.holder)) {
            this.onHolderChanged(lastHolder);
        }
    }

    protected abstract void onHolderChanged(IGregTechTileEntity var1);

    public IGregTechTileEntity getHolder() {
        return this.holder;
    }
}

