/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.SizedTextureArea;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.util.LocalizationUtils;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.api.util.function.BooleanConsumer;
import java.util.Arrays;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ImageCycleButtonWidget
extends Widget {
    protected TextureArea buttonTexture;
    private final IntSupplier currentOptionSupplier;
    private final IntConsumer setOptionExecutor;
    private final int optionCount;
    private static final int RIGHT_MOUSE = 1;
    protected int currentOption;
    protected Function<Integer, String> tooltipHoverString;
    protected boolean shouldUseBaseBackground = false;
    protected boolean singleTexture = false;

    public ImageCycleButtonWidget(int xPosition, int yPosition, int width, int height, TextureArea buttonTexture, int optionCount, IntSupplier currentOptionSupplier, IntConsumer setOptionExecutor) {
        super(new Position(xPosition, yPosition), new Size(width, height));
        this.buttonTexture = buttonTexture;
        this.currentOptionSupplier = currentOptionSupplier;
        this.setOptionExecutor = setOptionExecutor;
        this.optionCount = optionCount;
        this.currentOption = currentOptionSupplier.getAsInt();
    }

    public ImageCycleButtonWidget(int xPosition, int yPosition, int width, int height, TextureArea buttonTexture, BooleanSupplier supplier, BooleanConsumer updater) {
        super(new Position(xPosition, yPosition), new Size(width, height));
        this.buttonTexture = buttonTexture;
        this.currentOptionSupplier = () -> supplier.getAsBoolean() ? 1 : 0;
        this.setOptionExecutor = value -> updater.apply(value >= 1);
        this.optionCount = 2;
        this.currentOption = this.currentOptionSupplier.getAsInt();
    }

    public ImageCycleButtonWidget setTooltipHoverString(String hoverString) {
        this.tooltipHoverString = val -> hoverString;
        return this;
    }

    public ImageCycleButtonWidget setTooltipHoverString(Function<Integer, String> hoverString) {
        this.tooltipHoverString = hoverString;
        return this;
    }

    public ImageCycleButtonWidget setButtonTexture(TextureArea texture) {
        this.buttonTexture = texture;
        return this;
    }

    public ImageCycleButtonWidget shouldUseBaseBackground() {
        this.shouldUseBaseBackground = true;
        return this;
    }

    public ImageCycleButtonWidget singleTexture() {
        this.singleTexture = true;
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        Position pos = this.getPosition();
        Size size = this.getSize();
        if (this.shouldUseBaseBackground) {
            GuiTextures.TOGGLE_BUTTON_BACK.drawSubArea(pos.x, pos.y, size.width, size.height, 0.0, 0.0, 1.0, 0.5);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (this.singleTexture) {
            this.buttonTexture.draw(pos.x, pos.y, size.width, size.height);
        } else if (this.buttonTexture instanceof SizedTextureArea) {
            ((SizedTextureArea)this.buttonTexture).drawHorizontalCutSubArea(pos.x, pos.y, size.width, size.height, (float)this.currentOption / (float)this.optionCount, 1.0f / (float)this.optionCount);
        } else {
            this.buttonTexture.drawSubArea(pos.x, pos.y, size.width, size.height, 0.0, (float)this.currentOption / (float)this.optionCount, 1.0, 1.0f / (float)this.optionCount);
        }
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        if (this.isMouseOverElement(mouseX, mouseY) && this.tooltipHoverString != null) {
            List<String> hoverList = Arrays.asList(LocalizationUtils.formatLines(this.tooltipHoverString.apply(this.currentOption), new Object[0]));
            this.drawHoveringText(ItemStack.field_190927_a, hoverList, 300, mouseX, mouseY);
        }
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (this.currentOptionSupplier.getAsInt() != this.currentOption) {
            this.currentOption = this.currentOptionSupplier.getAsInt();
            this.writeUpdateInfo(1, buf -> buf.func_150787_b(this.currentOption));
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        super.readUpdateInfo(id, buffer);
        if (id == 1) {
            this.currentOption = buffer.func_150792_a();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        super.mouseClicked(mouseX, mouseY, button);
        if (this.isMouseOverElement(mouseX, mouseY)) {
            this.currentOption = button == 1 ? (this.currentOption == 0 ? this.optionCount - 1 : this.currentOption - 1) : (this.currentOption + 1) % this.optionCount;
            this.setOptionExecutor.accept(this.currentOption);
            this.writeClientAction(1, buf -> buf.func_150787_b(this.currentOption));
            ImageCycleButtonWidget.playButtonClickSound();
            return true;
        }
        return false;
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        super.handleClientAction(id, buffer);
        if (id == 1) {
            this.currentOption = MathHelper.func_76125_a((int)buffer.func_150792_a(), (int)0, (int)this.optionCount);
            this.setOptionExecutor.accept(this.currentOption);
        }
    }
}

