/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.resources;

import codechicken.lib.render.shader.ShaderObject;
import codechicken.lib.render.shader.ShaderProgram;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.client.shader.Shaders;
import gregtech.common.ConfigHolder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ShaderTexture
implements IGuiTexture {
    @SideOnly(value=Side.CLIENT)
    private static final Map<String, ShaderTexture> PROGRAMS = new HashMap<String, ShaderTexture>();
    @SideOnly(value=Side.CLIENT)
    private ShaderProgram program;
    @SideOnly(value=Side.CLIENT)
    private ShaderObject object;
    private float resolution;

    public static void clear() {
        PROGRAMS.values().forEach(ShaderTexture::dispose);
        PROGRAMS.clear();
    }

    private ShaderTexture() {
        this.resolution = (float)ConfigHolder.client.resolution;
    }

    public void dispose() {
        if (this.object != null) {
            this.object.disposeObject();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateRawShader(String rawShader) {
        this.dispose();
        this.object = new ShaderObject(ShaderObject.ShaderType.FRAGMENT, rawShader).compileShader();
        this.program = new ShaderProgram();
        this.program.attachShader(this.object);
    }

    @SideOnly(value=Side.CLIENT)
    private ShaderTexture(ShaderProgram program, ShaderObject object) {
        this.resolution = (float)ConfigHolder.client.resolution;
        this.program = program;
        this.object = object;
    }

    public static ShaderTexture createShader(String location) {
        if (FMLCommonHandler.instance().getSide().isClient() && Shaders.allowedShader()) {
            if (!PROGRAMS.containsKey(location)) {
                ShaderObject object = Shaders.loadShader(ShaderObject.ShaderType.FRAGMENT, location);
                if (object != null) {
                    ShaderProgram program = new ShaderProgram();
                    program.attachShader(object);
                    PROGRAMS.put(location, new ShaderTexture(program, object));
                } else {
                    return new ShaderTexture();
                }
            }
            return PROGRAMS.get(location);
        }
        return new ShaderTexture();
    }

    public static ShaderTexture createRawShader(String rawShader) {
        if (FMLCommonHandler.instance().getSide().isClient() && Shaders.allowedShader()) {
            ShaderProgram program = new ShaderProgram();
            ShaderObject object = new ShaderObject(ShaderObject.ShaderType.FRAGMENT, rawShader).compileShader();
            program.attachShader(object);
            return new ShaderTexture(program, object);
        }
        return new ShaderTexture();
    }

    public ShaderTexture setResolution(float resolution) {
        this.resolution = resolution;
        return this;
    }

    public float getResolution() {
        return this.resolution;
    }

    @Override
    public void draw(double x, double y, int width, int height) {
        this.draw(x, y, width, height, null);
    }

    public void draw(double x, double y, int width, int height, Consumer<ShaderProgram.UniformCache> uniformCache) {
        if (this.program != null) {
            this.program.useShader(cache -> {
                cache.glUniform2F("u_resolution", (float)width * this.resolution, (float)height * this.resolution);
                if (uniformCache != null) {
                    uniformCache.accept(cache);
                }
            });
            Widget.drawTextureRect(x, y, width, height);
            this.program.releaseShader();
        }
    }
}

