/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.resources;

import gregtech.api.util.GTUtility;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public final class ResourceHelper {
    public static final String RESOURCE_PREFIX = "gregtech:";
    private static final Map<String, ResourceLocation> cachedResources = new HashMap<String, ResourceLocation>();
    private static final String DIR_FORMAT = "textures/%s.png";

    private ResourceHelper() {
    }

    public static void bindTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }

    public static ResourceLocation getResource(String rs) {
        if (!cachedResources.containsKey(rs)) {
            cachedResources.put(rs, new ResourceLocation(RESOURCE_PREFIX + rs));
        }
        return cachedResources.get(rs);
    }

    public static ResourceLocation getResourceRAW(String rs) {
        if (!cachedResources.containsKey(rs)) {
            cachedResources.put(rs, new ResourceLocation(rs));
        }
        return cachedResources.get(rs);
    }

    public static void bindTexture(String rs) {
        ResourceHelper.bindTexture(ResourceHelper.getResource(rs));
    }

    public static boolean isResourceExist(String rs) {
        if (!cachedResources.containsKey(rs)) {
            URL url = ResourceHelper.class.getResource(String.format("/assets/%s/%s", "gregtech", rs));
            if (url == null) {
                return false;
            }
            cachedResources.put(rs, GTUtility.gregtechId(rs));
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean doResourcepacksHaveTexture(@NotNull String modid, @NotNull String textureResource, boolean format) {
        if (format) {
            textureResource = String.format(DIR_FORMAT, textureResource);
        }
        return ResourceHelper.doResourcepacksHaveResource(modid, textureResource);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean doResourcepacksHaveResource(@NotNull String modid, @NotNull String resource) {
        return ResourceHelper.doResourcepacksHaveResource(new ResourceLocation(modid, resource));
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean doResourcepacksHaveResource(@NotNull ResourceLocation resource) {
        IResourceManager manager = Minecraft.func_71410_x().func_110442_L();
        try {
            IResource ignored = manager.func_110536_a(resource);
            IOUtils.closeQuietly((Closeable)ignored);
            return true;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static boolean isTextureExist(@NotNull String modid, @NotNull String textureResource) {
        URL url = ResourceHelper.class.getResource(String.format("/assets/%s/textures/%s.png", modid, textureResource));
        return url != null;
    }

    public static boolean isTextureExist(@NotNull ResourceLocation textureResource) {
        return ResourceHelper.isTextureExist(textureResource.func_110624_b(), textureResource.func_110623_a());
    }
}

