/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.cover;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.CoverableView;
import gregtech.client.utils.BloomEffectUtil;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.jetbrains.annotations.Unmodifiable;

public interface Cover {
    @NotNull
    public CoverableView getCoverableView();

    @NotNull
    public CoverDefinition getDefinition();

    default public @UnknownNullability World getWorld() {
        return this.getCoverableView().getWorld();
    }

    default public @UnknownNullability BlockPos getPos() {
        return this.getCoverableView().getPos();
    }

    @Nullable
    default public TileEntity getTileEntityHere() {
        CoverableView view = this.getCoverableView();
        return view.getWorld().func_175625_s(view.getPos());
    }

    @Nullable
    default public TileEntity getNeighbor(@NotNull EnumFacing facing) {
        CoverableView view = this.getCoverableView();
        return view.getNeighbor(facing);
    }

    default public void markDirty() {
        this.getCoverableView().markDirty();
    }

    default public void notifyBlockUpdate() {
        this.getCoverableView().notifyBlockUpdate();
    }

    default public void scheduleRenderUpdate() {
        this.getCoverableView().scheduleRenderUpdate();
    }

    default public long getOffsetTimer() {
        return this.getCoverableView().getOffsetTimer();
    }

    @NotNull
    public EnumFacing getAttachedSide();

    public boolean canAttach(@NotNull CoverableView var1, @NotNull EnumFacing var2);

    default public void onAttachment(@NotNull CoverableView coverableView, @NotNull EnumFacing side, @Nullable EntityPlayer player, @NotNull ItemStack itemStack) {
    }

    default public void onRemoval() {
    }

    default public boolean canInteractWithOutputSide() {
        return false;
    }

    default public boolean shouldAutoConnectToPipes() {
        return true;
    }

    default public boolean canPipePassThrough() {
        return false;
    }

    default public boolean onLeftClick(@NotNull EntityPlayer player, @NotNull CuboidRayTraceResult hitResult) {
        return false;
    }

    @NotNull
    default public EnumActionResult onRightClick(@NotNull EntityPlayer player, @NotNull EnumHand hand, @NotNull CuboidRayTraceResult hitResult) {
        return EnumActionResult.PASS;
    }

    @NotNull
    default public EnumActionResult onScrewdriverClick(@NotNull EntityPlayer player, @NotNull EnumHand hand, @NotNull CuboidRayTraceResult hitResult) {
        return EnumActionResult.PASS;
    }

    @NotNull
    default public EnumActionResult onSoftMalletClick(@NotNull EntityPlayer player, @NotNull EnumHand hand, @NotNull CuboidRayTraceResult hitResult) {
        return EnumActionResult.PASS;
    }

    @NotNull
    default public @NotNull @Unmodifiable List<@NotNull ItemStack> getDrops() {
        return Collections.singletonList(this.getPickItem());
    }

    @NotNull
    default public ItemStack getPickItem() {
        return this.getDefinition().getDropItemStack();
    }

    default public boolean canConnectRedstone() {
        return false;
    }

    default public void onRedstoneInputSignalChange(int redstone) {
    }

    default public int getRedstoneSignalOutput() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderCover(@NotNull CCRenderState var1, @NotNull Matrix4 var2, @NotNull IVertexOperation[] var3, @NotNull Cuboid6 var4, @NotNull BlockRenderLayer var5);

    @SideOnly(value=Side.CLIENT)
    default public boolean canRenderInLayer(@NotNull BlockRenderLayer renderLayer) {
        return renderLayer == BlockRenderLayer.CUTOUT_MIPPED || renderLayer == BloomEffectUtil.getEffectiveBloomLayer();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderCoverPlate(@NotNull CCRenderState var1, @NotNull Matrix4 var2, @NotNull IVertexOperation[] var3, @NotNull Cuboid6 var4, @NotNull BlockRenderLayer var5);

    default public boolean canRenderBackside() {
        return true;
    }

    @Nullable
    default public <T> T getCapability(@NotNull Capability<T> capability, @Nullable T defaultValue) {
        return defaultValue;
    }

    default public void writeToNBT(@NotNull NBTTagCompound nbt) {
    }

    default public void readFromNBT(@NotNull NBTTagCompound nbt) {
    }

    default public void writeInitialSyncData(@NotNull PacketBuffer packetBuffer) {
    }

    default public void readInitialSyncData(@NotNull PacketBuffer packetBuffer) {
    }

    default public void writeCustomData(int discriminator, @NotNull @NotNull Consumer<@NotNull PacketBuffer> buf) {
        this.getCoverableView().writeCoverData(this, discriminator, buf);
    }

    default public void readCustomData(int discriminator, @NotNull PacketBuffer buf) {
    }
}

