/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class ItemHandlerList
implements IItemHandlerModifiable {
    private final Int2ObjectMap<IItemHandler> handlerBySlotIndex = new Int2ObjectOpenHashMap();
    private final Map<IItemHandler, Integer> baseIndexOffset = new IdentityHashMap<IItemHandler, Integer>();

    public ItemHandlerList(List<? extends IItemHandler> itemHandlerList) {
        int currentSlotIndex = 0;
        for (IItemHandler iItemHandler : itemHandlerList) {
            if (this.baseIndexOffset.containsKey(iItemHandler)) {
                throw new IllegalArgumentException("Attempted to add item handler " + iItemHandler + " twice");
            }
            this.baseIndexOffset.put(iItemHandler, currentSlotIndex);
            int slotsCount = iItemHandler.getSlots();
            for (int slotIndex = 0; slotIndex < slotsCount; ++slotIndex) {
                this.handlerBySlotIndex.put(currentSlotIndex + slotIndex, (Object)iItemHandler);
            }
            currentSlotIndex += slotsCount;
        }
    }

    public int getSlots() {
        return this.handlerBySlotIndex.size();
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        IItemHandler itemHandler = (IItemHandler)this.handlerBySlotIndex.get(slot);
        if (!(itemHandler instanceof IItemHandlerModifiable)) {
            throw new UnsupportedOperationException("Handler " + itemHandler + " does not support this method");
        }
        ((IItemHandlerModifiable)itemHandler).setStackInSlot(slot - this.baseIndexOffset.get(itemHandler), stack);
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        IItemHandler itemHandler = (IItemHandler)this.handlerBySlotIndex.get(slot);
        int realSlot = slot - this.baseIndexOffset.get(itemHandler);
        return itemHandler.getStackInSlot(slot - this.baseIndexOffset.get(itemHandler));
    }

    public int getSlotLimit(int slot) {
        IItemHandler itemHandler = (IItemHandler)this.handlerBySlotIndex.get(slot);
        return itemHandler.getSlotLimit(slot - this.baseIndexOffset.get(itemHandler));
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        IItemHandler itemHandler = (IItemHandler)this.handlerBySlotIndex.get(slot);
        return itemHandler.insertItem(slot - this.baseIndexOffset.get(itemHandler), stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        IItemHandler itemHandler = (IItemHandler)this.handlerBySlotIndex.get(slot);
        return itemHandler.extractItem(slot - this.baseIndexOffset.get(itemHandler), amount, simulate);
    }

    @NotNull
    public Collection<IItemHandler> getBackingHandlers() {
        return Collections.unmodifiableCollection(this.handlerBySlotIndex.values());
    }
}

