/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api;

import gregtech.api.advancement.IAdvancementManager;
import gregtech.api.block.IHeatingCoilBlockStats;
import gregtech.api.block.machines.BlockMachine;
import gregtech.api.command.ICommandManager;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.event.HighTierEvent;
import gregtech.api.gui.UIFactory;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.multiblock.IBatteryData;
import gregtech.api.modules.IModuleManager;
import gregtech.api.network.INetworkHandler;
import gregtech.api.sound.ISoundManager;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.registry.IMaterialRegistryManager;
import gregtech.api.unification.material.registry.MarkerMaterialRegistry;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.ore.StoneType;
import gregtech.api.util.BaseCreativeTab;
import gregtech.api.util.GTControlledRegistry;
import gregtech.api.util.GTLog;
import gregtech.api.util.IBlockOre;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockWarningSign;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.items.MetaItems;
import gregtech.common.items.ToolItems;
import gregtech.common.metatileentities.MetaTileEntities;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.GenericEvent;

public class GregTechAPI {
    public static Object instance;
    public static IModuleManager moduleManager;
    public static INetworkHandler networkHandler;
    public static ICommandManager commandManager;
    public static IAdvancementManager advancementManager;
    public static ISoundManager soundManager;
    public static IMaterialRegistryManager materialManager;
    public static MarkerMaterialRegistry markerMaterialRegistry;
    private static boolean highTier;
    private static boolean highTierInitialized;
    public static final GTControlledRegistry<ResourceLocation, MetaTileEntity> MTE_REGISTRY;
    public static final GTControlledRegistry<ResourceLocation, UIFactory> UI_FACTORY_REGISTRY;
    public static final GTControlledRegistry<ResourceLocation, CoverDefinition> COVER_REGISTRY;
    public static BlockMachine MACHINE;
    public static final Map<Material, Map<StoneType, IBlockOre>> oreBlockTable;
    public static final Object2ObjectMap<IBlockState, IHeatingCoilBlockStats> HEATING_COILS;
    public static final Object2ObjectMap<IBlockState, IBatteryData> PSS_BATTERIES;
    public static final BaseCreativeTab TAB_GREGTECH;
    public static final BaseCreativeTab TAB_GREGTECH_MACHINES;
    public static final BaseCreativeTab TAB_GREGTECH_CABLES;
    public static final BaseCreativeTab TAB_GREGTECH_PIPES;
    public static final BaseCreativeTab TAB_GREGTECH_TOOLS;
    public static final BaseCreativeTab TAB_GREGTECH_MATERIALS;
    public static final BaseCreativeTab TAB_GREGTECH_ORES;
    public static final BaseCreativeTab TAB_GREGTECH_DECORATIONS;

    public static boolean isHighTier() {
        return highTier;
    }

    static void initializeHighTier() {
        if (highTierInitialized) {
            throw new IllegalStateException("High-Tier is already initialized.");
        }
        HighTierEvent highTierEvent = new HighTierEvent();
        MinecraftForge.EVENT_BUS.post((Event)highTierEvent);
        highTier = ConfigHolder.machines.highTierContent || highTierEvent.isHighTier();
        highTierInitialized = true;
        if (GregTechAPI.isHighTier()) {
            GTLog.logger.info("High-Tier is Enabled.");
        } else {
            GTLog.logger.info("High-Tier is Disabled.");
        }
    }

    static {
        MTE_REGISTRY = new GTControlledRegistry(Short.MAX_VALUE);
        UI_FACTORY_REGISTRY = new GTControlledRegistry(Short.MAX_VALUE);
        COVER_REGISTRY = new GTControlledRegistry(Integer.MAX_VALUE);
        oreBlockTable = new HashMap<Material, Map<StoneType, IBlockOre>>();
        HEATING_COILS = new Object2ObjectOpenHashMap();
        PSS_BATTERIES = new Object2ObjectOpenHashMap();
        TAB_GREGTECH = new BaseCreativeTab("gregtech.main", () -> MetaItems.LOGO.getStackForm(), true);
        TAB_GREGTECH_MACHINES = new BaseCreativeTab("gregtech.machines", () -> MetaTileEntities.ELECTRIC_BLAST_FURNACE.getStackForm(), true);
        TAB_GREGTECH_CABLES = new BaseCreativeTab("gregtech.cables", () -> OreDictUnifier.get(OrePrefix.cableGtDouble, Materials.Aluminium), true);
        TAB_GREGTECH_PIPES = new BaseCreativeTab("gregtech.pipes", () -> OreDictUnifier.get(OrePrefix.pipeNormalFluid, Materials.Aluminium), true);
        TAB_GREGTECH_TOOLS = new BaseCreativeTab("gregtech.tools", () -> ToolItems.HARD_HAMMER.get(Materials.Aluminium), true);
        TAB_GREGTECH_MATERIALS = new BaseCreativeTab("gregtech.materials", () -> OreDictUnifier.get(OrePrefix.ingot, Materials.Aluminium), true);
        TAB_GREGTECH_ORES = new BaseCreativeTab("gregtech.ores", () -> OreDictUnifier.get(OrePrefix.ore, Materials.Aluminium), true);
        TAB_GREGTECH_DECORATIONS = new BaseCreativeTab("gregtech.decorations", () -> MetaBlocks.WARNING_SIGN.getItemVariant(BlockWarningSign.SignType.YELLOW_STRIPES), true);
    }

    public static class RegisterEvent<V>
    extends GenericEvent<V> {
        private final GTControlledRegistry<ResourceLocation, V> registry;

        public RegisterEvent(GTControlledRegistry<ResourceLocation, V> registry, Class<V> clazz) {
            super(clazz);
            this.registry = registry;
        }

        public void register(int id, ResourceLocation key, V value) {
            if (this.registry != null) {
                this.registry.func_177775_a(id, key, value);
            }
        }

        public void register(int id, String key, V value) {
            if (this.registry != null) {
                this.registry.func_177775_a(id, new ResourceLocation(Loader.instance().activeModContainer().getModId(), key), value);
            }
        }
    }
}

