/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.toolbelt.belt;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import gigaherz.toolbelt.ToolBelt;
import gigaherz.toolbelt.belt.ToolBeltInventory;
import gigaherz.toolbelt.customslots.ExtensionSlotItemHandler;
import gigaherz.toolbelt.customslots.IExtensionContainer;
import gigaherz.toolbelt.customslots.IExtensionSlot;
import gigaherz.toolbelt.customslots.IExtensionSlotItem;
import gigaherz.toolbelt.customslots.example.RpgEquipment;
import gigaherz.toolbelt.shadow.commons.ItemRegistered;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.IItemHandler;

@Optional.Interface(modid="baubles", iface="baubles.api.IBauble")
public class ItemToolBelt
extends ItemRegistered
implements IBauble,
IExtensionSlotItem {
    @CapabilityInject(value=IItemHandler.class)
    public static Capability<IItemHandler> ITEM_HANDLER;
    @CapabilityInject(value=IExtensionSlotItem.class)
    public static Capability<IExtensionSlotItem> EXTENSION_SLOT_ITEM;
    public static final ImmutableSet<ResourceLocation> BELT_SLOT_LIST;
    public static int[] xpCost;

    public ItemToolBelt(String name) {
        super(name);
        this.field_77777_bU = 1;
        this.func_77637_a(CreativeTabs.field_78040_i);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand != EnumHand.MAIN_HAND) {
            return EnumActionResult.PASS;
        }
        player.openGui((Object)ToolBelt.instance, 0, worldIn, hand.ordinal(), 0, 0);
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (hand != EnumHand.MAIN_HAND) {
            return new ActionResult(EnumActionResult.PASS, (Object)playerIn.func_184586_b(hand));
        }
        playerIn.openGui((Object)ToolBelt.instance, 0, worldIn, hand.ordinal(), 0, 0);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(hand));
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, world, tooltip, advanced);
        int size = ItemToolBelt.getSlotsCount(stack);
        tooltip.add(I18n.func_135052_a((String)"text.toolbelt.tooltip", (Object[])new Object[]{size - 2, size}));
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack itemStack) {
        return BaubleType.BELT;
    }

    @Override
    @Nonnull
    public ImmutableSet<ResourceLocation> getAcceptableSlots(@Nonnull ItemStack stack) {
        return BELT_SLOT_LIST;
    }

    public boolean willAutoSync(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
        this.tickAllSlots(itemstack, player);
    }

    @Override
    public void onWornTick(ItemStack itemstack, IExtensionSlot slot) {
        this.tickAllSlots(itemstack, slot.getContainer().getOwner());
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof EntityLivingBase) {
            this.tickAllSlots(stack, (EntityLivingBase)entityIn);
        }
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, NBTTagCompound nbt) {
        return new ICapabilityProvider(){
            final ToolBeltInventory itemHandler;
            {
                this.itemHandler = new ToolBeltInventory(stack);
            }

            public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
                if (capability == ITEM_HANDLER) {
                    return true;
                }
                return capability == EXTENSION_SLOT_ITEM;
            }

            @Nullable
            public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
                if (capability == ITEM_HANDLER) {
                    return (T)this.itemHandler;
                }
                if (capability == EXTENSION_SLOT_ITEM) {
                    return (T)ItemToolBelt.this;
                }
                return null;
            }
        };
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack);
    }

    public static int getSlotsCount(ItemStack stack) {
        int size = 2;
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            size = MathHelper.func_76125_a((int)nbt.func_74762_e("Size"), (int)2, (int)9);
        }
        return size;
    }

    public static void setSlotsCount(ItemStack stack, int newSize) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            nbt.func_74782_a("Items", (NBTBase)new NBTTagList());
        }
        nbt.func_74768_a("Size", newSize);
        stack.func_77982_d(nbt);
    }

    public static int getUpgradeXP(ItemStack stack) {
        int slots = ItemToolBelt.getSlotsCount(stack);
        if (slots >= 9) {
            return -1;
        }
        if (slots < 2) {
            return 1;
        }
        return xpCost[slots - 2];
    }

    public static ItemStack upgrade(ItemStack stack) {
        int slots = ItemToolBelt.getSlotsCount(stack);
        if (slots >= 9) {
            return stack.func_77946_l();
        }
        stack = stack.func_77946_l();
        ItemToolBelt.setSlotsCount(stack, slots + 1);
        return stack;
    }

    public ItemStack of(int upgradeLevel) {
        if (upgradeLevel < 0 || upgradeLevel >= 9) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = new ItemStack((Item)this);
        ItemToolBelt.setSlotsCount(stack, upgradeLevel + 2);
        return stack;
    }

    private void tickAllSlots(ItemStack source, EntityLivingBase player) {
        BeltExtensionContainer container = new BeltExtensionContainer(source, player);
        for (IExtensionSlot slot : container.getSlots()) {
            ((ExtensionSlotItemHandler)slot).onWornTick();
        }
    }

    static {
        BELT_SLOT_LIST = ImmutableSet.of((Object)RpgEquipment.BELT);
        xpCost = new int[]{3, 5, 8, 12, 15, 20, 30};
    }

    public static class BeltExtensionContainer
    implements IExtensionContainer {
        private static final ResourceLocation SLOT_TYPE = new ResourceLocation("toolbelt", "pocket");
        private final ToolBeltInventory inventory;
        private final EntityLivingBase owner;
        private final ImmutableList<IExtensionSlot> slots;

        public BeltExtensionContainer(ItemStack source, EntityLivingBase owner) {
            this.inventory = (ToolBeltInventory)source.getCapability(ITEM_HANDLER, null);
            this.owner = owner;
            Object[] slots = new ExtensionSlotItemHandler[this.inventory.getSlots()];
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                slots[i] = new ExtensionSlotItemHandler(this, SLOT_TYPE, this.inventory, i){

                    @Override
                    public boolean canEquip(@Nonnull ItemStack stack) {
                        return inventory.canInsertItem(this.slot, stack);
                    }
                };
            }
            this.slots = ImmutableList.copyOf((Object[])slots);
        }

        @Override
        @Nonnull
        public EntityLivingBase getOwner() {
            return this.owner;
        }

        @Override
        @Nonnull
        public ImmutableList<IExtensionSlot> getSlots() {
            return this.slots;
        }

        @Override
        public void onContentsChanged(IExtensionSlot slot) {
        }
    }
}

