/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing.tasks;

import betterquesting.advancement.BqsAdvListener;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api2.cache.CapabilityProviderQuestCache;
import betterquesting.api2.cache.QuestCache;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.ParticipantInfo;
import betterquesting.core.BetterQuesting;
import betterquesting.questing.tasks.factory.FactoryTaskTrigger;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class TaskTrigger
implements ITask {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Set<UUID> completeUsers = new TreeSet<UUID>();
    private String triggerID = "minecraft:impossible";
    private String critJson = "{}";
    private BqsAdvListener listener = null;
    private boolean needsSetup = true;
    public String desc = "";

    public String getCriteriaJson() {
        return this.critJson;
    }

    public void setCriteriaJson(String json) {
        if (this.critJson.equals(json)) {
            return;
        }
        this.critJson = StringUtils.func_151246_b((String)json) ? "{}" : json;
        try {
            GSON.fromJson(json, JsonObject.class);
        }
        catch (Exception e) {
            BetterQuesting.logger.error("Unable to parse JSON for trigger task");
            this.critJson = "{}";
        }
        this.needsSetup = true;
    }

    public String getTriggerID() {
        return this.triggerID;
    }

    public void setTriggerID(String id) {
        if (this.triggerID.equals(id)) {
            return;
        }
        this.triggerID = id;
        this.needsSetup = true;
    }

    private void setupListener(DBEntry<IQuest> quest) {
        this.needsSetup = false;
        int tskID = quest.getValue().getTasks().getID(this);
        ICriterionTrigger trig = CriteriaTriggers.func_192119_a((ResourceLocation)new ResourceLocation(this.triggerID));
        if (trig == null) {
            return;
        }
        try {
            ICriterionInstance in = trig.func_192166_a((JsonObject)GSON.fromJson(this.critJson, JsonObject.class), null);
            this.listener = new BqsAdvListener<ICriterionInstance>(trig, in, quest.getID(), tskID);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BqsAdvListener<?> getListener() {
        return this.listener;
    }

    public boolean hasSetup() {
        return !this.needsSetup;
    }

    public void onCriteriaComplete(EntityPlayerMP player, BqsAdvListener advList, int questID) {
        if (advList != this.listener) {
            return;
        }
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        this.setComplete(playerID);
        QuestCache qc = (QuestCache)player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        if (qc != null) {
            qc.markQuestDirty(questID);
        }
    }

    public void checkSetup(@Nonnull EntityPlayer player, @Nonnull DBEntry<IQuest> quest) {
        if (!this.needsSetup) {
            return;
        }
        this.setupListener(quest);
    }

    @Override
    public String getUnlocalisedName() {
        return "bq_standard.task.trigger";
    }

    @Override
    public ResourceLocation getFactoryID() {
        return FactoryTaskTrigger.INSTANCE.getRegistryName();
    }

    @Override
    public void detect(ParticipantInfo pInfo, DBEntry<IQuest> quest) {
    }

    @Override
    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    @Override
    public void setComplete(UUID uuid) {
        this.completeUsers.add(uuid);
    }

    @Override
    public void resetUser(@Nullable UUID uuid) {
        if (uuid == null) {
            this.completeUsers.clear();
        } else {
            this.completeUsers.remove(uuid);
        }
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getTaskGui(IGuiRect rect, DBEntry<IQuest> quest) {
        return new PanelTextBox(rect, this.desc).setColor(PresetColor.TEXT_MAIN.getColor());
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen parent, DBEntry<IQuest> quest) {
        return null;
    }

    @Override
    public NBTTagCompound writeProgressToNBT(NBTTagCompound nbt, @Nullable List<UUID> users) {
        NBTTagList jArray = new NBTTagList();
        this.completeUsers.forEach(uuid -> {
            if (users == null || users.contains(uuid)) {
                jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
            }
        });
        nbt.func_74782_a("completeUsers", (NBTBase)jArray);
        return nbt;
    }

    @Override
    public void readProgressFromNBT(NBTTagCompound nbt, boolean merge) {
        if (!merge) {
            this.completeUsers.clear();
        }
        NBTTagList cList = nbt.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            try {
                this.completeUsers.add(UUID.fromString(cList.func_150307_f(i)));
                continue;
            }
            catch (Exception e) {
                BetterQuesting.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
    }

    @Override
    @Deprecated
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        return this.writeToNBT(nbt, false);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt, boolean reduce) {
        nbt.func_74778_a("description", this.desc);
        nbt.func_74778_a("trigger", this.triggerID);
        nbt.func_74778_a("conditions", this.critJson);
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.desc = nbt.func_74779_i("description");
        this.setTriggerID(nbt.func_74779_i("trigger"));
        this.setCriteriaJson(nbt.func_74779_i("conditions"));
    }

    @Override
    public List<String> getTextForSearch() {
        return Collections.singletonList(this.triggerID);
    }
}

