/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing.tasks;

import betterquesting.NBTUtil;
import betterquesting.api.questing.IQuest;
import betterquesting.api.utils.ItemComparison;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.ParticipantInfo;
import betterquesting.client.gui2.editors.tasks.GuiEditTaskMeeting;
import betterquesting.client.gui2.tasks.PanelTaskMeeting;
import betterquesting.core.BetterQuesting;
import betterquesting.questing.tasks.ITaskTickable;
import betterquesting.questing.tasks.factory.FactoryTaskMeeting;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class TaskMeeting
implements ITaskTickable {
    private static final String DEFAULT_ENTITY = "minecraft:villager";
    private static final int DEFAULT_RANGE = 4;
    private static final int DEFAULT_AMOUNT = 1;
    private static final boolean DEFAULT_IGNORE_NBT = true;
    private static final boolean DEFAULT_SUBTYPES = true;
    private final Set<UUID> completeUsers = new TreeSet<UUID>();
    public String idName = "minecraft:villager";
    public int range = 4;
    public int amount = 1;
    public boolean ignoreNBT = true;
    public boolean subtypes = true;
    public NBTTagCompound targetTags = new NBTTagCompound();

    @Override
    public ResourceLocation getFactoryID() {
        return FactoryTaskMeeting.INSTANCE.getRegistryName();
    }

    @Override
    public String getUnlocalisedName() {
        return "bq_standard.task.meeting";
    }

    @Override
    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    @Override
    public void setComplete(UUID uuid) {
        this.completeUsers.add(uuid);
    }

    @Override
    public void resetUser(@Nullable UUID uuid) {
        if (uuid == null) {
            this.completeUsers.clear();
        } else {
            this.completeUsers.remove(uuid);
        }
    }

    @Override
    public void tickTask(@Nonnull ParticipantInfo pInfo, DBEntry<IQuest> quest) {
        if (pInfo.PLAYER.field_70173_aa % 60 == 0) {
            this.detect(pInfo, quest);
        }
    }

    @Override
    public void detect(@Nonnull ParticipantInfo pInfo, DBEntry<IQuest> quest) {
        if (!pInfo.PLAYER.func_70089_S()) {
            return;
        }
        ResourceLocation targetID = new ResourceLocation(this.idName);
        Class target = EntityList.getClass((ResourceLocation)targetID);
        if (target == null) {
            return;
        }
        List list = pInfo.PLAYER.field_70170_p.func_72839_b((Entity)pInfo.PLAYER, pInfo.PLAYER.func_174813_aQ().func_72321_a((double)this.range, (double)this.range, (double)this.range));
        int n = 0;
        for (Entity entity : list) {
            Class<?> subject = entity.getClass();
            ResourceLocation subjectID = EntityList.func_191306_a(subject);
            if (subjectID == null || this.subtypes && !target.isAssignableFrom(subject) || !this.subtypes && !subjectID.equals((Object)targetID)) continue;
            if (!this.ignoreNBT) {
                NBTTagCompound subjectTags = new NBTTagCompound();
                entity.func_70039_c(subjectTags);
                if (!ItemComparison.CompareNBTTag((NBTBase)this.targetTags, (NBTBase)subjectTags, true)) continue;
            }
            if (++n < this.amount) continue;
            pInfo.ALL_UUIDS.forEach(uuid -> {
                if (!this.isComplete((UUID)uuid)) {
                    this.setComplete((UUID)uuid);
                }
            });
            pInfo.markDirtyParty(Collections.singletonList(quest.getID()));
            return;
        }
    }

    @Override
    @Deprecated
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        return this.writeToNBT(nbt, false);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound json, boolean reduce) {
        json.func_74778_a("target", this.idName);
        NBTUtil.setString(json, "target", this.idName, DEFAULT_ENTITY, reduce);
        NBTUtil.setInteger(json, "range", this.range, 4, reduce);
        NBTUtil.setInteger(json, "amount", this.amount, 1, reduce);
        NBTUtil.setBoolean(json, "subtypes", this.subtypes, true, reduce);
        NBTUtil.setBoolean(json, "ignoreNBT", this.ignoreNBT, true, reduce);
        NBTUtil.setTag(json, "targetNBT", (NBTBase)this.targetTags, reduce);
        return json;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.idName = NBTUtil.getString(nbt, "target", DEFAULT_ENTITY);
        this.range = NBTUtil.getInteger(nbt, "range", 4);
        this.amount = NBTUtil.getInteger(nbt, "amount", 1);
        this.subtypes = NBTUtil.getBoolean(nbt, "subtypes", true);
        this.ignoreNBT = NBTUtil.getBoolean(nbt, "ignoreNBT", true);
        this.targetTags = nbt.func_74775_l("targetNBT");
    }

    @Override
    public NBTTagCompound writeProgressToNBT(NBTTagCompound nbt, @Nullable List<UUID> users) {
        NBTTagList jArray = new NBTTagList();
        this.completeUsers.forEach(uuid -> {
            if (users == null || users.contains(uuid)) {
                jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
            }
        });
        nbt.func_74782_a("completeUsers", (NBTBase)jArray);
        return nbt;
    }

    @Override
    public void readProgressFromNBT(NBTTagCompound nbt, boolean merge) {
        if (!merge) {
            this.completeUsers.clear();
        }
        NBTTagList cList = nbt.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            try {
                this.completeUsers.add(UUID.fromString(cList.func_150307_f(i)));
                continue;
            }
            catch (Exception e) {
                BetterQuesting.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen parent, DBEntry<IQuest> quest) {
        return new GuiEditTaskMeeting(parent, quest, this);
    }

    @Override
    public IGuiPanel getTaskGui(IGuiRect rect, DBEntry<IQuest> quest) {
        return new PanelTaskMeeting(rect, this);
    }

    @Override
    public List<String> getTextForSearch() {
        return Collections.singletonList(this.idName);
    }
}

