/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing.tasks;

import betterquesting.NBTUtil;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.tasks.IFluidTask;
import betterquesting.api.questing.tasks.IItemTask;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.ParticipantInfo;
import betterquesting.client.gui2.tasks.PanelTaskFluid;
import betterquesting.core.BetterQuesting;
import betterquesting.questing.tasks.ITaskInventory;
import betterquesting.questing.tasks.factory.FactoryTaskFluid;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class TaskFluid
implements ITaskInventory,
IFluidTask,
IItemTask {
    private static final boolean DEFAULT_IGNORE_NBT = false;
    private static final boolean DEFAULT_CONSUME = false;
    private static final boolean DEFAULT_GROUP_DETECT = false;
    private static final boolean DEFAULT_AUTO_CONSUME = false;
    private final Set<UUID> completeUsers = new TreeSet<UUID>();
    public final NonNullList<FluidStack> requiredFluids = NonNullList.func_191196_a();
    public final TreeMap<UUID, int[]> userProgress = new TreeMap();
    public boolean ignoreNbt = false;
    public boolean consume = false;
    public boolean groupDetect = false;
    public boolean autoConsume = false;

    @Override
    public ResourceLocation getFactoryID() {
        return FactoryTaskFluid.INSTANCE.getRegistryName();
    }

    @Override
    public String getUnlocalisedName() {
        return "bq_standard.task.fluid";
    }

    @Override
    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    @Override
    public void setComplete(UUID uuid) {
        this.completeUsers.add(uuid);
    }

    @Override
    public void onInventoryChange(@Nonnull DBEntry<IQuest> quest, @Nonnull ParticipantInfo pInfo) {
        if (!this.consume || this.autoConsume) {
            this.detect(pInfo, quest);
        }
    }

    @Override
    public void detect(ParticipantInfo pInfo, DBEntry<IQuest> quest) {
        List<Object> invoList;
        if (this.isComplete(pInfo.UUID)) {
            return;
        }
        List<Tuple<UUID, int[]>> progress = this.getBulkProgress(this.consume ? Collections.singletonList(pInfo.UUID) : pInfo.ALL_UUIDS);
        boolean updated = false;
        if (!this.consume) {
            if (this.groupDetect) {
                progress.forEach(value -> Arrays.fill((int[])value.func_76340_b(), 0));
            } else {
                for (int i = 0; i < this.requiredFluids.size(); ++i) {
                    int r = ((FluidStack)this.requiredFluids.get((int)i)).amount;
                    for (Tuple<UUID, int[]> value2 : progress) {
                        int n = ((int[])value2.func_76340_b())[i];
                        if (n == 0 || n >= r) continue;
                        ((int[])value2.func_76340_b())[i] = 0;
                        updated = true;
                    }
                }
            }
        }
        if (this.consume) {
            invoList = Collections.singletonList(pInfo.PLAYER.field_71071_by);
        } else {
            invoList = new ArrayList();
            pInfo.ACTIVE_PLAYERS.forEach(p -> invoList.add(p.field_71071_by));
        }
        for (InventoryPlayer inventoryPlayer : invoList) {
            for (int i = 0; i < inventoryPlayer.func_70302_i_(); ++i) {
                IFluidHandlerItem handler;
                ItemStack stack = inventoryPlayer.func_70301_a(i);
                if (stack.func_190926_b() || (handler = FluidUtil.getFluidHandler((ItemStack)stack)) == null) continue;
                boolean hasDrained = false;
                for (int j = 0; j < this.requiredFluids.size(); ++j) {
                    FluidStack sample;
                    FluidStack rStack = (FluidStack)this.requiredFluids.get(j);
                    FluidStack drainOG = rStack.copy();
                    if (this.ignoreNbt) {
                        drainOG.tag = null;
                    }
                    if ((sample = handler.drain(drainOG, false)) == null || sample.amount <= 0) continue;
                    for (Tuple<UUID, int[]> value3 : progress) {
                        FluidStack fluid;
                        if (((int[])value3.func_76340_b())[j] >= rStack.amount) continue;
                        int remaining = rStack.amount - ((int[])value3.func_76340_b())[j];
                        FluidStack drain = rStack.copy();
                        drain.amount = remaining / stack.func_190916_E();
                        if (this.ignoreNbt) {
                            drain.tag = null;
                        }
                        if (drain.amount <= 0 || (fluid = handler.drain(drain, this.consume)) == null || fluid.amount <= 0) continue;
                        int[] nArray = (int[])value3.func_76340_b();
                        int n = j;
                        nArray[n] = nArray[n] + fluid.amount * stack.func_190916_E();
                        hasDrained = true;
                        updated = true;
                    }
                }
                if (!hasDrained || !this.consume) continue;
                inventoryPlayer.func_70299_a(i, handler.getContainer());
            }
        }
        if (updated) {
            this.setBulkProgress(progress);
        }
        this.checkAndComplete(pInfo, quest, updated);
    }

    private void checkAndComplete(ParticipantInfo pInfo, DBEntry<IQuest> quest, boolean resync) {
        List<Tuple<UUID, int[]>> progress = this.getBulkProgress(this.consume ? Collections.singletonList(pInfo.UUID) : pInfo.ALL_UUIDS);
        boolean updated = resync;
        block0: for (Tuple<UUID, int[]> value : progress) {
            for (int j = 0; j < this.requiredFluids.size(); ++j) {
                if (((int[])value.func_76340_b())[j] < ((FluidStack)this.requiredFluids.get((int)j)).amount) continue block0;
            }
            updated = true;
            if (this.consume) {
                this.setComplete((UUID)value.func_76341_a());
                continue;
            }
            progress.forEach(pair -> this.setComplete((UUID)pair.func_76341_a()));
            break;
        }
        if (updated) {
            if (this.consume) {
                pInfo.markDirty(Collections.singletonList(quest.getID()));
            } else {
                pInfo.markDirtyParty(Collections.singletonList(quest.getID()));
            }
        }
    }

    @Override
    @Deprecated
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        return this.writeToNBT(nbt, false);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt, boolean reduce) {
        NBTUtil.setBoolean(nbt, "ignoreNBT", this.ignoreNbt, false, reduce);
        NBTUtil.setBoolean(nbt, "consume", this.consume, false, reduce);
        NBTUtil.setBoolean(nbt, "groupDetect", this.groupDetect, false, reduce);
        NBTUtil.setBoolean(nbt, "autoConsume", this.autoConsume, false, reduce);
        NBTTagList itemArray = new NBTTagList();
        for (FluidStack stack : this.requiredFluids) {
            itemArray.func_74742_a((NBTBase)stack.writeToNBT(new NBTTagCompound()));
        }
        nbt.func_74782_a("requiredFluids", (NBTBase)itemArray);
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.ignoreNbt = NBTUtil.getBoolean(nbt, "ignoreNBT", false);
        this.consume = NBTUtil.getBoolean(nbt, "consume", false);
        this.groupDetect = NBTUtil.getBoolean(nbt, "groupDetect", false);
        this.autoConsume = NBTUtil.getBoolean(nbt, "autoConsume", false);
        this.requiredFluids.clear();
        NBTTagList fList = nbt.func_150295_c("requiredFluids", 10);
        for (int i = 0; i < fList.func_74745_c(); ++i) {
            this.requiredFluids.add((Object)JsonHelper.JsonToFluidStack(fList.func_150305_b(i)));
        }
    }

    @Override
    public void readProgressFromNBT(NBTTagCompound nbt, boolean merge) {
        if (!merge) {
            this.completeUsers.clear();
            this.userProgress.clear();
        }
        NBTTagList cList = nbt.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            try {
                this.completeUsers.add(UUID.fromString(cList.func_150307_f(i)));
                continue;
            }
            catch (Exception e) {
                BetterQuesting.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
        NBTTagList pList = nbt.func_150295_c("userProgress", 10);
        for (int n = 0; n < pList.func_74745_c(); ++n) {
            try {
                NBTTagCompound pTag = pList.func_150305_b(n);
                UUID uuid = UUID.fromString(pTag.func_74779_i("uuid"));
                int[] data = new int[this.requiredFluids.size()];
                NBTTagList dNbt = pTag.func_150295_c("data", 3);
                for (int i = 0; i < data.length && i < dNbt.func_74745_c(); ++i) {
                    data[i] = dNbt.func_186858_c(i);
                }
                this.userProgress.put(uuid, data);
                continue;
            }
            catch (Exception e) {
                BetterQuesting.logger.log(Level.ERROR, "Unable to load user progress for task", (Throwable)e);
            }
        }
    }

    @Override
    public NBTTagCompound writeProgressToNBT(NBTTagCompound nbt, @Nullable List<UUID> users) {
        NBTTagList jArray = new NBTTagList();
        NBTTagList progArray = new NBTTagList();
        if (users != null) {
            users.forEach(uuid -> {
                int[] data;
                if (this.completeUsers.contains(uuid)) {
                    jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
                }
                if ((data = this.userProgress.get(uuid)) != null) {
                    NBTTagCompound pJson = new NBTTagCompound();
                    pJson.func_74778_a("uuid", uuid.toString());
                    NBTTagList pArray = new NBTTagList();
                    for (int i : data) {
                        pArray.func_74742_a((NBTBase)new NBTTagInt(i));
                    }
                    pJson.func_74782_a("data", (NBTBase)pArray);
                    progArray.func_74742_a((NBTBase)pJson);
                }
            });
        } else {
            this.completeUsers.forEach(uuid -> jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString())));
            this.userProgress.forEach((uuid, data) -> {
                NBTTagCompound pJson = new NBTTagCompound();
                pJson.func_74778_a("uuid", uuid.toString());
                NBTTagList pArray = new NBTTagList();
                for (int i : data) {
                    pArray.func_74742_a((NBTBase)new NBTTagInt(i));
                }
                pJson.func_74782_a("data", (NBTBase)pArray);
                progArray.func_74742_a((NBTBase)pJson);
            });
        }
        nbt.func_74782_a("completeUsers", (NBTBase)jArray);
        nbt.func_74782_a("userProgress", (NBTBase)progArray);
        return nbt;
    }

    @Override
    public void resetUser(@Nullable UUID uuid) {
        if (uuid == null) {
            this.completeUsers.clear();
            this.userProgress.clear();
        } else {
            this.completeUsers.remove(uuid);
            this.userProgress.remove(uuid);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getTaskGui(IGuiRect rect, DBEntry<IQuest> quest) {
        return new PanelTaskFluid(rect, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen screen, DBEntry<IQuest> quest) {
        return null;
    }

    @Override
    public boolean canAcceptFluid(UUID owner, DBEntry<IQuest> quest, FluidStack fluid) {
        if (owner == null || fluid == null || fluid.getFluid() == null || !this.consume || this.isComplete(owner) || this.requiredFluids.size() <= 0) {
            return false;
        }
        int[] progress = this.getUsersProgress(owner);
        for (int j = 0; j < this.requiredFluids.size(); ++j) {
            FluidStack rStack = ((FluidStack)this.requiredFluids.get(j)).copy();
            if (this.ignoreNbt) {
                rStack.tag = null;
            }
            if (progress[j] >= rStack.amount || !rStack.equals((Object)fluid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canAcceptItem(UUID owner, DBEntry<IQuest> quest, ItemStack item) {
        if (owner == null || item == null || item.func_190926_b() || !this.consume || this.isComplete(owner) || this.requiredFluids.size() <= 0) {
            return false;
        }
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)item);
        if (handler == null) {
            return false;
        }
        for (IFluidTankProperties tank : handler.getTankProperties()) {
            if (!tank.canDrain()) continue;
            for (FluidStack rStack : this.requiredFluids) {
                if (!rStack.equals((Object)tank.getContents())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public FluidStack submitFluid(UUID owner, DBEntry<IQuest> quest, FluidStack fluid) {
        return this.submitFluidInternal(owner, quest, fluid, true);
    }

    private FluidStack submitFluidInternal(UUID owner, DBEntry<IQuest> quest, FluidStack fluid, boolean doFill) {
        if (owner == null || fluid == null || fluid.amount <= 0 || !this.consume || this.isComplete(owner) || this.requiredFluids.size() <= 0) {
            return fluid;
        }
        int[] progress = (int[])this.getUsersProgress(owner).clone();
        boolean updated = false;
        for (int j = 0; j < this.requiredFluids.size(); ++j) {
            FluidStack rStack = (FluidStack)this.requiredFluids.get(j);
            if (progress[j] >= rStack.amount) continue;
            int remaining = rStack.amount - progress[j];
            if (!rStack.isFluidEqual(fluid)) continue;
            int removed = Math.min(fluid.amount, remaining);
            int n = j;
            progress[n] = progress[n] + removed;
            fluid.amount -= removed;
            updated = true;
            if (fluid.amount > 0) continue;
            fluid = null;
            break;
        }
        if (updated && doFill) {
            EntityPlayerMP player;
            this.setUserProgress(owner, progress);
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            EntityPlayerMP entityPlayerMP = player = server == null ? null : server.func_184103_al().func_177451_a(owner);
            if (player != null) {
                this.checkAndComplete(new ParticipantInfo((EntityPlayer)player), quest, true);
            } else {
                boolean hasAll = true;
                for (int j = 0; j < this.requiredFluids.size(); ++j) {
                    if (progress[j] >= ((FluidStack)this.requiredFluids.get((int)j)).amount) continue;
                    hasAll = false;
                    break;
                }
                if (hasAll) {
                    this.setComplete(owner);
                }
            }
        }
        return fluid;
    }

    @Override
    public ItemStack submitItem(UUID owner, DBEntry<IQuest> quest, ItemStack input) {
        if (owner == null || input.func_190926_b() || !this.consume || this.isComplete(owner)) {
            return input;
        }
        ItemStack item = input.func_77979_a(1);
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)item);
        if (handler == null) {
            return item;
        }
        boolean hasDrained = false;
        for (IFluidTankProperties tank : handler.getTankProperties()) {
            if (!tank.canDrain() || tank.getContents() == null || !tank.canDrainFluidType(tank.getContents())) continue;
            FluidStack remaining = this.submitFluidInternal(owner, quest, tank.getContents().copy(), false);
            FluidStack drain = tank.getContents().copy();
            drain.amount = drain.amount - (remaining == null ? 0 : remaining.amount);
            if (drain.amount <= 0) continue;
            this.submitFluidInternal(owner, quest, handler.drain(drain, true), true);
            hasDrained = true;
        }
        return hasDrained ? handler.getContainer() : item;
    }

    private void setUserProgress(UUID uuid, int[] progress) {
        this.userProgress.put(uuid, progress);
    }

    public int[] getUsersProgress(UUID uuid) {
        int[] progress = this.userProgress.get(uuid);
        return progress == null || progress.length != this.requiredFluids.size() ? new int[this.requiredFluids.size()] : progress;
    }

    private List<Tuple<UUID, int[]>> getBulkProgress(@Nonnull List<UUID> uuids) {
        if (uuids.size() <= 0) {
            return Collections.emptyList();
        }
        ArrayList<Tuple<UUID, int[]>> list = new ArrayList<Tuple<UUID, int[]>>();
        uuids.forEach(key -> list.add(new Tuple(key, (Object)this.getUsersProgress((UUID)key))));
        return list;
    }

    private void setBulkProgress(@Nonnull List<Tuple<UUID, int[]>> list) {
        list.forEach(entry -> this.setUserProgress((UUID)entry.func_76341_a(), (int[])entry.func_76340_b()));
    }

    @Override
    public List<String> getTextForSearch() {
        ArrayList<String> texts = new ArrayList<String>();
        for (FluidStack fluid : this.requiredFluids) {
            texts.add(fluid.getLocalizedName());
            texts.add(fluid.getUnlocalizedName());
        }
        return texts;
    }
}

