/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing.rewards.loot;

import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.INBTPartial;
import betterquesting.api2.storage.SimpleDatabase;
import betterquesting.questing.rewards.loot.LootGroup;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class LootRegistry
extends SimpleDatabase<LootGroup>
implements INBTPartial<NBTTagCompound, Integer> {
    public static final LootRegistry INSTANCE = new LootRegistry();
    private final Comparator<DBEntry<LootGroup>> groupSorter = Comparator.comparingInt(o -> ((LootGroup)o.getValue()).weight);
    public boolean updateUI = false;

    public synchronized LootGroup createNew(int id) {
        LootGroup group = new LootGroup();
        if (id >= 0) {
            this.add(id, group);
        }
        return group;
    }

    public int getTotalWeight() {
        int i = 0;
        for (DBEntry lg : this.getEntries()) {
            i += ((LootGroup)lg.getValue()).weight;
        }
        return i;
    }

    public LootGroup getWeightedGroup(float weight, Random rand) {
        int total = this.getTotalWeight();
        if (total <= 0) {
            return null;
        }
        float r = rand.nextFloat() * (float)total / 4.0f + weight * (float)total * 0.75f;
        int cnt = 0;
        ArrayList sorted = new ArrayList(this.getEntries());
        sorted.sort(this.groupSorter);
        for (DBEntry dBEntry : sorted) {
            if (!((float)(cnt += ((LootGroup)dBEntry.getValue()).weight) >= r)) continue;
            return (LootGroup)dBEntry.getValue();
        }
        return null;
    }

    @Override
    @Deprecated
    public synchronized NBTTagCompound writeToNBT(NBTTagCompound nbt, @Nullable List<Integer> subset) {
        return this.writeToNBT(nbt, subset, false);
    }

    @Override
    public synchronized NBTTagCompound writeToNBT(NBTTagCompound nbt, @Nullable List<Integer> subset, boolean reduce) {
        NBTTagList jRew = new NBTTagList();
        for (DBEntry entry : this.getEntries()) {
            if (subset != null && !subset.contains(entry.getID())) continue;
            NBTTagCompound jGrp = ((LootGroup)entry.getValue()).writeToNBT(new NBTTagCompound(), reduce);
            jGrp.func_74768_a("ID", entry.getID());
            jRew.func_74742_a((NBTBase)jGrp);
        }
        nbt.func_74782_a("groups", (NBTBase)jRew);
        return nbt;
    }

    @Override
    public synchronized void readFromNBT(NBTTagCompound tag, boolean merge) {
        if (!merge) {
            this.reset();
        }
        ArrayList<LootGroup> legacyGroups = new ArrayList<LootGroup>();
        NBTTagList list = tag.func_150295_c("groups", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound entry = list.func_150305_b(i);
            int id = entry.func_150297_b("ID", 99) ? entry.func_74762_e("ID") : -1;
            LootGroup group = (LootGroup)this.getValue(id);
            if (group == null) {
                group = this.createNew(id);
            }
            group.readFromNBT(entry);
            if (id >= 0) continue;
            legacyGroups.add(group);
        }
        for (LootGroup group : legacyGroups) {
            this.add(this.nextID(), group);
        }
    }
}

