/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing.rewards;

import betterquesting.NBTUtil;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.rewards.IReward;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import betterquesting.client.gui2.rewards.PanelRewardItem;
import betterquesting.core.BetterQuesting;
import betterquesting.questing.rewards.factory.FactoryRewardItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class RewardItem
implements IReward {
    public final List<BigItemStack> items = new ArrayList<BigItemStack>();

    @Override
    public ResourceLocation getFactoryID() {
        return FactoryRewardItem.INSTANCE.getRegistryName();
    }

    @Override
    public String getUnlocalisedName() {
        return "bq_standard.reward.item";
    }

    @Override
    public boolean canClaim(EntityPlayer player, DBEntry<IQuest> quest) {
        return true;
    }

    @Override
    public void claimReward(EntityPlayer player, DBEntry<IQuest> quest) {
        for (BigItemStack r : this.items) {
            BigItemStack stack = r.copy();
            for (ItemStack s : stack.getCombinedStacks()) {
                if (s.func_77978_p() != null) {
                    s.func_77982_d(NBTUtil.replaceStrings(s.func_77978_p(), "VAR_NAME", player.func_70005_c_()));
                    s.func_77982_d(NBTUtil.replaceStrings(s.func_77978_p(), "VAR_UUID", QuestingAPI.getQuestingUUID(player).toString()));
                }
                if (player.field_71071_by.func_70441_a(s)) continue;
                player.func_146097_a(s, true, false);
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.items.clear();
        NBTTagList rList = nbt.func_150295_c("rewards", 10);
        for (int i = 0; i < rList.func_74745_c(); ++i) {
            try {
                BigItemStack item = JsonHelper.JsonToItemStack(rList.func_150305_b(i));
                if (item == null) continue;
                this.items.add(item);
                continue;
            }
            catch (Exception e) {
                BetterQuesting.logger.log(Level.ERROR, "Unable to load reward item data", (Throwable)e);
            }
        }
    }

    @Override
    @Deprecated
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        return this.writeToNBT(nbt, false);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt, boolean reduce) {
        NBTTagList rJson = new NBTTagList();
        for (BigItemStack stack : this.items) {
            rJson.func_74742_a((NBTBase)JsonHelper.ItemStackToJson(stack, new NBTTagCompound(), reduce));
        }
        nbt.func_74782_a("rewards", (NBTBase)rJson);
        return nbt;
    }

    @Override
    public IGuiPanel getRewardGui(IGuiRect rect, DBEntry<IQuest> quest) {
        return new PanelRewardItem(rect, this);
    }

    @Override
    public GuiScreen getRewardEditor(GuiScreen screen, DBEntry<IQuest> quest) {
        return null;
    }
}

