/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network.handlers;

import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.network.QuestingPacket;
import betterquesting.core.BetterQuesting;
import betterquesting.questing.rewards.loot.LootRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class NetLootSync {
    private static final ResourceLocation ID_NAME = new ResourceLocation("bq_standard:loot_database");

    public static void registerHandler() {
        QuestingAPI.getAPI(ApiReference.PACKET_REG).registerServerHandler(ID_NAME, NetLootSync::onServer);
        if (BetterQuesting.proxy.isClient()) {
            QuestingAPI.getAPI(ApiReference.PACKET_REG).registerClientHandler(ID_NAME, NetLootSync::onClient);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void requestEdit(NBTTagCompound data) {
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74782_a("data", (NBTBase)data);
        QuestingAPI.getAPI(ApiReference.PACKET_SENDER).sendToServer(new QuestingPacket(ID_NAME, payload));
    }

    public static void sendSync(@Nullable EntityPlayerMP player) {
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74782_a("data", (NBTBase)LootRegistry.INSTANCE.writeToNBT(new NBTTagCompound(), (List<Integer>)null, true));
        if (player == null) {
            QuestingAPI.getAPI(ApiReference.PACKET_SENDER).sendToAll(new QuestingPacket(ID_NAME, payload));
        } else {
            QuestingAPI.getAPI(ApiReference.PACKET_SENDER).sendToPlayers(new QuestingPacket(ID_NAME, payload), player);
        }
    }

    private static void onServer(Tuple<NBTTagCompound, EntityPlayerMP> message) {
        EntityPlayerMP sender = (EntityPlayerMP)message.func_76340_b();
        NBTTagCompound data = (NBTTagCompound)message.func_76341_a();
        if (sender.func_184102_h() == null) {
            return;
        }
        if (!sender.func_184102_h().func_184103_al().func_152596_g(sender.func_146103_bH())) {
            BetterQuesting.logger.log(Level.WARN, "Player " + sender.func_70005_c_() + " (UUID:" + QuestingAPI.getQuestingUUID((EntityPlayer)sender) + ") tried to edit loot chests without OP permissions!");
            sender.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "You need to be OP to edit loot!"), true);
            return;
        }
        BetterQuesting.logger.log(Level.INFO, "Player " + sender.func_70005_c_() + " edited loot chests");
        LootRegistry.INSTANCE.readFromNBT(data.func_74775_l("data"), false);
        NetLootSync.sendSync(null);
    }

    @SideOnly(value=Side.CLIENT)
    private static void onClient(NBTTagCompound message) {
        LootRegistry.INSTANCE.readFromNBT(message.func_74775_l("data"), false);
        LootRegistry.INSTANCE.updateUI = true;
    }
}

