/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network.handlers;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.party.IParty;
import betterquesting.api2.storage.DBEntry;
import betterquesting.core.BetterQuesting;
import betterquesting.handlers.SaveLoadHandler;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeRegistry;
import betterquesting.network.handlers.NetCacheSync;
import betterquesting.network.handlers.NetChapterSync;
import betterquesting.network.handlers.NetInviteSync;
import betterquesting.network.handlers.NetLifeSync;
import betterquesting.network.handlers.NetNameSync;
import betterquesting.network.handlers.NetPartySync;
import betterquesting.network.handlers.NetQuestSync;
import betterquesting.network.handlers.NetSettingSync;
import betterquesting.questing.party.PartyInvitations;
import betterquesting.questing.party.PartyManager;
import betterquesting.storage.NameCache;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NetBulkSync {
    private static final ResourceLocation ID_NAME = new ResourceLocation("betterquesting", "main_sync");

    public static void registerHandler() {
        PacketTypeRegistry.INSTANCE.registerServerHandler(ID_NAME, NetBulkSync::onServer);
        if (BetterQuesting.proxy.isClient()) {
            PacketTypeRegistry.INSTANCE.registerClientHandler(ID_NAME, NetBulkSync::onClient);
        }
    }

    public static void sendReset(@Nullable EntityPlayerMP player, boolean reset, boolean respond) {
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74757_a("reset", reset);
        payload.func_74757_a("respond", respond);
        if (player == null) {
            PacketSender.INSTANCE.sendToAll(new QuestingPacket(ID_NAME, payload));
        } else {
            PacketSender.INSTANCE.sendToPlayers(new QuestingPacket(ID_NAME, payload), player);
        }
    }

    public static void sendSync(@Nonnull EntityPlayerMP player) {
        boolean nameChanged = NameCache.INSTANCE.updateName(player);
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        NetSettingSync.sendSync(player);
        NetQuestSync.sendSync(player, null, true, true);
        NetChapterSync.sendSync(player, null);
        NetLifeSync.sendSync(new EntityPlayerMP[]{player}, new UUID[]{playerID});
        DBEntry<IParty> party = PartyManager.INSTANCE.getParty(playerID);
        List<Map.Entry<Integer, Long>> invites = PartyInvitations.INSTANCE.getPartyInvites(playerID);
        int partyCount = invites.size() + (party == null ? 0 : 1);
        if (partyCount > 0) {
            int[] pids = new int[partyCount];
            for (int i = 0; i < invites.size(); ++i) {
                pids[i] = invites.get(i).getKey();
            }
            if (party != null) {
                pids[partyCount - 1] = party.getID();
            }
            NetPartySync.sendSync(new EntityPlayerMP[]{player}, pids);
        }
        if (party != null) {
            NetNameSync.quickSync(nameChanged ? null : player, party.getID());
        } else {
            NetNameSync.sendNames(new EntityPlayerMP[]{player}, new UUID[]{playerID}, null);
        }
        NetInviteSync.sendSync(player);
        NetCacheSync.sendSync(player);
    }

    private static void onServer(Tuple<NBTTagCompound, EntityPlayerMP> message) {
        NetBulkSync.sendSync((EntityPlayerMP)message.func_76340_b());
    }

    @SideOnly(value=Side.CLIENT)
    private static void onClient(NBTTagCompound message) {
        if (message.func_74767_n("reset") && !Minecraft.func_71410_x().func_71387_A()) {
            SaveLoadHandler.INSTANCE.unloadDatabases();
        }
        if (message.func_74767_n("respond")) {
            PacketSender.INSTANCE.sendToServer(new QuestingPacket(ID_NAME, new NBTTagCompound()));
        }
    }
}

