/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.importers.ftbq;

import betterquesting.api.placeholders.PlaceholderConverter;
import betterquesting.api.utils.BigItemStack;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public class FTBQUtils {
    public static BigItemStack convertItem(NBTBase tag) {
        if (tag instanceof NBTTagString) {
            return FTBQUtils.convertItemType1(((NBTTagString)tag).func_150285_a_());
        }
        if (tag instanceof NBTTagCompound) {
            return FTBQUtils.convertItemType2((NBTTagCompound)tag);
        }
        return new BigItemStack(ItemStack.field_190927_a);
    }

    private static BigItemStack convertItemType1(String string) {
        String[] split = string.split(" ");
        if (split.length <= 0) {
            return new BigItemStack(ItemStack.field_190927_a);
        }
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(split[0]));
        int count = split.length < 2 ? 1 : FTBQUtils.tryParseInt(split[1], 1);
        int meta = split.length < 3 ? 0 : FTBQUtils.tryParseInt(split[2], 0);
        NBTTagCompound tags = null;
        return PlaceholderConverter.convertItem(item, split[0], count, meta, "", tags);
    }

    private static BigItemStack convertItemType2(NBTTagCompound tag) {
        int count;
        String[] split = tag.func_74779_i("id").split(" ");
        if (split.length <= 0) {
            return new BigItemStack(ItemStack.field_190927_a);
        }
        if (split[0].equals("itemfilters:filter")) {
            String filterType;
            String displayName = tag.func_74775_l("tag").func_74775_l("display").func_74779_i("Name");
            switch (filterType = tag.func_74775_l("ForgeCaps").func_74775_l("Parent").func_74779_i("id")) {
                case "ore": {
                    String oredict = tag.func_74775_l("ForgeCaps").func_74775_l("Parent").func_74779_i("data");
                    NonNullList ores = OreDictionary.getOres((String)oredict);
                    BigItemStack bigItemStack = new BigItemStack(ores.isEmpty() ? ItemStack.field_190927_a.func_77946_l() : (ItemStack)ores.get(0));
                    bigItemStack.setOreDict(oredict);
                    bigItemStack.getBaseStack().func_77964_b(0);
                    return bigItemStack;
                }
            }
            throw new RuntimeException("Invalid filterType");
        }
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(split[0]));
        int n = count = split.length < 2 ? 1 : FTBQUtils.tryParseInt(split[1], 1);
        int meta = tag.func_74764_b("Damage") ? tag.func_74762_e("Damage") : (split.length < 3 ? 0 : FTBQUtils.tryParseInt(split[2], 0));
        NBTTagCompound tags = !tag.func_150297_b("tag", 10) ? null : tag.func_74775_l("tag");
        return PlaceholderConverter.convertItem(item, split[0], count, meta, "", tags);
    }

    private static int tryParseInt(String text, int def) {
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }
}

