/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.commands.admin;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.storage.BQ_Settings;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api.utils.NBTConverter;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.commands.QuestCommandBase;
import betterquesting.handlers.SaveLoadHandler;
import betterquesting.legacy.ILegacyLoader;
import betterquesting.legacy.LegacyLoaderRegistry;
import betterquesting.network.handlers.NetChapterSync;
import betterquesting.network.handlers.NetQuestSync;
import betterquesting.network.handlers.NetSettingSync;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestInstance;
import betterquesting.questing.QuestLineDatabase;
import betterquesting.storage.QuestSettings;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.Nullable;

public class QuestCommandDefaults
extends QuestCommandBase {
    public static final String DEFAULT_FILE = "DefaultQuests";
    public static final String SETTINGS_FILE = "QuestSettings.json";
    public static final String QUEST_LINE_DIR = "QuestLines";
    public static final String QUEST_DIR = "Quests";
    public static final String NO_QUEST_LINE_DIRECTORY = "NoQuestLine";
    public static final String MULTI_QUEST_LINE_DIRECTORY = "MultipleQuestLine";
    public static final int FILE_NAME_MAX_LENGTH = 16;

    @Override
    public String getUsageSuffix() {
        return "[save|load|set|saveLegacy|loadLegacy] [file_name]";
    }

    @Override
    public boolean validArgs(String[] args) {
        return args.length == 2 || args.length == 3;
    }

    @Override
    public List<String> autoComplete(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length == 2) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"save", "load", "set", "saveLegacy", "loadLegacy"});
        }
        if (args.length == 3) {
            return Collections.singletonList(DEFAULT_FILE);
        }
        return Collections.emptyList();
    }

    @Override
    public String getCommand() {
        return "default";
    }

    @Override
    public void runCommand(MinecraftServer server, CommandBase command, ICommandSender sender, String[] args) throws CommandException {
        File legacyFile;
        File dataDir;
        String databaseName;
        if (args.length == 3 && !args[2].equalsIgnoreCase(DEFAULT_FILE)) {
            databaseName = args[2];
            dataDir = new File(BQ_Settings.defaultDir, "saved_quests/" + args[2]);
            legacyFile = new File(BQ_Settings.defaultDir, "saved_quests/" + args[2] + ".json");
        } else {
            databaseName = DEFAULT_FILE;
            dataDir = new File(BQ_Settings.defaultDir, DEFAULT_FILE);
            legacyFile = new File(BQ_Settings.defaultDir, "DefaultQuests.json");
        }
        if (args[1].equalsIgnoreCase("save")) {
            QuestCommandDefaults.save(sender, databaseName, dataDir);
        } else if (args[1].equalsIgnoreCase("saveLegacy")) {
            QuestCommandDefaults.saveLegacy(sender, databaseName, legacyFile);
        } else if (args[1].equalsIgnoreCase("load")) {
            QuestCommandDefaults.load(sender, databaseName, dataDir, false);
        } else if (args[1].equalsIgnoreCase("loadLegacy")) {
            QuestCommandDefaults.loadLegacy(sender, databaseName, legacyFile, false);
        } else if (args[1].equalsIgnoreCase("set") && args.length == 3) {
            if (!dataDir.exists() && legacyFile.exists()) {
                QuestCommandDefaults.setLegacy(sender, databaseName, legacyFile);
            } else {
                QuestCommandDefaults.set(sender, databaseName, dataDir);
            }
        } else {
            throw this.getException(command);
        }
    }

    public static void save(@Nullable ICommandSender sender, String databaseName, File dataDir) {
        BiFunction<String, Integer, String> buildFileName = (name, id) -> {
            String formattedName = QuestCommandDefaults.removeChatFormatting(name).replaceAll("[^a-zA-Z]", "");
            if (formattedName.length() > 16) {
                formattedName = formattedName.substring(0, 16);
            }
            if (!BQ_Settings.saveQuestsWithNames) {
                return String.valueOf(id);
            }
            return String.format("%s-%s", formattedName, id);
        };
        File settingsFile = new File(dataDir, SETTINGS_FILE);
        if (dataDir.exists()) {
            if (!settingsFile.exists()) {
                QuestingAPI.getLogger().log(Level.ERROR, "Directory exists, but isn't a database\n{}", (Object)dataDir);
                QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.error", new Object[0]);
                return;
            }
            try {
                FileUtils.deleteDirectory((File)dataDir);
            }
            catch (IOException e) {
                QuestingAPI.getLogger().log(Level.ERROR, "Failed to delete directory\n" + dataDir, (Throwable)e);
                QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.error", new Object[0]);
                return;
            }
        }
        if (!dataDir.mkdirs()) {
            QuestingAPI.getLogger().log(Level.ERROR, "Failed to create directory\n{}", (Object)dataDir);
            QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.error", new Object[0]);
            return;
        }
        boolean editMode = QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE);
        QuestSettings.INSTANCE.setProperty(NativeProps.EDIT_MODE, false);
        NBTTagCompound settingsTag = QuestSettings.INSTANCE.writeToNBT(new NBTTagCompound(), true);
        settingsTag.func_74778_a("format", "2.1.0");
        JsonHelper.WriteToFile(settingsFile, NBTConverter.NBTtoJSON_Compound(settingsTag, new JsonObject(), true));
        QuestSettings.INSTANCE.setProperty(NativeProps.EDIT_MODE, editMode);
        File questLineDir = new File(dataDir, QUEST_LINE_DIR);
        if (!questLineDir.exists() && !questLineDir.mkdirs()) {
            QuestingAPI.getLogger().log(Level.ERROR, "Failed to create directories\n{}", (Object)questLineDir);
            QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.error", new Object[0]);
            return;
        }
        ListMultimap questToQuestLineMultimap = MultimapBuilder.hashKeys().arrayListValues().build();
        for (DBEntry entry : QuestLineDatabase.INSTANCE.getEntries()) {
            int questLineId = entry.getID();
            IQuestLine questLine = (IQuestLine)entry.getValue();
            questLine.getEntries().forEach(quest -> questToQuestLineMultimap.put((Object)quest.getID(), (Object)questLine));
            String questLineName = questLine.getProperty(NativeProps.NAME);
            String questLineNameTranslated = QuestTranslation.translate(questLineName, new Object[0]);
            File questLineFile = new File(questLineDir, buildFileName.apply(questLineNameTranslated, questLineId) + ".json");
            NBTTagCompound questLineTag = questLine.writeToNBT(new NBTTagCompound(), null, true);
            questLineTag.func_74768_a("lineID", questLineId);
            questLineTag.func_74768_a("order", QuestLineDatabase.INSTANCE.getOrderIndex(entry.getID()));
            JsonHelper.WriteToFile(questLineFile, NBTConverter.NBTtoJSON_Compound(questLineTag, new JsonObject(), true));
        }
        for (DBEntry entry : QuestDatabase.INSTANCE.getEntries()) {
            int questId = entry.getID();
            IQuest quest2 = (IQuest)entry.getValue();
            List questLines = questToQuestLineMultimap.get((Object)questId);
            File questDir = new File(dataDir, QUEST_DIR);
            switch (questLines.size()) {
                case 0: {
                    questDir = new File(questDir, NO_QUEST_LINE_DIRECTORY);
                    break;
                }
                case 1: {
                    IQuestLine questLine = (IQuestLine)questLines.get(0);
                    int questLineId = QuestLineDatabase.INSTANCE.getID(questLine);
                    String questLineName = questLine.getProperty(NativeProps.NAME);
                    String translatedLineName = QuestTranslation.translate(questLineName, new Object[0]);
                    questDir = new File(questDir, buildFileName.apply(translatedLineName, questLineId));
                    break;
                }
                default: {
                    questDir = new File(questDir, MULTI_QUEST_LINE_DIRECTORY);
                }
            }
            String questName = quest2.getProperty(NativeProps.NAME);
            String translatedQuestName = QuestTranslation.translate(questName, new Object[0]);
            File questFile = new File(questDir, buildFileName.apply(translatedQuestName, questId) + ".json");
            if (!questFile.exists() && !questFile.mkdirs()) {
                QuestingAPI.getLogger().log(Level.ERROR, "Failed to create directories\n{}", (Object)questFile);
                QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.error", new Object[0]);
                return;
            }
            NBTTagCompound questTag = quest2.writeToNBT(new NBTTagCompound(), true);
            questTag.func_74768_a("questID", questId);
            JsonHelper.WriteToFile(questFile, NBTConverter.NBTtoJSON_Compound(questTag, new JsonObject(), true));
        }
        if (databaseName != null && !databaseName.equalsIgnoreCase(DEFAULT_FILE)) {
            QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.default.save2", databaseName);
        } else {
            QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.default.save", new Object[0]);
        }
    }

    public static void saveLegacy(@Nullable ICommandSender sender, String databaseName, File legacyFile) {
        boolean editMode = QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE);
        NBTTagCompound base = new NBTTagCompound();
        QuestSettings.INSTANCE.setProperty(NativeProps.EDIT_MODE, false);
        base.func_74782_a("questSettings", (NBTBase)QuestSettings.INSTANCE.writeToNBT(new NBTTagCompound(), true));
        QuestSettings.INSTANCE.setProperty(NativeProps.EDIT_MODE, editMode);
        base.func_74782_a("questDatabase", (NBTBase)QuestDatabase.INSTANCE.writeToNBT(new NBTTagList(), (List<Integer>)null, true));
        base.func_74782_a("questLines", (NBTBase)QuestLineDatabase.INSTANCE.writeToNBT(new NBTTagList(), (List<Integer>)null, true));
        base.func_74778_a("format", "2.1.0");
        base.func_74778_a("build", "4.2.6");
        JsonHelper.WriteToFile(legacyFile, NBTConverter.NBTtoJSON_Compound(base, new JsonObject(), true));
        if (databaseName != null && databaseName.equalsIgnoreCase(DEFAULT_FILE)) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("betterquesting.cmd.default.save2", new Object[]{databaseName + ".json"}));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("betterquesting.cmd.default.save", new Object[0]));
        }
    }

    public static void load(@Nullable ICommandSender sender, @Nullable String databaseName, File dataDir, boolean loadWorldSettings) {
        if (!dataDir.exists()) {
            QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.default.none", new Object[0]);
            return;
        }
        Function<File, NBTTagCompound> readNbt = file -> NBTConverter.JSONtoNBT_Object(JsonHelper.ReadFromFile(file), new NBTTagCompound(), true);
        boolean editMode = QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE);
        boolean hardMode = QuestSettings.INSTANCE.getProperty(NativeProps.HARDCORE);
        NBTTagList jsonP = QuestDatabase.INSTANCE.writeProgressToNBT(new NBTTagList(), (List<UUID>)null);
        File settingsFile = new File(dataDir, SETTINGS_FILE);
        if (!settingsFile.exists()) {
            QuestingAPI.getLogger().log(Level.ERROR, "Failed to find file\n{}", (Object)settingsFile);
            QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.error", new Object[0]);
            return;
        }
        QuestSettings.INSTANCE.readFromNBT(readNbt.apply(settingsFile));
        File questLineDir = new File(dataDir, QUEST_LINE_DIR);
        NBTTagList questLineDatabase = new NBTTagList();
        ArrayList sortedQuestLineFiles = new ArrayList();
        try (Stream<Path> paths = Files.walk(questLineDir.toPath(), new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                File questLineFile = path.toFile();
                sortedQuestLineFiles.add(questLineFile);
            });
        }
        catch (IOException e) {
            QuestingAPI.getLogger().log(Level.ERROR, "Failed to traverse directory\n" + questLineDir, (Throwable)e);
            QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.error", new Object[0]);
            return;
        }
        if (!sortedQuestLineFiles.isEmpty()) {
            sortedQuestLineFiles.sort((file1, file2) -> {
                int id1 = Integer.parseInt(file1.getName().replaceAll("[^0-9]+", ""));
                int id2 = Integer.parseInt(file2.getName().replaceAll("[^0-9]+", ""));
                return id1 - id2;
            });
        }
        sortedQuestLineFiles.stream().map(readNbt).forEach(arg_0 -> ((NBTTagList)questLineDatabase).func_74742_a(arg_0));
        QuestLineDatabase.INSTANCE.readFromNBT(questLineDatabase, false);
        QuestDatabase.INSTANCE.reset();
        File questDir = new File(dataDir, QUEST_DIR);
        try (Stream<Path> paths = Files.walk(questDir.toPath(), new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                int questId;
                File questFile = path.toFile();
                NBTTagCompound questTag = (NBTTagCompound)readNbt.apply(questFile);
                int n = questId = questTag.func_150297_b("questID", 99) ? questTag.func_74762_e("questID") : -1;
                if (questId < 0) {
                    questId = Integer.parseInt(questFile.getName().replaceAll("[^0-9]+", ""));
                }
                if (questId < 0) {
                    return;
                }
                QuestInstance quest = new QuestInstance();
                quest.readFromNBT(questTag);
                QuestDatabase.INSTANCE.add(questId, quest);
            });
        }
        catch (IOException e) {
            QuestingAPI.getLogger().log(Level.ERROR, "Failed to traverse directory\n" + questDir, (Throwable)e);
            QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.error", new Object[0]);
            return;
        }
        if (!loadWorldSettings) {
            QuestDatabase.INSTANCE.readProgressFromNBT(jsonP, false);
            QuestSettings.INSTANCE.setProperty(NativeProps.EDIT_MODE, editMode);
            QuestSettings.INSTANCE.setProperty(NativeProps.HARDCORE, hardMode);
        }
        if (databaseName != null && !databaseName.equalsIgnoreCase(DEFAULT_FILE)) {
            QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.default.load2", databaseName);
        } else {
            QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.default.load", new Object[0]);
        }
        NetSettingSync.sendSync(null);
        NetQuestSync.quickSync(-1, true, true);
        NetChapterSync.sendSync(null, null);
        SaveLoadHandler.INSTANCE.markDirty();
    }

    public static void loadLegacy(@Nullable ICommandSender sender, @Nullable String databaseName, File legacyFile, boolean loadWorldSettings) {
        if (legacyFile.exists()) {
            boolean editMode = QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE);
            boolean hardMode = QuestSettings.INSTANCE.getProperty(NativeProps.HARDCORE);
            NBTTagList jsonP = QuestDatabase.INSTANCE.writeProgressToNBT(new NBTTagList(), (List<UUID>)null);
            JsonObject j1 = JsonHelper.ReadFromFile(legacyFile);
            NBTTagCompound nbt1 = NBTConverter.JSONtoNBT_Object(j1, new NBTTagCompound(), true);
            ILegacyLoader loader = LegacyLoaderRegistry.getLoader(nbt1.func_150297_b("format", 8) ? nbt1.func_74779_i("format") : "0.0.0");
            if (loader == null) {
                QuestSettings.INSTANCE.readFromNBT(nbt1.func_74775_l("questSettings"));
                QuestDatabase.INSTANCE.readFromNBT(nbt1.func_150295_c("questDatabase", 10), false);
                QuestLineDatabase.INSTANCE.readFromNBT(nbt1.func_150295_c("questLines", 10), false);
            } else {
                loader.readFromJson((JsonElement)j1);
            }
            if (!loadWorldSettings) {
                QuestDatabase.INSTANCE.readProgressFromNBT(jsonP, false);
                QuestSettings.INSTANCE.setProperty(NativeProps.EDIT_MODE, editMode);
                QuestSettings.INSTANCE.setProperty(NativeProps.HARDCORE, hardMode);
            }
            if (databaseName != null && !databaseName.equalsIgnoreCase(DEFAULT_FILE)) {
                QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.default.load2", databaseName + ".json");
            } else {
                QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.default.load", new Object[0]);
            }
            NetSettingSync.sendSync(null);
            NetQuestSync.quickSync(-1, true, true);
            NetChapterSync.sendSync(null, null);
            SaveLoadHandler.INSTANCE.markDirty();
        } else {
            QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.default.none", new Object[0]);
        }
    }

    public static void set(@Nullable ICommandSender sender, String databaseName, File dataDir) {
        if (!dataDir.exists() || databaseName.equalsIgnoreCase(DEFAULT_FILE)) {
            QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.default.none", new Object[0]);
            return;
        }
        File defDir = new File(BQ_Settings.defaultDir, DEFAULT_FILE);
        if (defDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)defDir);
            }
            catch (IOException e) {
                QuestingAPI.getLogger().log(Level.ERROR, "Failed to delete directory\n" + defDir, (Throwable)e);
                QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.error", new Object[0]);
                return;
            }
        }
        try {
            FileUtils.copyDirectory((File)dataDir, (File)defDir);
        }
        catch (IOException e) {
            QuestingAPI.getLogger().log(Level.ERROR, "Failed to copy directory\n" + dataDir, (Throwable)e);
            QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.error", new Object[0]);
            return;
        }
        QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.default.set", databaseName);
    }

    public static void setLegacy(@Nullable ICommandSender sender, String databaseName, File legacyFile) {
        if (legacyFile.exists() && !databaseName.equalsIgnoreCase(DEFAULT_FILE)) {
            File defFile = new File(BQ_Settings.defaultDir, "DefaultQuests.json");
            if (defFile.exists()) {
                defFile.delete();
            }
            JsonHelper.CopyPaste(legacyFile, defFile);
            QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.default.set", databaseName);
        } else {
            QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.default.none", new Object[0]);
        }
    }

    @Override
    public String getPermissionNode() {
        return "betterquesting.command.admin.default";
    }

    @Override
    public DefaultPermissionLevel getPermissionLevel() {
        return DefaultPermissionLevel.OP;
    }

    @Override
    public String getPermissionDescription() {
        return "Permission to saves/loads the current quest database to/from the global default directory";
    }

    private static String removeChatFormatting(String string) {
        return string.replaceAll("\u00a7[0-9a-fk-or]", "");
    }

    private static void sendChatMessage(@Nullable ICommandSender sender, String translationKey, Object ... args) {
        if (sender == null) {
            return;
        }
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(translationKey, args));
    }
}

