/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.commands.admin;

import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api2.storage.DBEntry;
import betterquesting.commands.QuestCommandBase;
import betterquesting.questing.QuestDatabase;
import betterquesting.storage.NameCache;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.server.permission.DefaultPermissionLevel;

public class QuestCommandCheckCompletion
extends QuestCommandBase {
    @Override
    public String getUsageSuffix() {
        return "<username|uuid> <quest_id>";
    }

    @Override
    public String getPermissionNode() {
        return "betterquesting.command.admin.check_quest_completion";
    }

    @Override
    public DefaultPermissionLevel getPermissionLevel() {
        return DefaultPermissionLevel.OP;
    }

    @Override
    public String getPermissionDescription() {
        return "Permission to check the completion of quests of a given user";
    }

    @Override
    public boolean validArgs(@Nonnull String[] args) {
        return args.length == 3;
    }

    @Override
    public List<String> autoComplete(MinecraftServer server, ICommandSender sender, @Nonnull String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 2) {
            return CommandBase.func_71530_a((String[])args, (String[])NameCache.INSTANCE.getAllNames().toArray(new String[0]));
        }
        if (args.length == 3) {
            for (DBEntry i : QuestDatabase.INSTANCE.getEntries()) {
                list.add(Integer.toString(i.getID()));
            }
        }
        return list;
    }

    @Override
    public String getCommand() {
        return "check";
    }

    @Override
    public void runCommand(MinecraftServer server, CommandBase command, ICommandSender sender, @Nonnull String[] args) throws CommandException {
        UUID uuid = this.findPlayerID(server, sender, args[1]);
        if (uuid == null) {
            sender.func_145747_a(new TextComponentTranslation("betterquesting.cmd.check.no_player_match", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            throw this.getException(command);
        }
        String pName = NameCache.INSTANCE.getName(uuid);
        int id = Integer.parseInt(args[2].trim());
        IQuest quest = (IQuest)QuestDatabase.INSTANCE.getValue(id);
        if (quest == null) {
            sender.func_145747_a(new TextComponentTranslation("betterquesting.cmd.check.no_id_match", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            throw this.getException(command);
        }
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("betterquesting.cmd.check." + quest.isComplete(uuid), new Object[]{pName, new TextComponentTranslation(quest.getProperty(NativeProps.NAME), new Object[0])}));
    }

    @Override
    public boolean isArgUsername(String[] args, int index) {
        return index == 1;
    }
}

