/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.ui_builder;

import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.INBTSaveLoad;
import betterquesting.client.ui_builder.ComponentRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import org.lwjgl.util.vector.Vector4f;

public class ComponentPanel
implements INBTSaveLoad<NBTTagCompound> {
    public String refName = "New Panel";
    public String panelType = new ResourceLocation("betterquesting", "canvas_empty").toString();
    public int cvParentID = -1;
    public int tfParentID = -1;
    private NBTTagCompound transTag = new NBTTagCompound();
    private NBTTagCompound panelData = new NBTTagCompound();
    private final List<String> scripts = new ArrayList<String>();

    public ComponentPanel() {
        this.setTransform(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(8, 8, 8, 8), 0));
    }

    public ComponentPanel(GuiTransform transform) {
        this.setTransform(transform);
    }

    public void setTransform(GuiTransform transform) {
        Vector4f anchor = transform.getAnchor();
        this.transTag.func_74776_a("anchor_left", anchor.x);
        this.transTag.func_74776_a("anchor_top", anchor.y);
        this.transTag.func_74776_a("anchor_right", anchor.z);
        this.transTag.func_74776_a("anchor_bottom", anchor.w);
        GuiPadding padding = transform.getPadding();
        this.transTag.func_74768_a("pad_left", padding.l);
        this.transTag.func_74768_a("pad_top", padding.t);
        this.transTag.func_74768_a("pad_right", padding.r);
        this.transTag.func_74768_a("pad_bottom", padding.b);
        this.transTag.func_74768_a("depth", transform.getDepth());
    }

    public NBTTagCompound getTransformTag() {
        return this.transTag;
    }

    public NBTTagCompound getPanelData() {
        return this.panelData;
    }

    public void setPanelData(@Nonnull NBTTagCompound tag) {
        this.panelData = tag;
    }

    public IGuiPanel build() {
        Vector4f anchor = new Vector4f(this.transTag.func_74760_g("anchor_left"), this.transTag.func_74760_g("anchor_top"), this.transTag.func_74760_g("anchor_right"), this.transTag.func_74760_g("anchor_bottom"));
        GuiPadding padding = new GuiPadding(this.transTag.func_74762_e("pad_left"), this.transTag.func_74762_e("pad_top"), this.transTag.func_74762_e("pad_right"), this.transTag.func_74762_e("pad_bottom"));
        GuiTransform transform = new GuiTransform(anchor, padding, this.transTag.func_74762_e("depth"));
        ResourceLocation res = StringUtils.func_151246_b((String)this.panelType) ? new ResourceLocation("betterquesting", "canvas_empty") : new ResourceLocation(this.panelType);
        return ComponentRegistry.INSTANCE.createNew(res, transform, this.panelData);
    }

    @Override
    @Deprecated
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        return this.writeToNBT(nbt, false);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt, boolean reduce) {
        nbt.func_74778_a("ref_name", this.refName);
        nbt.func_74778_a("panel_type", this.panelType);
        nbt.func_74768_a("cv_parent", this.cvParentID);
        nbt.func_74768_a("tf_parent", this.tfParentID);
        nbt.func_74782_a("transform", (NBTBase)this.transTag.func_74737_b());
        nbt.func_74782_a("panel_data", (NBTBase)this.panelData.func_74737_b());
        NBTTagList sList = new NBTTagList();
        this.scripts.forEach(str -> sList.func_74742_a((NBTBase)new NBTTagString(str)));
        nbt.func_74782_a("script_hooks", (NBTBase)sList);
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.refName = nbt.func_74779_i("ref_name");
        this.panelType = nbt.func_74779_i("panel_type");
        this.cvParentID = nbt.func_74762_e("cv_parent");
        this.tfParentID = nbt.func_74762_e("tf_parent");
        this.transTag = nbt.func_74775_l("transform").func_74737_b();
        this.panelData = nbt.func_74775_l("panel_data").func_74737_b();
        this.scripts.clear();
        NBTTagList sList = nbt.func_150295_c("script_hooks", 8);
        for (int i = 0; i < sList.func_74745_c(); ++i) {
            this.scripts.add(sList.func_150307_f(i));
        }
    }
}

