/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui2.tasks;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasMinimum;
import betterquesting.api2.client.gui.panels.content.PanelGeneric;
import betterquesting.api2.client.gui.panels.content.PanelItemSlot;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.resources.colors.GuiColorStatic;
import betterquesting.api2.client.gui.resources.textures.GuiTextureColored;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetIcon;
import betterquesting.client.themes.BQSTextures;
import betterquesting.questing.tasks.TaskInteractItem;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;

public class PanelTaskInteractItem
extends CanvasMinimum {
    private final IGuiRect initialRect;
    private final TaskInteractItem task;

    public PanelTaskInteractItem(IGuiRect rect, TaskInteractItem task) {
        super(rect);
        this.initialRect = rect;
        this.task = task;
    }

    @Override
    public void initPanel() {
        super.initPanel();
        int width = this.initialRect.getWidth();
        int centerWidth = width / 2;
        PanelItemSlot itemSlot = new PanelItemSlot(new GuiTransform(GuiAlign.TOP_LEFT, centerWidth - 48, 0, 32, 32, 0), -1, this.task.targetItem, false, true);
        this.addPanel(itemSlot);
        PanelItemSlot targetSlot = new PanelItemSlot(new GuiTransform(GuiAlign.TOP_LEFT, centerWidth + 16, 0, 32, 32, 0), -1, this.task.targetBlock.getItemStack(), false, true);
        this.addPanel(targetSlot);
        this.addPanel(new PanelGeneric(new GuiTransform(GuiAlign.TOP_LEFT, centerWidth - 8, 0, 16, 16, 0), PresetIcon.ICON_RIGHT.getTexture()));
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        int prog = this.task.getUsersProgress(playerID);
        this.addPanel(new PanelTextBox(new GuiTransform(GuiAlign.TOP_LEFT, centerWidth - 16, 18, 32, 14, 0), prog + "/" + this.task.required).setAlignment(1).setColor(PresetColor.TEXT_MAIN.getColor()));
        this.addPanel(new PanelGeneric(new GuiTransform(GuiAlign.TOP_LEFT, centerWidth - 48, 40, 24, 24, 0), BQSTextures.HAND_LEFT.getTexture()));
        this.addPanel(new PanelGeneric(new GuiTransform(GuiAlign.TOP_LEFT, centerWidth - 24, 40, 24, 24, 0), BQSTextures.HAND_RIGHT.getTexture()));
        this.addPanel(new PanelGeneric(new GuiTransform(GuiAlign.TOP_LEFT, centerWidth, 40, 24, 24, 0), BQSTextures.ATK_SYMB.getTexture()));
        this.addPanel(new PanelGeneric(new GuiTransform(GuiAlign.TOP_LEFT, centerWidth + 24, 40, 24, 24, 0), BQSTextures.USE_SYMB.getTexture()));
        GuiTextureColored txTick = new GuiTextureColored(PresetIcon.ICON_TICK.getTexture(), new GuiColorStatic(-16711936));
        GuiTextureColored txCross = new GuiTextureColored(PresetIcon.ICON_CROSS.getTexture(), new GuiColorStatic(-65536));
        this.addPanel(new PanelGeneric(new GuiTransform(GuiAlign.TOP_LEFT, centerWidth - 32, 56, 8, 8, 0), this.task.useOffHand ? txTick : txCross));
        this.addPanel(new PanelGeneric(new GuiTransform(GuiAlign.TOP_LEFT, centerWidth - 8, 56, 8, 8, 0), this.task.useMainHand ? txTick : txCross));
        this.addPanel(new PanelGeneric(new GuiTransform(GuiAlign.TOP_LEFT, centerWidth + 16, 56, 8, 8, 0), this.task.onHit ? txTick : txCross));
        this.addPanel(new PanelGeneric(new GuiTransform(GuiAlign.TOP_LEFT, centerWidth + 40, 56, 8, 8, 0), this.task.onInteract ? txTick : txCross));
        this.recalculateSizes();
    }
}

