/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui2.tasks;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasMinimum;
import betterquesting.api2.client.gui.panels.content.PanelGeneric;
import betterquesting.api2.client.gui.panels.content.PanelItemSlot;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.resources.colors.GuiColorStatic;
import betterquesting.api2.client.gui.resources.textures.GuiTextureColored;
import betterquesting.api2.client.gui.resources.textures.ItemTexture;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetIcon;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.questing.tasks.TaskCrafting;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.text.TextFormatting;

public class PanelTaskCrafting
extends CanvasMinimum {
    private final IGuiRect initialRect;
    private final TaskCrafting task;

    public PanelTaskCrafting(IGuiRect rect, TaskCrafting task) {
        super(rect);
        this.initialRect = rect;
        this.task = task;
    }

    @Override
    public void initPanel() {
        super.initPanel();
        UUID uuid = QuestingAPI.getQuestingUUID((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        int[] progress = this.task.getUsersProgress(uuid);
        boolean isComplete = this.task.isComplete(uuid);
        GuiTextureColored txTick = new GuiTextureColored(PresetIcon.ICON_TICK.getTexture(), new GuiColorStatic(-16711936));
        GuiTextureColored txCross = new GuiTextureColored(PresetIcon.ICON_CROSS.getTexture(), new GuiColorStatic(-65536));
        this.addPanel(new PanelGeneric(new GuiRectangle(0, 0, 16, 16, 0), new ItemTexture(new BigItemStack(Blocks.field_150462_ai))));
        this.addPanel(new PanelGeneric(new GuiRectangle(10, 10, 6, 6, 0), this.task.allowCraft ? txTick : txCross));
        this.addPanel(new PanelGeneric(new GuiRectangle(24, 0, 16, 16, 0), new ItemTexture(new BigItemStack(Blocks.field_150460_al))));
        this.addPanel(new PanelGeneric(new GuiRectangle(34, 10, 6, 6, 0), this.task.allowSmelt ? txTick : txCross));
        this.addPanel(new PanelGeneric(new GuiRectangle(48, 0, 16, 16, 0), new ItemTexture(new BigItemStack(Blocks.field_150467_bQ))));
        this.addPanel(new PanelGeneric(new GuiRectangle(58, 10, 6, 6, 0), this.task.allowAnvil ? txTick : txCross));
        int listW = this.initialRect.getWidth();
        for (int i = 0; i < this.task.requiredItems.size(); ++i) {
            BigItemStack stack = (BigItemStack)this.task.requiredItems.get(i);
            PanelItemSlot slot = new PanelItemSlot(new GuiRectangle(0, i * 28 + 24, 28, 28, 0), -1, stack, false, true);
            this.addPanel(slot);
            StringBuilder sb = new StringBuilder();
            sb.append(stack.getBaseStack().func_82833_r());
            if (stack.hasOreDict()) {
                sb.append(" (").append(stack.getOreDict()).append(")");
            }
            sb.append("\n").append(progress[i]).append("/").append(stack.stackSize).append("\n");
            if (isComplete || progress[i] >= stack.stackSize) {
                sb.append(TextFormatting.GREEN).append(QuestTranslation.translate("betterquesting.tooltip.complete", new Object[0]));
            } else {
                sb.append(TextFormatting.RED).append(QuestTranslation.translate("betterquesting.tooltip.incomplete", new Object[0]));
            }
            PanelTextBox text = new PanelTextBox(new GuiRectangle(36, i * 28 + 24, listW - 36, 28, 0), sb.toString());
            text.setColor(PresetColor.TEXT_MAIN.getColor());
            this.addPanel(text);
        }
        this.recalculateSizes();
    }
}

