/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui2.editors.tasks;

import betterquesting.EnumUtil;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.misc.IVolatileScreen;
import betterquesting.api.enums.EnumLogic;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuest;
import betterquesting.api2.client.gui.GuiScreenCanvas;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.controls.buttons.PanelButtonBoolean;
import betterquesting.api2.client.gui.controls.buttons.PanelButtonEnum;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.panels.lists.CanvasScrollingNameValue;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.client.gui2.editors.nbt.GuiNbtEditor;
import betterquesting.questing.tasks.TaskRetrieval;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;

public class GuiEditTaskRetrieval
extends GuiScreenCanvas
implements IVolatileScreen {
    private final DBEntry<IQuest> quest;
    private final TaskRetrieval task;
    private NBTTagCompound current;
    private static final ResourceLocation QUEST_EDIT = new ResourceLocation("betterquesting", "quest_edit");

    public GuiEditTaskRetrieval(GuiScreen parent, DBEntry<IQuest> quest, TaskRetrieval task) {
        super(parent);
        this.quest = quest;
        this.task = task;
        this.current = task.writeToNBT(new NBTTagCompound());
    }

    @Override
    public void initPanel() {
        super.initPanel();
        Keyboard.enableRepeatEvents((boolean)true);
        CanvasTextured cvBackground = new CanvasTextured(new GuiTransform(), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel(cvBackground);
        cvBackground.addPanel(new PanelTextBox(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(16, 16, 16, -32), 0), QuestTranslation.translate("bq_standard.title.edit_retrieval_task", new Object[0])).setAlignment(1).setColor(PresetColor.TEXT_HEADER.getColor()));
        CanvasScrollingNameValue cvList = new CanvasScrollingNameValue(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(16, 32, 24, 48), 0));
        cvBackground.addPanel(cvList);
        this.initItems(cvList);
        PanelVScrollBar scList = new PanelVScrollBar(new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(-24, 32, 16, 48), 0));
        cvBackground.addPanel(scList);
        cvList.setScrollDriverY(scList);
        PanelButton btnEditNBT = new PanelButton(new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -36, 200, 16, 0), -1, QuestTranslation.translate("bq_standard.btn.edit_nbt", new Object[0]));
        btnEditNBT.setClickAction(btn -> this.field_146297_k.func_147108_a((GuiScreen)new GuiNbtEditor((GuiScreen)this, this.current, value -> {
            this.current = value;
        })));
        cvBackground.addPanel(btnEditNBT);
        cvBackground.addPanel(new PanelButton(new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -16, 200, 16, 0), -1, QuestTranslation.translate("gui.done", new Object[0])){

            @Override
            public void onButtonClick() {
                GuiEditTaskRetrieval.this.task.readFromNBT(GuiEditTaskRetrieval.this.current);
                GuiEditTaskRetrieval.this.sendChanges();
                GuiEditTaskRetrieval.this.field_146297_k.func_147108_a(GuiEditTaskRetrieval.this.parent);
            }
        });
    }

    private void initItems(CanvasScrollingNameValue cvList) {
        this.addBoolean("autoConsume", cvList);
        this.addBoolean("consume", cvList);
        cvList.addPanel("entryLogic", rect -> new PanelButtonEnum<EnumLogic>((IGuiRect)rect, -1, EnumUtil.getEnum(this.current.func_74779_i("entryLogic"), EnumLogic.AND)).setCallback(value -> this.current.func_74778_a("entryLogic", value.name())));
        this.addBoolean("groupDetect", cvList);
        this.addBoolean("ignoreNBT", cvList);
        this.addBoolean("partialMatch", cvList);
        cvList.addPanel("requiredItems", rect -> new PanelButton((IGuiRect)rect, -1, "List...").setClickAction(b -> this.field_146297_k.func_147108_a((GuiScreen)new GuiNbtEditor(this.field_146297_k.field_71462_r, (NBTTagList)this.current.func_74781_a("requiredItems"), null))));
    }

    private void addBoolean(String name, CanvasScrollingNameValue cvList) {
        cvList.addPanel(name, rect -> new PanelButtonBoolean((IGuiRect)rect, -1, this.current.func_74767_n(name)).setCallback(value -> this.current.func_74757_a(name, value.booleanValue())));
    }

    private void sendChanges() {
        NBTTagCompound payload = new NBTTagCompound();
        NBTTagList dataList = new NBTTagList();
        NBTTagCompound entry = new NBTTagCompound();
        entry.func_74768_a("questID", this.quest.getID());
        entry.func_74782_a("config", (NBTBase)this.quest.getValue().writeToNBT(new NBTTagCompound()));
        dataList.func_74742_a((NBTBase)entry);
        payload.func_74782_a("data", (NBTBase)dataList);
        payload.func_74768_a("action", 0);
        QuestingAPI.getAPI(ApiReference.PACKET_SENDER).sendToServer(new QuestingPacket(QUEST_EDIT, payload));
    }
}

