/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui2.editors.nbt;

import betterquesting.api.client.gui.misc.IVolatileScreen;
import betterquesting.api.enums.EnumFrameType;
import betterquesting.api.enums.EnumQuestState;
import betterquesting.api.misc.ICallback;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.client.gui.GuiScreenCanvas;
import betterquesting.api2.client.gui.controls.IPanelButton;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.events.IPEventListener;
import betterquesting.api2.client.gui.events.PEventBroadcaster;
import betterquesting.api2.client.gui.events.PanelEvent;
import betterquesting.api2.client.gui.events.types.PEventButton;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.panels.lists.CanvasQuestFrame;
import betterquesting.api2.client.gui.resources.textures.GuiTextureColored;
import betterquesting.api2.client.gui.resources.textures.ItemTexture;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.utils.QuestTranslation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.input.Keyboard;
import org.lwjgl.util.vector.Vector4f;

public class GuiQuestFrameSelection
extends GuiScreenCanvas
implements IPEventListener,
IVolatileScreen {
    private final ICallback<EnumFrameType> callback;
    private final BigItemStack itemStack;
    private final List<PanelQuest> questStateButtons = new ArrayList<PanelQuest>();
    private EnumFrameType frameType;
    private CanvasQuestFrame cvQuestFrame;

    public GuiQuestFrameSelection(GuiScreen parent, EnumFrameType frameType, BigItemStack itemStack, ICallback<EnumFrameType> callback) {
        super(parent);
        this.frameType = frameType;
        this.itemStack = itemStack;
        this.callback = callback;
    }

    @Override
    public void initPanel() {
        super.initPanel();
        PEventBroadcaster.INSTANCE.register(this, PEventButton.class);
        Keyboard.enableRepeatEvents((boolean)true);
        CanvasTextured cvBackground = new CanvasTextured(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel(cvBackground);
        cvBackground.addPanel(new PanelButton(new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -16, 200, 16, 0), 0, QuestTranslation.translate("gui.done", new Object[0])));
        PanelTextBox txTitle = new PanelTextBox(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 16, 0, -32), 0), QuestTranslation.translate("betterquesting.title.select_item", new Object[0])).setAlignment(1);
        txTitle.setColor(PresetColor.TEXT_HEADER.getColor());
        cvBackground.addPanel(txTitle);
        CanvasEmpty cvLeft = new CanvasEmpty(new GuiTransform(new Vector4f(0.0f, 0.0f, 0.2f, 1.0f), new GuiPadding(16, 32, 8, 8), 0));
        cvBackground.addPanel(cvLeft);
        PanelTextBox txSelection = new PanelTextBox(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 0, 0, -16), 0), QuestTranslation.translate("betterquesting.gui.selection", new Object[0]));
        txSelection.setColor(PresetColor.TEXT_MAIN.getColor());
        cvLeft.addPanel(txSelection);
        EnumQuestState[] values = EnumQuestState.values();
        for (int i = 0; i < values.length; ++i) {
            EnumQuestState value = values[i];
            PanelQuest quest = new PanelQuest(new GuiTransform(GuiAlign.TOP_LEFT, 36 * (i % 2), 16 + i / 2 * 36, 36, 36, 0), 99, this.itemStack, this.frameType, value);
            quest.setTooltip(Collections.singletonList(value.toString()));
            quest.setClickAction(b -> this.cvQuestFrame.setQuestState(((PanelQuest)b).questState));
            cvLeft.addPanel(quest);
            this.questStateButtons.add(quest);
        }
        CanvasEmpty cvRight = new CanvasEmpty(new GuiTransform(new Vector4f(0.3f, 0.0f, 1.0f, 1.0f), new GuiPadding(8, 32, 16, 32), 0));
        cvBackground.addPanel(cvRight);
        this.cvQuestFrame = new CanvasQuestFrame(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 16, 8, 0), 0), 1);
        cvRight.addPanel(this.cvQuestFrame);
        PanelVScrollBar scEdit = new PanelVScrollBar(new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(-8, 16, 0, 0), 0));
        this.cvQuestFrame.setScrollDriverY(scEdit);
        cvRight.addPanel(scEdit);
    }

    @Override
    public void onPanelEvent(PanelEvent event) {
        if (event instanceof PEventButton) {
            this.onButtonPress((PEventButton)event);
        }
    }

    private void onButtonPress(PEventButton event) {
        EnumFrameType tmp;
        IPanelButton btn = event.getButton();
        if (btn.getButtonID() == 0) {
            if (this.callback != null) {
                this.callback.setValue(this.frameType);
            }
            this.field_146297_k.func_147108_a(this.parent);
        } else if (btn.getButtonID() == 1 && btn instanceof PanelButtonStorage && (tmp = (EnumFrameType)((Object)((PanelButtonStorage)btn).getStoredValue())) != null) {
            this.frameType = tmp;
            this.questStateButtons.forEach(x -> x.setFrameType(this.frameType));
        }
    }

    private static class PanelQuest
    extends PanelButton {
        private EnumFrameType frameType;
        private EnumQuestState questState;

        public PanelQuest(IGuiRect rect, int id, BigItemStack itemStack, EnumFrameType frameType, EnumQuestState questState) {
            super(rect, id, "");
            this.frameType = frameType;
            this.questState = questState;
            this.updateTexture();
            this.setIcon(new ItemTexture(itemStack, false, true), 6);
            this.setActive(true);
        }

        public void setFrameType(EnumFrameType frameType) {
            this.frameType = frameType;
            this.updateTexture();
        }

        public void setQuestState(EnumQuestState questState) {
            this.questState = questState;
            this.updateTexture();
        }

        private void updateTexture() {
            GuiTextureColored texture = new GuiTextureColored(PresetTexture.getExtraQuestFrameTexture(this.frameType, this.questState), this.questState.getColor());
            this.setTextures(texture, texture, texture);
        }
    }
}

