/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui2.editors;

import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.client.gui2.editors.GuiQuestDescEditor;
import betterquesting.client.gui2.editors.GuiQuestEditor;
import betterquesting.core.BetterQuesting;
import betterquesting.questing.QuestDatabase;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class TextEditorFrame
extends JFrame {
    private static final int initialRowCount = 30;
    private static final int defaultColumns = 60;
    private static BufferedImage logoCache = null;
    private static final IntObjectMap<TextEditorFrame> open = new IntObjectHashMap();
    private final int questID;
    private final JTextField nameText;
    private final JButton close;
    private final JTextArea descText;
    @Nullable
    private GuiQuestDescEditor gui = null;
    private boolean valueChangedByGuiScreen = false;
    private boolean byTopCornerCloseButton = true;

    @Nullable
    public static TextEditorFrame get(int questID) {
        return (TextEditorFrame)open.get(questID);
    }

    public static TextEditorFrame getOrCreate(int questID, String title, String name, String description) {
        if (open.containsKey(questID)) {
            return (TextEditorFrame)open.get(questID);
        }
        TextEditorFrame frame = new TextEditorFrame(questID, title, name, description);
        open.put(questID, (Object)frame);
        return frame;
    }

    private TextEditorFrame(final int questID, String title, String name, String description) {
        super("Better Questing Text Editor | " + title);
        this.questID = questID;
        TextEditorFrame.initLogoCache();
        if (logoCache != null) {
            this.setIconImage(logoCache);
        }
        this.setResizable(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (TextEditorFrame.this.byTopCornerCloseButton) {
                    if (TextEditorFrame.this.gui == null) {
                        TextEditorFrame.this.cancel();
                    } else {
                        TextEditorFrame.this.gui.cancel();
                    }
                } else {
                    open.remove(questID);
                    TextEditorFrame.this.setVisible(false);
                    TextEditorFrame.this.dispose();
                }
            }
        });
        JPanel wholePanel = new JPanel();
        wholePanel.setLayout(new BoxLayout(wholePanel, 1));
        JPanel editorPanel = TextEditorFrame.add(wholePanel, new JPanel());
        editorPanel.setLayout(new BoxLayout(editorPanel, 0));
        JPanel buttonPanel = new JPanel();
        TextEditorFrame.add(editorPanel, new JScrollPane(buttonPanel, 22, 30));
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        buttonPanel.setBorder(new TitledBorder(BorderFactory.createLineBorder(Color.GRAY, 1, true), QuestTranslation.translate("betterquesting.gui.formatting_buttons", new Object[0])));
        this.addAllFormattingCodes(buttonPanel);
        JPanel textPanel = TextEditorFrame.add(editorPanel, new JPanel());
        textPanel.setLayout(new BoxLayout(textPanel, 1));
        this.nameText = TextEditorFrame.add(textPanel, new JTextField(name, 60));
        this.nameText.setBorder(new TitledBorder(BorderFactory.createLineBorder(Color.GRAY, 1, true), QuestTranslation.translate("betterquesting.gui.name", new Object[0])));
        this.nameText.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
        this.nameText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (TextEditorFrame.this.gui == null) {
                    return;
                }
                if (TextEditorFrame.this.valueChangedByGuiScreen) {
                    return;
                }
                TextEditorFrame.this.gui.removeName(e.getOffset(), e.getLength());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                String text;
                if (TextEditorFrame.this.gui == null) {
                    return;
                }
                if (TextEditorFrame.this.valueChangedByGuiScreen) {
                    return;
                }
                Document doc = e.getDocument();
                try {
                    text = doc.getText(e.getOffset(), e.getLength());
                }
                catch (BadLocationException ex) {
                    return;
                }
                TextEditorFrame.this.gui.insertName(e.getOffset(), text);
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
            }
        });
        UndoHelper.addUndoHelper(this.nameText);
        this.descText = new JTextArea(description, 30, 60);
        JScrollPane scroll = TextEditorFrame.add(textPanel, new JScrollPane(this.descText, 22, 30));
        scroll.setRowHeaderView(new LineNumberView(this.descText));
        this.descText.setBorder(new TitledBorder(BorderFactory.createLineBorder(Color.GRAY, 1, true), QuestTranslation.translate("betterquesting.gui.description", new Object[0])));
        this.descText.setLineWrap(true);
        this.descText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (TextEditorFrame.this.gui == null) {
                    return;
                }
                if (TextEditorFrame.this.valueChangedByGuiScreen) {
                    return;
                }
                TextEditorFrame.this.gui.removeDesc(e.getOffset(), e.getLength());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                String text;
                if (TextEditorFrame.this.gui == null) {
                    return;
                }
                if (TextEditorFrame.this.valueChangedByGuiScreen) {
                    return;
                }
                Document doc = e.getDocument();
                try {
                    text = doc.getText(e.getOffset(), e.getLength());
                }
                catch (BadLocationException ex) {
                    return;
                }
                TextEditorFrame.this.gui.insertDesc(e.getOffset(), text);
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
            }
        });
        UndoHelper.addUndoHelper(this.descText);
        JPanel footerPanel = TextEditorFrame.add(wholePanel, new JPanel());
        footerPanel.setLayout(new FlowLayout(1, 20, 10));
        footerPanel.setMinimumSize(new Dimension(Integer.MAX_VALUE, 50));
        footerPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 50));
        JButton cancel = TextEditorFrame.add(footerPanel, new JButton(QuestTranslation.translate("gui.cancel", new Object[0])));
        cancel.setMinimumSize(new Dimension(90, 0));
        cancel.addActionListener(this::cancelClicked);
        this.close = TextEditorFrame.add(footerPanel, new JButton(QuestTranslation.translate("betterquesting.btn.edit_name_desc.just_close", new Object[0])));
        this.close.setMinimumSize(new Dimension(90, 0));
        this.close.addActionListener(this::closeClicked);
        this.close.setToolTipText(QuestTranslation.translate("betterquesting.tooltip.edit_name_desc.just_close_window", new Object[0]));
        JButton done = TextEditorFrame.add(footerPanel, new JButton(QuestTranslation.translate("gui.done", new Object[0])));
        done.addActionListener(this::doneClicked);
        done.setMinimumSize(new Dimension(90, 0));
        this.setContentPane(wholePanel);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public void setGui(@Nullable GuiQuestDescEditor gui) {
        this.gui = gui;
        this.close.setEnabled(gui != null);
    }

    public void close() {
        this.byTopCornerCloseButton = false;
        this.dispatchEvent(new WindowEvent(this, 201));
        this.byTopCornerCloseButton = true;
    }

    @Override
    public String getName() {
        return this.nameText.getText();
    }

    public String getDesc() {
        return this.descText.getText();
    }

    public void setDesc(String desc) {
        SwingUtilities.invokeLater(() -> {
            this.valueChangedByGuiScreen = true;
            int caretPos = this.descText.getCaretPosition();
            this.descText.setText(desc);
            this.descText.setCaretPosition(caretPos);
            this.valueChangedByGuiScreen = false;
        });
    }

    private void cancelClicked(ActionEvent event) {
        if (this.gui != null) {
            this.gui.cancel();
        } else {
            this.cancel();
        }
    }

    private void closeClicked(ActionEvent event) {
        if (this.gui != null) {
            this.gui.removeWindow();
        } else {
            this.close();
        }
    }

    private void doneClicked(ActionEvent event) {
        if (this.gui != null) {
            this.gui.saveAndClose();
        } else {
            this.saveAndClose();
        }
    }

    private void cancel() {
        this.close();
    }

    private void saveAndClose() {
        IQuest quest = (IQuest)QuestDatabase.INSTANCE.getValue(this.questID);
        quest.setProperty(NativeProps.NAME, this.getName().trim());
        quest.setProperty(NativeProps.DESC, this.getDesc());
        GuiQuestEditor.sendChanges(this.questID);
        this.close();
    }

    private void addAllFormattingCodes(JPanel panel) {
        for (TextFormatting value : TextFormatting.values()) {
            JButton btn = new JButton(value.func_96297_d());
            btn.setToolTipText(value.toString());
            btn.addActionListener(this.addFormattingCode(value));
            btn.setMinimumSize(new Dimension(80, 30));
            btn.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
            TextEditorFrame.add(panel, btn);
        }
    }

    private ActionListener addFormattingCode(TextFormatting textFormatting) {
        return event -> this.descText.replaceRange(textFormatting.toString(), this.descText.getSelectionStart(), this.descText.getSelectionEnd());
    }

    private static void initLogoCache() {
        if (logoCache == null) {
            try (InputStream stream = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("betterquesting", "textures/items/quest_book.png")).func_110527_b();){
                logoCache = ImageIO.read(stream);
            }
            catch (Exception ex) {
                BetterQuesting.logger.error((Object)ex);
            }
        }
    }

    private static <T extends Component> T add(JPanel panel, T component) {
        panel.add(component);
        return component;
    }

    private static class UndoHelper {
        public static final String ACTION_KEY_UNDO = "undo";
        public static final String ACTION_KEY_REDO = "redo";
        private final UndoManager undoManager = new UndoManager();

        public static void addUndoHelper(JTextComponent textComponent) {
            new UndoHelper(textComponent);
        }

        private UndoHelper(JTextComponent textComponent) {
            ActionMap amap = textComponent.getActionMap();
            InputMap imap = textComponent.getInputMap();
            if (amap.get(ACTION_KEY_UNDO) == null) {
                UndoAction undoAction = new UndoAction();
                amap.put(ACTION_KEY_UNDO, undoAction);
                imap.put((KeyStroke)undoAction.getValue("AcceleratorKey"), ACTION_KEY_UNDO);
            }
            if (amap.get(ACTION_KEY_REDO) == null) {
                RedoAction redoAction = new RedoAction();
                amap.put(ACTION_KEY_REDO, redoAction);
                imap.put((KeyStroke)redoAction.getValue("AcceleratorKey"), ACTION_KEY_REDO);
            }
            textComponent.getDocument().addDocumentListener(new DocListener());
        }

        class UndoAction
        extends AbstractAction {
            UndoAction() {
                super("Undo(U)");
                this.putValue("MnemonicKey", 85);
                this.putValue("ShortDescription", "Undo");
                this.putValue("LongDescription", "Undo");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, 128));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UndoHelper.this.undoManager.canUndo()) {
                    UndoHelper.this.undoManager.undo();
                }
            }
        }

        class RedoAction
        extends AbstractAction {
            RedoAction() {
                super("Redo(R)");
                this.putValue("MnemonicKey", 82);
                this.putValue("ShortDescription", "Redo");
                this.putValue("LongDescription", "Redo");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, 128));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UndoHelper.this.undoManager.canRedo()) {
                    UndoHelper.this.undoManager.redo();
                }
            }
        }

        private class DocListener
        implements DocumentListener {
            private DocListener() {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (e instanceof AbstractDocument.DefaultDocumentEvent) {
                    AbstractDocument.DefaultDocumentEvent de = (AbstractDocument.DefaultDocumentEvent)e;
                    UndoHelper.this.undoManager.addEdit(de);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (e instanceof AbstractDocument.DefaultDocumentEvent) {
                    AbstractDocument.DefaultDocumentEvent de = (AbstractDocument.DefaultDocumentEvent)e;
                    UndoHelper.this.undoManager.addEdit(de);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        }
    }

    private static class LineNumberView
    extends JPanel {
        private static final int LINE_NUMBER_MARGIN = 5;
        private final JTextArea textArea;

        public LineNumberView(JTextArea textArea) {
            this.textArea = textArea;
            textArea.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.repaint();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.repaint();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            });
            textArea.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    this.revalidate();
                    this.repaint();
                }
            });
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setOpaque(true);
            EventQueue.invokeLater(() -> {
                Insets i = this.textArea.getMargin();
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.GRAY), BorderFactory.createEmptyBorder(i.top, 5, i.bottom, 4)));
                this.setBackground(this.textArea.getBackground());
            });
        }

        @Override
        public Dimension getPreferredSize() {
            FontMetrics fontMetrics = this.textArea.getFontMetrics(this.textArea.getFont());
            return new Dimension(this.getComponentWidth(fontMetrics), this.textArea.getHeight());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                g2.setColor(this.textArea.getBackground());
                Rectangle clip = g2.getClipBounds();
                g2.fillRect(clip.x, clip.y, clip.width, clip.height);
                Font font = this.textArea.getFont();
                g2.setFont(font);
                FontMetrics fontMetrics = g2.getFontMetrics(font);
                int fontAscent = fontMetrics.getAscent();
                int fontDescent = fontMetrics.getDescent();
                int fontLeading = fontMetrics.getLeading();
                int fontHeight = fontMetrics.getHeight();
                int componentWidth = this.getComponentWidth(fontMetrics);
                int rMargin = this.getInsets().right;
                int base = clip.y;
                int start = this.getLineAtPoint(base);
                int end = this.getLineAtPoint(base + clip.height);
                int y = this.textArea.getBorder().getBorderInsets((Component)this.textArea).top;
                y += start * fontHeight;
                g2.setColor(this.getForeground());
                int line = start;
                while (line <= end) {
                    if (line <= this.getLineAtPoint(y += fontAscent)) {
                        String text = Integer.toString(line + 1);
                        int x = componentWidth - rMargin - fontMetrics.stringWidth(text);
                        g2.drawString(text, x, y);
                        ++line;
                    }
                    y += fontDescent + fontLeading;
                }
            }
            finally {
                g2.dispose();
            }
        }

        private int getLineAtPoint(int y) {
            Element root = this.textArea.getDocument().getDefaultRootElement();
            int pos = this.textArea.viewToModel(new Point(0, y));
            return root.getElementIndex(pos);
        }

        private int getComponentWidth(FontMetrics fontMetrics) {
            int maxDigits = Math.max(2, Integer.toString(this.textArea.getLineCount()).length());
            Insets insets = this.getInsets();
            return maxDigits * fontMetrics.stringWidth("0") + insets.left + insets.right;
        }
    }
}

