/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui2.editors;

import betterquesting.api.client.gui.misc.IVolatileScreen;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api2.client.gui.GuiScreenCanvas;
import betterquesting.api2.client.gui.controls.IPanelButton;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.controls.PanelTextField;
import betterquesting.api2.client.gui.controls.filters.FieldFilterString;
import betterquesting.api2.client.gui.events.IPEventListener;
import betterquesting.api2.client.gui.events.PEventBroadcaster;
import betterquesting.api2.client.gui.events.PanelEvent;
import betterquesting.api2.client.gui.events.types.PEventButton;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.panels.lists.CanvasScrolling;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.client.gui2.editors.GuiQuestEditor;
import betterquesting.client.gui2.editors.TextEditorFrame;
import com.google.common.collect.Lists;
import javax.annotation.Nullable;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Keyboard;

public class GuiQuestDescEditor
extends GuiScreenCanvas
implements IPEventListener,
IVolatileScreen {
    private static final boolean FORCE_OPEN_WINDOW = true;
    private final int questID;
    private final IQuest quest;
    private final String beforeName;
    private final String beforeDesc;
    private String name;
    private PanelTextField<String> description;
    private PanelButton close;
    @Nullable
    private TextEditorFrame window;

    public GuiQuestDescEditor(GuiQuestEditor parent, int questID, IQuest quest) {
        super(parent);
        this.questID = questID;
        this.quest = quest;
        this.beforeName = quest.getProperty(NativeProps.NAME);
        this.beforeDesc = quest.getProperty(NativeProps.DESC);
        TextEditorFrame window = TextEditorFrame.get(questID);
        if (window == null) {
            window = TextEditorFrame.getOrCreate(questID, this.beforeName, this.beforeName, this.beforeDesc);
        }
        if (window != null) {
            this.window = window;
            window.setGui(this);
            window.toFront();
            window.requestFocus();
            if (this.close != null) {
                this.close.setActive(true);
            }
            this.name = window.getName();
        } else {
            this.name = this.beforeName;
        }
    }

    public void showWindow() {
        if (this.window == null) {
            this.window = TextEditorFrame.getOrCreate(this.questID, this.beforeName, this.name, this.description.getRawText());
        }
        this.window.setGui(this);
        this.window.toFront();
        this.window.requestFocus();
        if (this.close != null) {
            this.close.setActive(true);
        }
    }

    public void removeWindow() {
        if (this.window == null) {
            return;
        }
        this.window.close();
        this.window = null;
        if (this.close != null) {
            this.close.setActive(false);
        }
    }

    public void close() {
        this.field_146297_k.func_147108_a(this.parent);
    }

    public void saveAndClose() {
        this.quest.setProperty(NativeProps.NAME, this.name.trim());
        this.quest.setProperty(NativeProps.DESC, this.description.getRawText());
        GuiQuestEditor.sendChanges(this.questID);
        this.removeWindow();
        this.close();
    }

    public void cancel() {
        this.removeWindow();
        this.close();
    }

    public void insertName(int offset, String insertText) {
        String text = this.name;
        this.name = text.substring(0, offset) + insertText + text.substring(offset);
    }

    public void removeName(int offset, int length) {
        String text = this.name;
        this.name = text.substring(0, offset) + text.substring(offset + length);
    }

    public void insertDesc(int offset, String insertText) {
        String text = this.description.getRawText();
        this.description.setText(text.substring(0, offset) + insertText + text.substring(offset));
    }

    public void removeDesc(int offset, int length) {
        String text = this.description.getRawText();
        this.description.setText(text.substring(0, offset) + text.substring(offset + length));
    }

    @Override
    public void initPanel() {
        super.initPanel();
        PEventBroadcaster.INSTANCE.register(this, PEventButton.class);
        Keyboard.enableRepeatEvents((boolean)true);
        CanvasTextured cvBackground = new CanvasTextured(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel(cvBackground);
        this.close = new PanelButton(new GuiTransform(GuiAlign.BOTTOM_CENTER, -40, -16, 80, 16, 0), 0, QuestTranslation.translate("betterquesting.btn.edit_name_desc.just_close", new Object[0]));
        this.close.setTooltip(Lists.newArrayList((Object[])new String[]{QuestTranslation.translate("betterquesting.tooltip.edit_name_desc.just_close_screen", new Object[0])}));
        this.close.setActive(this.window != null);
        cvBackground.addPanel(this.close);
        cvBackground.addPanel(new PanelButton(new GuiTransform(GuiAlign.BOTTOM_LEFT, 20, -16, 80, 16, 0), 1, QuestTranslation.translate("gui.cancel", new Object[0])));
        cvBackground.addPanel(new PanelButton(new GuiTransform(GuiAlign.BOTTOM_RIGHT, -100, -16, 80, 16, 0), 2, QuestTranslation.translate("gui.done", new Object[0])));
        PanelTextBox txTitle = new PanelTextBox(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 16, 0, -32), 0), QuestTranslation.translate("betterquesting.title.edit_quest", new Object[0])).setAlignment(1);
        txTitle.setColor(PresetColor.TEXT_HEADER.getColor());
        cvBackground.addPanel(txTitle);
        cvBackground.addPanel(new PanelButton(new GuiTransform(GuiAlign.TOP_RIGHT, -110, 8, 100, 16, 0), 3, QuestTranslation.translate("betterquesting.btn.edit_name_desc.open_window", new Object[0])));
        this.description = new PanelTextField<String>(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(124, 32, 24, 32), 0), this.description != null ? this.description.getRawText() : (this.window != null ? this.window.getDesc() : this.beforeDesc), FieldFilterString.INSTANCE);
        cvBackground.addPanel(this.description);
        this.description.setMaxLength(Integer.MAX_VALUE);
        this.description.enableWrapping(true);
        this.description.lockFocus(true);
        this.description.setCallback(this::updateWindowDesc);
        CanvasScrolling cvFormatList = new CanvasScrolling(new GuiTransform(GuiAlign.LEFT_EDGE, new GuiPadding(16, 32, -116, 32), 0));
        cvBackground.addPanel(cvFormatList);
        TextFormatting[] tfValues = TextFormatting.values();
        for (int i = 0; i < tfValues.length; ++i) {
            cvFormatList.addPanel(new PanelButtonStorage<String>(new GuiRectangle(0, i * 16, 100, 16), 10, tfValues[i].func_96297_d(), tfValues[i].toString()));
        }
        PanelVScrollBar scFormatScroll = new PanelVScrollBar(new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(0, 0, -8, 0), 0));
        cvBackground.addPanel(scFormatScroll);
        scFormatScroll.getTransform().setParent(cvFormatList.getTransform());
        cvFormatList.setScrollDriverY(scFormatScroll);
        scFormatScroll.setActive(cvFormatList.getScrollBounds().getHeight() > 0);
    }

    @Override
    public void func_146281_b() {
        if (this.window != null) {
            this.window.setGui(null);
        }
        super.func_146281_b();
    }

    @Override
    public void onPanelEvent(PanelEvent event) {
        if (event instanceof PEventButton) {
            this.onButtonPress((PEventButton)event);
        }
    }

    private void onButtonPress(PEventButton event) {
        IPanelButton btn = event.getButton();
        switch (btn.getButtonID()) {
            case 0: {
                if (this.window == null) {
                    this.cancel();
                    break;
                }
                this.close();
                break;
            }
            case 1: {
                this.cancel();
                break;
            }
            case 2: {
                this.saveAndClose();
                break;
            }
            case 3: {
                this.showWindow();
                break;
            }
            case 10: {
                if (!(btn instanceof PanelButtonStorage)) break;
                String format = (String)((PanelButtonStorage)btn).getStoredValue();
                this.description.writeText(format);
            }
        }
    }

    private void updateWindowDesc(String value) {
        if (this.window != null) {
            this.window.setDesc(value);
        }
    }
}

