/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.storage;

import betterquesting.api2.storage.AbstractDatabase;
import betterquesting.api2.storage.DBEntry;
import java.util.BitSet;

public class SimpleDatabase<T>
extends AbstractDatabase<T> {
    private final BitSet idMap = new BitSet();

    @Override
    public synchronized int nextID() {
        return this.idMap.nextClearBit(0);
    }

    @Override
    public synchronized DBEntry<T> add(int id, T value) {
        DBEntry<T> result = super.add(id, value);
        this.idMap.set(id);
        return result;
    }

    @Override
    public synchronized boolean removeID(int key) {
        boolean result = super.removeID(key);
        if (result) {
            this.idMap.clear(key);
        }
        return result;
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.idMap.clear();
    }
}

