/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.storage;

import betterquesting.api2.storage.AbstractDatabase;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.LookupLogic;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;

class NaiveLookupLogic<T>
extends LookupLogic<T> {
    private TIntObjectMap<DBEntry<T>> backingMap;

    public NaiveLookupLogic(AbstractDatabase<T> abstractDatabase) {
        super(abstractDatabase);
    }

    @Override
    public void onDataChange() {
        super.onDataChange();
        this.backingMap = null;
    }

    @Override
    public List<DBEntry<T>> bulkLookup(int[] keys) {
        if (this.backingMap == null) {
            this.backingMap = new TIntObjectHashMap(this.abstractDatabase.mapDB.size());
            for (DBEntry entry : this.getRefCache()) {
                this.backingMap.put(entry.getID(), entry);
            }
        }
        ArrayList<DBEntry<T>> list = new ArrayList<DBEntry<T>>(keys.length);
        for (int k : keys) {
            DBEntry element = (DBEntry)this.backingMap.get(k);
            if (element == null) continue;
            list.add(element);
        }
        return list;
    }
}

