/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.storage;

import betterquesting.api2.storage.AbstractDatabase;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.LookupLogic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

class ArrayCacheLookupLogic<T>
extends LookupLogic<T> {
    private DBEntry<T>[] cache = null;
    private int offset = -1;

    public ArrayCacheLookupLogic(AbstractDatabase<T> abstractDatabase) {
        super(abstractDatabase);
    }

    @Override
    public void onDataChange() {
        super.onDataChange();
        this.cache = null;
        this.offset = -1;
    }

    @Override
    public List<DBEntry<T>> getRefCache() {
        if (this.refCache != null) {
            return this.refCache;
        }
        if (this.cache == null) {
            return super.getRefCache();
        }
        this.refCache = Arrays.stream(this.cache).filter(Objects::nonNull).collect(Collectors.toList());
        return this.refCache;
    }

    @Override
    public List<DBEntry<T>> bulkLookup(int[] keys) {
        this.computeCache();
        ArrayList<DBEntry<T>> list = new ArrayList<DBEntry<T>>(keys.length);
        for (int k : keys) {
            DBEntry<T> element;
            if (k - this.offset >= this.cache.length || (element = this.cache[k - this.offset]) == null) continue;
            list.add(element);
        }
        return list;
    }

    private void computeCache() {
        if (this.cache != null) {
            return;
        }
        this.cache = new DBEntry[this.abstractDatabase.mapDB.lastKey() - this.abstractDatabase.mapDB.firstKey() + 1];
        this.offset = this.abstractDatabase.mapDB.firstKey();
        if (this.refCache == null) {
            for (Map.Entry entry : this.abstractDatabase.mapDB.entrySet()) {
                this.cache[entry.getKey().intValue() - this.offset] = new DBEntry(entry.getKey(), entry.getValue());
            }
        } else {
            Iterator iterator = this.refCache.iterator();
            while (iterator.hasNext()) {
                DBEntry entry;
                this.cache[entry.getID() - this.offset] = entry = (DBEntry)iterator.next();
            }
        }
    }
}

