/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.resources.textures;

import betterquesting.api.utils.JsonHelper;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.resources.colors.GuiColorStatic;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import com.google.gson.JsonObject;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiUtils;

public class SlicedTexture
implements IGuiTexture {
    private static final IGuiColor defColor = new GuiColorStatic(255, 255, 255, 255);
    private final ResourceLocation texture;
    private final IGuiRect texBounds;
    private final GuiPadding texBorder;
    private SliceMode sliceMode = SliceMode.SLICED_TILE;

    public SlicedTexture(ResourceLocation tex, IGuiRect bounds, GuiPadding border) {
        this.texture = tex;
        this.texBounds = bounds;
        this.texBorder = border;
    }

    @Override
    public void drawTexture(int x, int y, int width, int height, float zLevel, float partialTick) {
        this.drawTexture(x, y, width, height, zLevel, partialTick, defColor);
    }

    @Override
    public void drawTexture(int x, int y, int width, int height, float zLevel, float partialTick, IGuiColor color) {
        if (width <= 0 || height <= 0) {
            return;
        }
        int w = Math.max(width, this.texBorder.getLeft() + this.texBorder.getRight());
        int h = Math.max(height, this.texBorder.getTop() + this.texBorder.getBottom());
        int dx = x;
        int dy = y;
        GlStateManager.func_179094_E();
        color.applyGlColor();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        if (w != width || h != height) {
            dx = 0;
            dy = 0;
            GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
            GlStateManager.func_179139_a((double)((double)width / (double)w), (double)((double)height / (double)h), (double)1.0);
        }
        if (this.sliceMode == SliceMode.SLICED_TILE) {
            SlicedTexture.drawContinuousTexturedBox(this.texture, dx, dy, this.texBounds.getX(), this.texBounds.getY(), w, h, this.texBounds.getWidth(), this.texBounds.getHeight(), this.texBorder.getTop(), this.texBorder.getBottom(), this.texBorder.getLeft(), this.texBorder.getRight(), zLevel);
        } else if (this.sliceMode == SliceMode.SLICED_STRETCH) {
            int iu = this.texBounds.getX() + this.texBorder.getLeft();
            int iv = this.texBounds.getY() + this.texBorder.getTop();
            int iw = this.texBounds.getWidth() - this.texBorder.getLeft() - this.texBorder.getRight();
            int ih = this.texBounds.getHeight() - this.texBorder.getTop() - this.texBorder.getBottom();
            float sx = (float)(w - (this.texBounds.getWidth() - iw)) / (float)iw;
            float sy = (float)(h - (this.texBounds.getHeight() - ih)) / (float)ih;
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)dx, (float)dy, (float)0.0f);
            GuiUtils.drawTexturedModalRect((int)0, (int)0, (int)this.texBounds.getX(), (int)this.texBounds.getY(), (int)this.texBorder.getLeft(), (int)this.texBorder.getTop(), (float)zLevel);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(dx + this.texBorder.getLeft()), (float)dy, (float)0.0f);
            GlStateManager.func_179152_a((float)sx, (float)1.0f, (float)1.0f);
            GuiUtils.drawTexturedModalRect((int)0, (int)0, (int)(this.texBounds.getX() + this.texBorder.getLeft()), (int)this.texBounds.getY(), (int)iw, (int)this.texBorder.getTop(), (float)zLevel);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(dx + w - this.texBorder.getRight()), (float)dy, (float)0.0f);
            GuiUtils.drawTexturedModalRect((int)0, (int)0, (int)(this.texBounds.getX() + this.texBorder.getLeft() + iw), (int)this.texBounds.getY(), (int)this.texBorder.getRight(), (int)this.texBorder.getTop(), (float)zLevel);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)dx, (float)(dy + this.texBorder.getTop()), (float)0.0f);
            GlStateManager.func_179152_a((float)1.0f, (float)sy, (float)1.0f);
            GuiUtils.drawTexturedModalRect((int)0, (int)0, (int)this.texBounds.getX(), (int)(this.texBounds.getY() + this.texBorder.getTop()), (int)this.texBorder.getLeft(), (int)ih, (float)zLevel);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(dx + this.texBorder.getLeft()), (float)(dy + this.texBorder.getTop()), (float)0.0f);
            GlStateManager.func_179152_a((float)sx, (float)sy, (float)1.0f);
            GuiUtils.drawTexturedModalRect((int)0, (int)0, (int)iu, (int)iv, (int)iw, (int)ih, (float)zLevel);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(dx + w - this.texBorder.getRight()), (float)(dy + this.texBorder.getTop()), (float)0.0f);
            GlStateManager.func_179152_a((float)1.0f, (float)sy, (float)1.0f);
            GuiUtils.drawTexturedModalRect((int)0, (int)0, (int)(this.texBounds.getX() + this.texBorder.getLeft() + iw), (int)(this.texBounds.getY() + this.texBorder.getTop()), (int)this.texBorder.getRight(), (int)ih, (float)zLevel);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)dx, (float)(dy + h - this.texBorder.getBottom()), (float)0.0f);
            GuiUtils.drawTexturedModalRect((int)0, (int)0, (int)this.texBounds.getX(), (int)(this.texBounds.getY() + this.texBorder.getTop() + ih), (int)this.texBorder.getLeft(), (int)this.texBorder.getBottom(), (float)zLevel);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(dx + this.texBorder.getLeft()), (float)(dy + h - this.texBorder.getBottom()), (float)0.0f);
            GlStateManager.func_179152_a((float)sx, (float)1.0f, (float)1.0f);
            GuiUtils.drawTexturedModalRect((int)0, (int)0, (int)(this.texBounds.getX() + this.texBorder.getLeft()), (int)(this.texBounds.getY() + this.texBorder.getTop() + ih), (int)iw, (int)this.texBorder.getBottom(), (float)zLevel);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(dx + w - this.texBorder.getRight()), (float)(dy + h - this.texBorder.getBottom()), (float)0.0f);
            GuiUtils.drawTexturedModalRect((int)0, (int)0, (int)(this.texBounds.getX() + this.texBorder.getLeft() + iw), (int)(this.texBounds.getY() + this.texBorder.getTop() + ih), (int)this.texBorder.getRight(), (int)this.texBorder.getBottom(), (float)zLevel);
            GlStateManager.func_179121_F();
        } else {
            float sx = (float)w / (float)this.texBounds.getWidth();
            float sy = (float)h / (float)this.texBounds.getHeight();
            GlStateManager.func_179109_b((float)dx, (float)dy, (float)0.0f);
            GlStateManager.func_179152_a((float)sx, (float)sy, (float)1.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
            GuiUtils.drawTexturedModalRect((int)0, (int)0, (int)this.texBounds.getX(), (int)this.texBounds.getY(), (int)this.texBounds.getWidth(), (int)this.texBounds.getHeight(), (float)zLevel);
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public ResourceLocation getTexture() {
        return this.texture;
    }

    @Override
    public IGuiRect getBounds() {
        return this.texBounds;
    }

    public GuiPadding getBorder() {
        return this.texBorder;
    }

    public SlicedTexture setSliceMode(SliceMode mode) {
        this.sliceMode = mode;
        return this;
    }

    public static SlicedTexture readFromJson(JsonObject json) {
        ResourceLocation res = new ResourceLocation(JsonHelper.GetString(json, "texture", "minecraft:missingno"));
        int slice = JsonHelper.GetNumber(json, "sliceMode", 1).intValue();
        JsonObject jOut = JsonHelper.GetObject(json, "coordinates");
        int ox = JsonHelper.GetNumber(jOut, "u", 0).intValue();
        int oy = JsonHelper.GetNumber(jOut, "v", 0).intValue();
        int ow = JsonHelper.GetNumber(jOut, "w", 48).intValue();
        int oh = JsonHelper.GetNumber(jOut, "h", 48).intValue();
        JsonObject jIn = JsonHelper.GetObject(json, "border");
        int il = JsonHelper.GetNumber(jIn, "l", 16).intValue();
        int it = JsonHelper.GetNumber(jIn, "t", 16).intValue();
        int ir = JsonHelper.GetNumber(jIn, "r", 16).intValue();
        int ib = JsonHelper.GetNumber(jIn, "b", 16).intValue();
        return new SlicedTexture(res, new GuiRectangle(ox, oy, ow, oh), new GuiPadding(il, it, ir, ib)).setSliceMode(SliceMode.values()[slice % 3]);
    }

    private static void drawContinuousTexturedBox(ResourceLocation res, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int topBorder, int bottomBorder, int leftBorder, int rightBorder, float zLevel) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(res);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        int fillerWidth = textureWidth - leftBorder - rightBorder;
        int fillerHeight = textureHeight - topBorder - bottomBorder;
        if (fillerWidth <= 0 || fillerHeight <= 0) {
            return;
        }
        int canvasWidth = width - leftBorder - rightBorder;
        int canvasHeight = height - topBorder - bottomBorder;
        int xPasses = canvasWidth / fillerWidth;
        int remainderWidth = canvasWidth % fillerWidth;
        int yPasses = canvasHeight / fillerHeight;
        int remainderHeight = canvasHeight % fillerHeight;
        GuiUtils.drawTexturedModalRect((int)x, (int)y, (int)u, (int)v, (int)leftBorder, (int)topBorder, (float)zLevel);
        GuiUtils.drawTexturedModalRect((int)(x + leftBorder + canvasWidth), (int)y, (int)(u + leftBorder + fillerWidth), (int)v, (int)rightBorder, (int)topBorder, (float)zLevel);
        GuiUtils.drawTexturedModalRect((int)x, (int)(y + topBorder + canvasHeight), (int)u, (int)(v + topBorder + fillerHeight), (int)leftBorder, (int)bottomBorder, (float)zLevel);
        GuiUtils.drawTexturedModalRect((int)(x + leftBorder + canvasWidth), (int)(y + topBorder + canvasHeight), (int)(u + leftBorder + fillerWidth), (int)(v + topBorder + fillerHeight), (int)rightBorder, (int)bottomBorder, (float)zLevel);
        for (int i = 0; i < xPasses + (remainderWidth > 0 ? 1 : 0); ++i) {
            GuiUtils.drawTexturedModalRect((int)(x + leftBorder + i * fillerWidth), (int)y, (int)(u + leftBorder), (int)v, (int)(i == xPasses ? remainderWidth : fillerWidth), (int)topBorder, (float)zLevel);
            GuiUtils.drawTexturedModalRect((int)(x + leftBorder + i * fillerWidth), (int)(y + topBorder + canvasHeight), (int)(u + leftBorder), (int)(v + topBorder + fillerHeight), (int)(i == xPasses ? remainderWidth : fillerWidth), (int)bottomBorder, (float)zLevel);
            for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
                GuiUtils.drawTexturedModalRect((int)(x + leftBorder + i * fillerWidth), (int)(y + topBorder + j * fillerHeight), (int)(u + leftBorder), (int)(v + topBorder), (int)(i == xPasses ? remainderWidth : fillerWidth), (int)(j == yPasses ? remainderHeight : fillerHeight), (float)zLevel);
            }
        }
        for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
            GuiUtils.drawTexturedModalRect((int)x, (int)(y + topBorder + j * fillerHeight), (int)u, (int)(v + topBorder), (int)leftBorder, (int)(j == yPasses ? remainderHeight : fillerHeight), (float)zLevel);
            GuiUtils.drawTexturedModalRect((int)(x + leftBorder + canvasWidth), (int)(y + topBorder + j * fillerHeight), (int)(u + leftBorder + fillerWidth), (int)(v + topBorder), (int)rightBorder, (int)(j == yPasses ? remainderHeight : fillerHeight), (float)zLevel);
        }
    }

    public static enum SliceMode {
        STRETCH,
        SLICED_TILE,
        SLICED_STRETCH;

    }
}

