/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.popups;

import betterquesting.api2.client.gui.SceneController;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.CanvasResizeable;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.content.PanelGeneric;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.resources.colors.GuiColorStatic;
import betterquesting.api2.client.gui.resources.textures.ColorTexture;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.lwjgl.util.vector.ReadableVector4f;
import org.lwjgl.util.vector.Vector4f;

public class PopChoice
extends CanvasEmpty {
    private final String message;
    private final IGuiTexture icon;
    private final Consumer<Integer> callback;
    private final String[] options;

    public PopChoice(@Nonnull String message, @Nonnull Consumer<Integer> callback, String ... options) {
        this(message, null, callback, options);
    }

    public PopChoice(@Nonnull String message, @Nullable IGuiTexture icon, @Nonnull Consumer<Integer> callback, String ... options) {
        super(new GuiTransform(GuiAlign.FULL_BOX));
        this.message = message;
        this.icon = icon;
        this.callback = callback;
        this.options = options;
    }

    @Override
    public void initPanel() {
        super.initPanel();
        this.addPanel(new PanelGeneric(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 1), new ColorTexture(new GuiColorStatic(Integer.MIN_VALUE))));
        CanvasResizeable cvBox = new CanvasResizeable(new GuiTransform((ReadableVector4f)new Vector4f(0.5f, 0.45f, 0.5f, 0.45f)), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel(cvBox);
        cvBox.lerpToRect(new GuiTransform((ReadableVector4f)new Vector4f(0.2f, 0.3f, 0.8f, 0.6f)), 200L, true);
        if (this.icon != null) {
            CanvasTextured icoFrame = new CanvasTextured(new GuiTransform((ReadableVector4f)new Vector4f(0.5f, 0.3f, 0.5f, 0.3f), -16, -40, 32, 32, 0), PresetTexture.PANEL_MAIN.getTexture());
            this.addPanel(icoFrame);
            icoFrame.addPanel(new PanelGeneric(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(8, 8, 8, 8), 0), this.icon));
        }
        cvBox.addPanel(new PanelTextBox(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(8, 8, 8, 8), 0), this.message).setAlignment(1));
        int maxW = 3;
        for (int i = 0; i < this.options.length; ++i) {
            int index = i;
            int rowY = i / 3;
            int rowX = i % 3;
            int rowW = Math.min(3, this.options.length - rowY * 3) * 112 - 16;
            PanelButton btn = new PanelButton(new GuiTransform((ReadableVector4f)new Vector4f(0.5f, 0.6f, 0.5f, 0.6f), -rowW / 2 + rowX * 112, 8 + 24 * rowY, 96, 16, 0), -1, this.options[i]);
            btn.setClickAction(b -> {
                this.callback.accept(index);
                if (SceneController.getActiveScene() != null) {
                    SceneController.getActiveScene().closePopup();
                }
            });
            this.addPanel(btn);
        }
    }

    @Override
    public boolean onMouseClick(int mx, int my, int click) {
        super.onMouseClick(mx, my, click);
        return true;
    }

    @Override
    public boolean onMouseRelease(int mx, int my, int click) {
        super.onMouseRelease(mx, my, click);
        return true;
    }

    @Override
    public boolean onMouseScroll(int mx, int my, int scroll) {
        super.onMouseScroll(mx, my, scroll);
        return true;
    }

    @Override
    public boolean onKeyTyped(char c, int keycode) {
        super.onKeyTyped(c, keycode);
        return true;
    }
}

