/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.events;

import betterquesting.api2.client.gui.events.PanelEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public class PEventEntry<T extends PanelEvent> {
    private final List<Consumer<PanelEvent>> listeners = new ArrayList<Consumer<PanelEvent>>();
    private final Class<T> cType;

    public PEventEntry(Class<T> type) {
        this.cType = type;
    }

    public void registerListener(@Nonnull Consumer<PanelEvent> consumer) {
        if (this.listeners.contains(consumer)) {
            return;
        }
        this.listeners.add(consumer);
    }

    public void unregisterListener(@Nonnull Consumer<PanelEvent> consumer) {
        this.listeners.remove(consumer);
    }

    public void fire(@Nonnull PanelEvent event) {
        if (!this.cType.isAssignableFrom(event.getClass())) {
            return;
        }
        this.listeners.forEach(l -> l.accept(event));
    }
}

