/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api.utils;

import betterquesting.NBTUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StringUtils;
import net.minecraftforge.oredict.OreIngredient;

public class BigItemStack {
    private static final short DEFAULT_DAMAGE = 0;
    private static final String DEFAULT_OREDICT = "";
    private static final OreIngredient NO_ORE = new OreIngredient("");
    private final ItemStack baseStack;
    public int stackSize;
    private String oreDict = "";
    private OreIngredient oreIng = NO_ORE;

    public BigItemStack(ItemStack stack) {
        this.baseStack = stack.func_77946_l();
        this.stackSize = this.baseStack.func_190916_E();
        this.baseStack.func_190920_e(1);
    }

    public BigItemStack(@Nonnull Block block) {
        this(block, 1);
    }

    public BigItemStack(@Nonnull Block block, int amount) {
        this(block, amount, 0);
    }

    public BigItemStack(@Nonnull Block block, int amount, int damage) {
        this(Item.func_150898_a((Block)block), amount, damage);
    }

    public BigItemStack(@Nonnull Item item) {
        this(item, 1);
    }

    public BigItemStack(@Nonnull Item item, int amount) {
        this(item, amount, 0);
    }

    public BigItemStack(@Nonnull Item item, int amount, int damage) {
        this.baseStack = new ItemStack(item, 1, damage);
        this.stackSize = amount;
    }

    public ItemStack getBaseStack() {
        return this.baseStack;
    }

    public boolean hasOreDict() {
        return !StringUtils.func_151246_b((String)this.oreDict) && this.oreIng.func_193365_a().length > 0;
    }

    @Nonnull
    public String getOreDict() {
        return this.oreDict;
    }

    @Nonnull
    public OreIngredient getOreIngredient() {
        return this.oreIng;
    }

    public BigItemStack setOreDict(@Nonnull String ore) {
        this.oreDict = ore;
        this.oreIng = ore.length() <= 0 ? NO_ORE : new OreIngredient(ore);
        return this;
    }

    public NBTTagCompound GetTagCompound() {
        return this.baseStack.func_77978_p();
    }

    public void SetTagCompound(NBTTagCompound tags) {
        this.baseStack.func_77982_d(tags);
    }

    public boolean HasTagCompound() {
        return this.baseStack.func_77942_o();
    }

    public List<ItemStack> getCombinedStacks() {
        int size;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int tmp1 = Math.max(1, this.stackSize); tmp1 > 0; tmp1 -= size) {
            size = Math.min(tmp1, this.baseStack.func_77976_d());
            ItemStack stack = this.baseStack.func_77946_l();
            stack.func_190920_e(size);
            list.add(stack);
        }
        return list;
    }

    public BigItemStack copy() {
        BigItemStack stack = new BigItemStack(this.baseStack.func_77946_l());
        stack.stackSize = this.stackSize;
        stack.oreDict = this.oreDict;
        stack.oreIng = this.oreIng;
        return stack;
    }

    public boolean equals(Object stack) {
        if (stack instanceof ItemStack) {
            return this.baseStack.func_77969_a((ItemStack)stack) && ItemStack.func_77970_a((ItemStack)this.baseStack, (ItemStack)((ItemStack)stack));
        }
        return super.equals(stack);
    }

    public BigItemStack(@Nonnull NBTTagCompound tags) {
        NBTTagCompound itemNBT = tags.func_74737_b();
        itemNBT.func_74768_a("Count", 1);
        if (tags.func_150297_b("id", 99)) {
            itemNBT.func_74778_a("id", String.valueOf(tags.func_74765_d("id")));
        }
        this.stackSize = NBTUtil.getInteger(tags, "Count", 1);
        this.setOreDict(tags.func_74779_i("OreDict"));
        this.baseStack = new ItemStack(itemNBT);
        if (tags.func_74765_d("Damage") < 0) {
            this.baseStack.func_77964_b(Short.MAX_VALUE);
        }
    }

    @Deprecated
    public NBTTagCompound writeToNBT(NBTTagCompound tags) {
        return this.writeToNBT(tags, false);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tags, boolean reduce) {
        this.baseStack.func_77955_b(tags);
        tags.func_74768_a("Count", this.stackSize);
        if (reduce && this.baseStack.func_77952_i() == 0) {
            tags.func_82580_o("Damage");
        }
        NBTUtil.setString(tags, "OreDict", this.oreDict, DEFAULT_OREDICT, reduce);
        return tags;
    }
}

