/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.jei.category;

import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.block.BlockUnpackager;
import thelm.packagedauto.integration.jei.PackagedAutoJEIPlugin;
import thelm.packagedauto.integration.jei.category.PackageProcessingWrapper;

public class PackageProcessingCategory
implements IRecipeCategory<PackageProcessingWrapper> {
    public static final String UID = "packagedauto:package_processing";
    private final IDrawable background;
    private final IDrawable icon;

    public PackageProcessingCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(PackagedAutoJEIPlugin.BACKGROUND, 108, 0, 140, 64);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((Block)BlockUnpackager.INSTANCE));
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return I18n.func_74838_a((String)"jei.category.packagedauto.package_processing");
    }

    public String getModName() {
        return "PackagedAuto";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayout recipeLayout, PackageProcessingWrapper recipeWrapper, IIngredients ingredients) {
        int index;
        int j;
        int i;
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        List<IPackagePattern> patterns = recipeWrapper.recipe.getPatterns();
        List<ItemStack> outputs = recipeWrapper.recipe.getOutputs();
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                index = i * 3 + j;
                stacks.init(index, true, j * 18, 10 + i * 18);
                if (index >= patterns.size()) continue;
                stacks.set(index, patterns.get(index).getOutput());
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                index = i * 3 + j;
                int slot = 9 + index;
                stacks.init(slot, false, 86 + j * 18, 10 + i * 18);
                if (index >= outputs.size()) continue;
                stacks.set(slot, outputs.get(index));
            }
        }
    }
}

