/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.client.gui;

import java.awt.Color;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thelm.packagedauto.api.IRecipeType;
import thelm.packagedauto.api.MiscUtil;
import thelm.packagedauto.client.gui.GuiContainerTileBase;
import thelm.packagedauto.container.ContainerEncoder;
import thelm.packagedauto.integration.jei.PackagedAutoJEIPlugin;
import thelm.packagedauto.network.PacketHandler;
import thelm.packagedauto.network.packet.PacketCycleRecipeType;
import thelm.packagedauto.network.packet.PacketLoadRecipeList;
import thelm.packagedauto.network.packet.PacketSaveRecipeList;
import thelm.packagedauto.network.packet.PacketSetPatternIndex;
import thelm.packagedauto.tile.TileEncoder;
import yalter.mousetweaks.api.MouseTweaksDisableWheelTweak;

@MouseTweaksDisableWheelTweak
public class GuiEncoder
extends GuiContainerTileBase<ContainerEncoder> {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("packagedauto:textures/gui/encoder.png");

    public GuiEncoder(ContainerEncoder container) {
        super(container);
        this.field_146999_f = 258;
        this.field_147000_g = 314;
    }

    @Override
    protected ResourceLocation getBackgroundTexture() {
        return BACKGROUND;
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        super.func_73866_w_();
        int patternSlots = ((TileEncoder)((ContainerEncoder)this.container).tile).patternInventories.length;
        for (int i = 0; i < patternSlots; ++i) {
            this.func_189646_b(new GuiButtonPatternSlot(i, this.field_147003_i + 29 + i % 10 * 18, this.field_147009_r + (patternSlots > 10 ? 16 : 25) + i / 10 * 18));
        }
        this.func_189646_b(new GuiButtonRecipeType(0, this.field_147003_i + 203, this.field_147009_r + 74));
        this.func_189646_b(new GuiButtonSavePatterns(0, this.field_147003_i + 213, this.field_147009_r + 16, I18n.func_74838_a((String)"tile.packagedauto.encoder.save")));
        this.func_189646_b(new GuiButtonLoadPatterns(0, this.field_147003_i + 213, this.field_147009_r + 34, I18n.func_74838_a((String)"tile.packagedauto.encoder.load")));
        if (Loader.isModLoaded((String)"jei")) {
            this.func_189646_b(new GuiButtonShowRecipesJEI(0, this.field_147003_i + 172, this.field_147009_r + 129));
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        Color color;
        int j;
        int i;
        super.func_146976_a(partialTicks, mouseX, mouseY);
        IRecipeType recipeType = ((ContainerEncoder)this.container).patternInventory.recipeType;
        for (i = 0; i < 9; ++i) {
            for (j = 0; j < 9; ++j) {
                color = recipeType.getSlotColor(i * 9 + j);
                GlStateManager.func_179131_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
                GuiEncoder.func_146110_a((int)(this.field_147003_i + 8 + j * 18), (int)(this.field_147009_r + 57 + i * 18), (float)258.0f, (float)0.0f, (int)16, (int)16, (float)512.0f, (float)512.0f);
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                color = recipeType.getSlotColor(81 + i * 3 + j);
                GlStateManager.func_179131_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
                GuiEncoder.func_146110_a((int)(this.field_147003_i + 198 + j * 18), (int)(this.field_147009_r + 111 + i * 18), (float)258.0f, (float)0.0f, (int)16, (int)16, (float)512.0f, (float)512.0f);
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        String s = ((ContainerEncoder)this.container).inventory.func_145748_c_().func_150260_c();
        this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(((ContainerEncoder)this.container).playerInventory.func_145748_c_().func_150260_c(), ((ContainerEncoder)this.container).getPlayerInvX(), ((ContainerEncoder)this.container).getPlayerInvY() - 11, 0x404040);
        String str = this.field_146289_q.func_78269_a(((ContainerEncoder)this.container).patternInventory.recipeType.getLocalizedNameShort(), 86);
        this.field_146289_q.func_78276_b(str, 212 - this.field_146289_q.func_78256_a(str) / 2, 64, 0x404040);
        for (GuiButton guibutton : this.field_146292_n) {
            if (!guibutton.func_146115_a()) continue;
            guibutton.func_146111_b(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
            break;
        }
    }

    @Override
    public int getItemAmountSpecificationLimit(Slot slot) {
        int stackLimit = slot.func_75211_c().func_77976_d();
        return slot.field_75222_d > 81 ? Math.max(stackLimit, 999) : stackLimit;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        boolean single;
        if (button instanceof GuiButtonPatternSlot) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSetPatternIndex(button.field_146127_k));
            ((TileEncoder)((ContainerEncoder)this.container).tile).setPatternIndex(button.field_146127_k);
            ((ContainerEncoder)this.container).setupSlots();
        }
        if (button instanceof GuiButtonRecipeType) {
            boolean reverse = GuiEncoder.func_146272_n();
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketCycleRecipeType(reverse));
            ((ContainerEncoder)this.container).patternInventory.cycleRecipeType(reverse);
            ((ContainerEncoder)this.container).setupSlots();
        }
        if (button instanceof GuiButtonSavePatterns) {
            single = GuiEncoder.func_146272_n();
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSaveRecipeList(single));
        }
        if (button instanceof GuiButtonLoadPatterns) {
            single = GuiEncoder.func_146272_n();
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketLoadRecipeList(single));
            ((TileEncoder)((ContainerEncoder)this.container).tile).loadRecipeList(single);
            ((ContainerEncoder)this.container).setupSlots();
        }
        if (button instanceof GuiButtonShowRecipesJEI) {
            MiscUtil.conditionalRunnable(() -> true, () -> () -> {
                IRecipeType recipeType = ((ContainerEncoder)this.container).patternInventory.recipeType;
                if (recipeType != null) {
                    PackagedAutoJEIPlugin.showCategories(recipeType.getJEICategories());
                }
            }, () -> () -> {}).run();
        }
    }

    class GuiButtonShowRecipesJEI
    extends GuiButton {
        GuiButtonShowRecipesJEI(int buttonId, int x, int y) {
            super(buttonId, x, y, 22, 16, "");
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                this.func_146119_b(mc, mouseX, mouseY);
            }
        }

        public void func_146111_b(int mouseX, int mouseY) {
            IRecipeType recipeType = ((ContainerEncoder)GuiEncoder.this.container).patternInventory.recipeType;
            if (recipeType != null && !recipeType.getJEICategories().isEmpty()) {
                GuiEncoder.this.func_146279_a(I18n.func_74838_a((String)"jei.tooltip.show.recipes"), mouseX, mouseY);
            }
        }
    }

    class GuiButtonLoadPatterns
    extends GuiButton {
        GuiButtonLoadPatterns(int buttonId, int x, int y, String text) {
            super(buttonId, x, y, 38, 18, text);
        }

        public void func_146111_b(int mouseX, int mouseY) {
            if (GuiScreen.func_146272_n()) {
                GuiEncoder.this.func_146279_a(I18n.func_74838_a((String)"tile.packagedauto.encoder.load_single"), mouseX, mouseY);
            }
        }
    }

    class GuiButtonSavePatterns
    extends GuiButton {
        GuiButtonSavePatterns(int buttonId, int x, int y, String text) {
            super(buttonId, x, y, 38, 18, text);
        }

        public void func_146111_b(int mouseX, int mouseY) {
            if (GuiScreen.func_146272_n()) {
                GuiEncoder.this.func_146279_a(I18n.func_74838_a((String)"tile.packagedauto.encoder.save_single"), mouseX, mouseY);
            }
        }
    }

    class GuiButtonRecipeType
    extends GuiButton {
        GuiButtonRecipeType(int buttonId, int x, int y) {
            super(buttonId, x, y, 18, 18, "");
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            super.func_191745_a(mc, mouseX, mouseY, partialTicks);
            IRecipeType recipeType = ((ContainerEncoder)GuiEncoder.this.container).patternInventory.recipeType;
            if (recipeType != null) {
                Object rep = recipeType.getRepresentation();
                if (rep instanceof TextureAtlasSprite) {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
                    this.func_175175_a(this.field_146128_h + 1, this.field_146129_i + 1, (TextureAtlasSprite)rep, 16, 16);
                }
                if (rep instanceof ItemStack) {
                    RenderHelper.func_74520_c();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    mc.func_175599_af().func_175042_a((ItemStack)rep, this.field_146128_h + 1, this.field_146129_i + 1);
                    RenderHelper.func_74518_a();
                }
            }
        }

        public void func_146111_b(int mouseX, int mouseY) {
            GuiEncoder.this.func_146279_a(I18n.func_74838_a((String)"tile.packagedauto.encoder.change_recipe_type"), mouseX, mouseY);
        }
    }

    class GuiButtonPatternSlot
    extends GuiButton {
        GuiButtonPatternSlot(int buttonId, int x, int y) {
            super(buttonId, x, y, 18, 18, "");
        }

        protected int func_146114_a(boolean mouseOver) {
            if (((TileEncoder)((ContainerEncoder)GuiEncoder.this.container).tile).patternIndex == this.field_146127_k) {
                return 2;
            }
            return super.func_146114_a(mouseOver);
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            super.func_191745_a(mc, mouseX, mouseY, partialTicks);
            for (int i = 81; i < 90; ++i) {
                ItemStack stack = (ItemStack)((TileEncoder)((ContainerEncoder)GuiEncoder.this.container).tile).patternInventories[this.field_146127_k].stacks.get(i);
                if (stack.func_190926_b()) continue;
                RenderHelper.func_74520_c();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_175599_af().func_175042_a(stack, this.field_146128_h + 1, this.field_146129_i + 1);
                RenderHelper.func_74518_a();
                break;
            }
        }

        public void func_146111_b(int mouseX, int mouseY) {
            GuiEncoder.this.func_146279_a(I18n.func_74837_a((String)"tile.packagedauto.encoder.pattern_slot", (Object[])new Object[]{String.format("%02d", this.field_146127_k)}), mouseX, mouseY);
        }
    }
}

